/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.InlineableResult;
import org.jetbrains.kotlin.js.inline.clean.RemoveDefaultInitializersKt;
import org.jetbrains.kotlin.js.inline.context.InliningContext;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FunctionUtilsKt;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;
import org.jetbrains.kotlin.js.inline.util.NamingUtilsKt;
import org.jetbrains.kotlin.js.inline.util.RewriteUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.ReturnReplacingVisitor;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 :2\u00020\u0001:\u0001:B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u00032\u0006\u0010'\u001a\u00020(H\u0002J \u0010)\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0007H\u0002J\u0010\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020\u0010H\u0002J\b\u0010.\u001a\u00020$H\u0002J\n\u0010/\u001a\u0004\u0018\u00010\u0014H\u0002J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020(01H\u0002J\u0010\u00102\u001a\u0002032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020501H\u0002J\b\u00106\u001a\u000207H\u0002J\b\u0010\u001d\u001a\u000207H\u0002J\b\u00108\u001a\u000207H\u0002J\u0006\u00109\u001a\u000207R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/js/inline/FunctionInlineMutator;", "", "call", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "inliningContext", "Lorg/jetbrains/kotlin/js/inline/context/InliningContext;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;Lorg/jetbrains/kotlin/js/inline/context/InliningContext;Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;)V", "invokedFunction", "namingContext", "Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "getNamingContext", "()Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "body", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "getBody", "()Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "resultExpr", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "getResultExpr", "()Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "setResultExpr", "(Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;)V", "resultName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "breakLabel", "Lorg/jetbrains/kotlin/js/backend/ast/JsLabel;", "getBreakLabel", "()Lorg/jetbrains/kotlin/js/backend/ast/JsLabel;", "setBreakLabel", "(Lorg/jetbrains/kotlin/js/backend/ast/JsLabel;)V", "currentStatement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "process", "", "uncoverClosure", "getInnerCall", "qualifier", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "applyCapturedArgs", "inner", "outer", "replaceThis", "block", "processReturns", "getResultReference", "getArguments", "", "isResultNeeded", "", "getParameters", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "getResultLabel", "", "getThisAlias", "getLabelPrefix", "Companion", "js.translator"})
@SourceDebugExtension(value={"SMAP\nFunctionInlineMutator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionInlineMutator.kt\norg/jetbrains/kotlin/js/inline/FunctionInlineMutator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n1#2:214\n*E\n"})
public final class FunctionInlineMutator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsInvocation call;
    @NotNull
    private final InliningContext inliningContext;
    @NotNull
    private final JsFunction invokedFunction;
    @NotNull
    private final NamingContext namingContext;
    @NotNull
    private final JsBlock body;
    @Nullable
    private JsNameRef resultExpr;
    @Nullable
    private JsName resultName;
    @Nullable
    private JsLabel breakLabel;
    @Nullable
    private final JsStatement currentStatement;

    private FunctionInlineMutator(JsInvocation call2, InliningContext inliningContext, JsFunction function2) {
        this.call = call2;
        this.inliningContext = inliningContext;
        this.namingContext = this.inliningContext.newNamingContext();
        this.currentStatement = this.inliningContext.getCurrentStatement();
        JsFunction jsFunction = function2.deepCopy();
        Intrinsics.checkNotNullExpressionValue(jsFunction, "deepCopy(...)");
        this.invokedFunction = this.uncoverClosure(jsFunction);
        this.body = this.invokedFunction.getBody();
    }

    @NotNull
    public final NamingContext getNamingContext() {
        return this.namingContext;
    }

    @NotNull
    public final JsBlock getBody() {
        return this.body;
    }

    @Nullable
    public final JsNameRef getResultExpr() {
        return this.resultExpr;
    }

    public final void setResultExpr(@Nullable JsNameRef jsNameRef) {
        this.resultExpr = jsNameRef;
    }

    @Nullable
    public final JsLabel getBreakLabel() {
        return this.breakLabel;
    }

    public final void setBreakLabel(@Nullable JsLabel jsLabel) {
        this.breakLabel = jsLabel;
    }

    /*
     * WARNING - void declaration
     */
    private final void process() {
        JsNameRef jsNameRef;
        List<JsExpression> arguments = null;
        arguments = this.getArguments();
        List<JsParameter> parameters = this.getParameters();
        if (arguments.size() > parameters.size()) {
            boolean bl;
            boolean bl2 = bl = arguments.size() == parameters.size() + 1;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "arguments.size (" + arguments.size() + ") may only exceed the parameters.size (" + parameters.size() + ") by one and only in case of suspend conversions";
                throw new AssertionError((Object)string2);
            }
            arguments = arguments.subList(0, parameters.size());
        }
        RemoveDefaultInitializersKt.removeDefaultInitializers(arguments, parameters, this.body);
        NamingUtilsKt.aliasArgumentsIfNeeded(this.namingContext, arguments, parameters, this.call.getSource());
        NamingUtilsKt.renameLocalNames(this.namingContext, this.invokedFunction);
        this.processReturns();
        this.namingContext.applyRenameTo(this.body);
        FunctionInlineMutator functionInlineMutator = this;
        JsNameRef jsNameRef2 = this.resultExpr;
        if (jsNameRef2 != null) {
            void it;
            JsNameRef jsNameRef3 = jsNameRef2;
            FunctionInlineMutator functionInlineMutator2 = functionInlineMutator;
            boolean bl = false;
            JsNode jsNode = this.namingContext.applyRenameTo((JsNode)it);
            Intrinsics.checkNotNull(jsNode, "null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsNameRef");
            jsNameRef = (JsNameRef)jsNode;
            functionInlineMutator = functionInlineMutator2;
        } else {
            jsNameRef = null;
        }
        functionInlineMutator.resultExpr = jsNameRef;
    }

    private final JsFunction uncoverClosure(JsFunction invokedFunction) {
        JsFunction jsFunction;
        JsFunction innerFunction = FunctionUtilsKt.getInnerFunction(invokedFunction);
        JsExpression jsExpression = this.call.getQualifier();
        Intrinsics.checkNotNullExpressionValue(jsExpression, "getQualifier(...)");
        JsInvocation innerCall = this.getInnerCall(jsExpression);
        if (innerCall != null && innerFunction != null) {
            JsFunction jsFunction2;
            JsFunction $this$uncoverClosure_u24lambda_u242 = jsFunction2 = innerFunction;
            boolean bl = false;
            JsBlock jsBlock = $this$uncoverClosure_u24lambda_u242.getBody();
            Intrinsics.checkNotNullExpressionValue(jsBlock, "getBody(...)");
            this.replaceThis(jsBlock);
            this.applyCapturedArgs(innerCall, $this$uncoverClosure_u24lambda_u242, invokedFunction);
            jsFunction = jsFunction2;
        } else {
            JsFunction jsFunction3;
            JsFunction $this$uncoverClosure_u24lambda_u243 = jsFunction3 = invokedFunction;
            boolean bl = false;
            JsBlock jsBlock = $this$uncoverClosure_u24lambda_u243.getBody();
            Intrinsics.checkNotNullExpressionValue(jsBlock, "getBody(...)");
            this.replaceThis(jsBlock);
            jsFunction = jsFunction3;
        }
        return jsFunction;
    }

    private final JsInvocation getInnerCall(JsExpression qualifier) {
        JsInvocation jsInvocation;
        JsExpression jsExpression = qualifier;
        if (jsExpression instanceof JsInvocation) {
            jsInvocation = (JsInvocation)qualifier;
        } else if (jsExpression instanceof JsNameRef) {
            JsExpression callee;
            JsExpression jsExpression2;
            if (Intrinsics.areEqual(((JsNameRef)qualifier).getIdent(), "call")) {
                jsExpression2 = ((JsNameRef)qualifier).getQualifier();
            } else {
                JsName jsName = ((JsNameRef)qualifier).getName();
                JsNode jsNode = jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
                jsExpression2 = jsNode instanceof JsExpression ? (JsExpression)jsNode : null;
            }
            JsExpression jsExpression3 = callee = jsExpression2;
            if (jsExpression3 != null) {
                JsExpression it = jsExpression3;
                boolean bl = false;
                jsInvocation = this.getInnerCall(it);
            } else {
                jsInvocation = null;
            }
        } else {
            jsInvocation = null;
        }
        return jsInvocation;
    }

    private final void applyCapturedArgs(JsInvocation call2, JsFunction inner, JsFunction outer) {
        NamingContext namingContext = this.inliningContext.newNamingContext();
        List<JsExpression> list = call2.getArguments();
        Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
        List<JsExpression> arguments = list;
        List<JsParameter> list2 = outer.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getParameters(...)");
        List<JsParameter> parameters = list2;
        NamingUtilsKt.aliasArgumentsIfNeeded(namingContext, arguments, parameters, call2.getSource());
        namingContext.applyRenameTo(inner);
    }

    private final void replaceThis(JsBlock block) {
        if (!FunctionInlineMutator.Companion.hasThisReference(block)) {
            return;
        }
        JsExpression thisReplacement = FunctionInlineMutator.Companion.getThisReplacement(this.call);
        if (thisReplacement == null || thisReplacement instanceof JsThisRef) {
            return;
        }
        JsName jsName = JsScope.declareTemporaryName(this.getThisAlias());
        Intrinsics.checkNotNullExpressionValue(jsName, "declareTemporaryName(...)");
        JsName thisName = jsName;
        this.namingContext.newVar(thisName, thisReplacement, this.call.getSource());
        thisReplacement = thisName.makeRef();
        RewriteUtilsKt.replaceThisReference((JsNode)block, thisReplacement);
    }

    /*
     * WARNING - void declaration
     */
    private final void processReturns() {
        void $this$processReturns_u24lambda_u245;
        JsLabel jsLabel;
        this.resultExpr = this.getResultReference();
        JsName jsName = JsScope.declareTemporaryName(this.getBreakLabel());
        Intrinsics.checkNotNullExpressionValue(jsName, "declareTemporaryName(...)");
        JsName breakName = jsName;
        JsLabel jsLabel2 = jsLabel = new JsLabel(breakName);
        FunctionInlineMutator functionInlineMutator = this;
        boolean bl = false;
        MetadataProperties.setSynthetic((HasMetadata)$this$processReturns_u24lambda_u245, true);
        functionInlineMutator.breakLabel = jsLabel;
        ReturnReplacingVisitor visitor2 = new ReturnReplacingVisitor(this.resultExpr, breakName.makeRef(), this.invokedFunction, MetadataProperties.isSuspend(this.call));
        visitor2.accept((JsNode)this.body);
    }

    private final JsNameRef getResultReference() {
        JsName resultName;
        if (!this.isResultNeeded(this.call)) {
            return null;
        }
        JsName jsName = JsScope.declareTemporaryName(this.getResultLabel());
        Intrinsics.checkNotNullExpressionValue(jsName, "declareTemporaryName(...)");
        this.resultName = resultName = jsName;
        NamingContext.newVar$default(this.namingContext, resultName, null, this.call.getSource(), 2, null);
        return resultName.makeRef();
    }

    private final List<JsExpression> getArguments() {
        List<JsExpression> list = this.call.getArguments();
        Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
        List<JsExpression> arguments = list;
        if (InvocationUtilsKt.isCallInvocation(this.call)) {
            return arguments.subList(1, arguments.size());
        }
        return arguments;
    }

    private final boolean isResultNeeded(JsInvocation call2) {
        return !(this.currentStatement instanceof JsExpressionStatement) || !Intrinsics.areEqual(call2, ((JsExpressionStatement)this.currentStatement).getExpression());
    }

    private final List<JsParameter> getParameters() {
        List<JsParameter> list = this.invokedFunction.getParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
        return list;
    }

    private final String getResultLabel() {
        return this.getLabelPrefix() + "result";
    }

    private final String getBreakLabel() {
        return this.getLabelPrefix() + "break";
    }

    private final String getThisAlias() {
        return "$this";
    }

    @NotNull
    public final String getLabelPrefix() {
        String labelPrefix;
        String ident = InvocationUtilsKt.getSimpleIdent(this.call);
        String string2 = ident;
        if (string2 == null) {
            string2 = "inline$";
        }
        if (StringsKt.endsWith$default(labelPrefix = string2, "$", false, 2, null)) {
            return labelPrefix;
        }
        return labelPrefix + '$';
    }

    @JvmStatic
    @NotNull
    public static final InlineableResult getInlineableCallReplacement(@NotNull JsInvocation call2, @NotNull JsFunction function2, @NotNull InliningContext inliningContext) {
        return Companion.getInlineableCallReplacement(call2, function2, inliningContext);
    }

    public /* synthetic */ FunctionInlineMutator(JsInvocation call2, InliningContext inliningContext, JsFunction function2, DefaultConstructorMarker $constructor_marker) {
        this(call2, inliningContext, function2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/js/inline/FunctionInlineMutator$Companion;", "", "<init>", "()V", "getInlineableCallReplacement", "Lorg/jetbrains/kotlin/js/inline/InlineableResult;", "call", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "inliningContext", "Lorg/jetbrains/kotlin/js/inline/context/InliningContext;", "getThisReplacement", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "hasThisReference", "", "body", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "js.translator"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final InlineableResult getInlineableCallReplacement(@NotNull JsInvocation call2, @NotNull JsFunction function2, @NotNull InliningContext inliningContext) {
            Intrinsics.checkNotNullParameter(call2, "call");
            Intrinsics.checkNotNullParameter(function2, "function");
            Intrinsics.checkNotNullParameter(inliningContext, "inliningContext");
            FunctionInlineMutator mutator = new FunctionInlineMutator(call2, inliningContext, function2, null);
            mutator.process();
            JsStatement inlineableBody = mutator.getBody();
            JsLabel breakLabel = mutator.getBreakLabel();
            if (breakLabel != null) {
                breakLabel.setStatement(inlineableBody);
                inlineableBody = breakLabel;
            }
            return new InlineableResult(inlineableBody, mutator.getResultExpr());
        }

        @JvmStatic
        private final JsExpression getThisReplacement(JsInvocation call2) {
            if (InvocationUtilsKt.isCallInvocation(call2)) {
                return call2.getArguments().get(0);
            }
            if (InvocationUtilsKt.hasCallerQualifier(call2)) {
                return InvocationUtilsKt.getCallerQualifier(call2);
            }
            return null;
        }

        private final boolean hasThisReference(JsBlock body2) {
            List thisRefs = CollectUtilsKt.collectInstances$default(JsThisRef.class, body2, false, 4, null);
            return !thisRefs.isEmpty();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

