/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower.indy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.MfvcNodeKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmDefaultUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.indy.LambdaMetafactoryArguments;
import org.jetbrains.kotlin.backend.jvm.lower.indy.MetafactoryArgumentsResult;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrFunctionWithLateBinding;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.overrides.FakeOverrideBuilderStrategyKt;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrSimpleFunctionSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrTypeErasureUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002MNB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nJ\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010\u0018\u001a\u00020\n*\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\n*\u00020\u0019H\u0002J2\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\nH\u0002J(\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u00102\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\f\u0010'\u001a\u00020\n*\u00020\u0015H\u0002J \u0010(\u001a\u00020)2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-H\u0002J4\u0010.\u001a\u00020)2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020-002\f\u00101\u001a\b\u0012\u0004\u0012\u00020-002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0006H\u0002J\u0010\u00102\u001a\u00020)2\u0006\u00103\u001a\u00020\u0006H\u0002J\u001e\u00104\u001a\u00020-*\u00020-2\u0006\u00105\u001a\u00020\u00062\b\b\u0002\u00106\u001a\u000207H\u0002J\u0018\u00108\u001a\u00020)2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"H\u0002J\u000e\u00109\u001a\u00020\n*\u0004\u0018\u00010&H\u0002J\u000e\u0010:\u001a\u00020\n*\u0004\u0018\u00010&H\u0002J\u001a\u0010;\u001a\u0004\u0018\u00010\"2\u0006\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u0006H\u0002J\u001a\u0010>\u001a\u0004\u0018\u00010&2\u0006\u0010?\u001a\u00020\u00102\u0006\u0010@\u001a\u00020\u0010H\u0002J\u0010\u0010A\u001a\u00020\u00192\u0006\u0010$\u001a\u00020BH\u0002J\u001a\u0010C\u001a\u0004\u0018\u00010&2\u0006\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u0006H\u0002J\u001a\u0010D\u001a\u0004\u0018\u00010\"2\u0006\u0010E\u001a\u00020\"2\u0006\u0010F\u001a\u00020\"H\u0002J\u001e\u0010G\u001a\u0004\u0018\u00010&2\b\u0010H\u001a\u0004\u0018\u00010&2\b\u0010I\u001a\u0004\u0018\u00010&H\u0002J\f\u0010J\u001a\u00020\n*\u00020KH\u0002J\f\u0010L\u001a\u00020\n*\u00020KH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArgumentsBuilder;", "", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "crossinlineLambdas", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Ljava/util/Set;)V", "isJavaSamConversionWithEqualsHashCode", "", "getLambdaMetafactoryArguments", "Lorg/jetbrains/kotlin/backend/jvm/lower/indy/MetafactoryArgumentsResult;", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "samType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "plainLambda", "forceSerializability", "isConstructorRequiringAccessor", "implFun", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "javaIoSerializableFqn", "Lorg/jetbrains/kotlin/name/FqName;", "isInheritedFromSerializable", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "requiresDelegationToDefaultImpls", "getLambdaMetafactoryArgsOrNullInner", "Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArguments;", "samMethod", "shouldBeSerializable", "checkMethodSignatureCompliance", "fakeInstanceMethod", "constraints", "Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArgumentsBuilder$SignatureAdaptationConstraints;", "checkTypeCompliesWithConstraint", "irType", "constraint", "Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArgumentsBuilder$TypeAdaptationConstraint;", "isAdaptable", "adaptLambdaSignature", "", "makeLambdaParameterNullable", "function", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "validateMethodParameters", "implParameters", "", "methodParameters", "adjustLambdaFunction", "lambda", "copy", "parent", "newName", "Lorg/jetbrains/kotlin/name/Name;", "adaptFakeInstanceMethodSignature", "requiresInstanceMethodBoxing", "requiresImplLambdaBoxing", "computeSignatureAdaptationConstraints", "adapteeFun", "expectedFun", "computeParameterTypeAdaptationConstraint", "adapteeType", "expectedType", "getErasedClassForSignatureAdaptation", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "computeReturnTypeAdaptationConstraint", "joinSignatureAdaptationConstraints", "sig1", "sig2", "composeTypeAdaptationConstraints", "t1", "t2", "isInlineFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "isCrossinlineLambda", "TypeAdaptationConstraint", "SignatureAdaptationConstraints", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nLambdaMetafactoryArguments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LambdaMetafactoryArguments.kt\norg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArgumentsBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,675:1\n1761#2,3:676\n1761#2,3:679\n1761#2,3:684\n1761#2,3:687\n827#2:690\n855#2,2:691\n1617#2,9:697\n1869#2:706\n1870#2:708\n1626#2:709\n1869#2,2:710\n1255#3,2:682\n51#4,4:693\n363#4,4:712\n1#5:707\n*S KotlinDebug\n*F\n+ 1 LambdaMetafactoryArguments.kt\norg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArgumentsBuilder\n*L\n130#1:676,3\n176#1:679,3\n203#1:684,3\n235#1:687,3\n263#1:690\n263#1:691,2\n369#1:697,9\n369#1:706\n369#1:708\n369#1:709\n462#1:710,2\n195#1:682,2\n268#1:693,4\n471#1:712,4\n369#1:707\n*E\n"})
public final class LambdaMetafactoryArgumentsBuilder {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final Set<IrSimpleFunction> crossinlineLambdas;
    private final boolean isJavaSamConversionWithEqualsHashCode;
    @NotNull
    private final FqName javaIoSerializableFqn;

    public LambdaMetafactoryArgumentsBuilder(@NotNull JvmBackendContext context2, @NotNull Set<? extends IrSimpleFunction> crossinlineLambdas) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(crossinlineLambdas, "crossinlineLambdas");
        this.context = context2;
        this.crossinlineLambdas = crossinlineLambdas;
        this.isJavaSamConversionWithEqualsHashCode = this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.JavaSamConversionEqualsHashCode);
        FqName fqName = new FqName("java.io");
        Name name2 = Name.identifier("Serializable");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        this.javaIoSerializableFqn = fqName.child(name2);
    }

    @NotNull
    public final MetafactoryArgumentsResult getLambdaMetafactoryArguments(@NotNull IrFunctionReference reference2, @NotNull IrType samType, boolean plainLambda, boolean forceSerializability) {
        boolean bl;
        Iterator<Object> iterator2;
        boolean $i$f$any;
        Object $this$any$iv;
        Object element$iv3;
        IrFunction implFun;
        IrSimpleFunction samMethod;
        boolean functionHazard;
        boolean shouldBeSerializable;
        boolean inliningHazard;
        boolean abiHazard;
        boolean semanticsHazard;
        block36: {
            int parametersCount;
            IrDeclarationParent implFunParent;
            boolean bl2;
            block34: {
                Intrinsics.checkNotNullParameter(reference2, "reference");
                Intrinsics.checkNotNullParameter(samType, "samType");
                IrClass irClass = IrTypesKt.getClass(samType);
                if (irClass == null) {
                    throw new AssertionError((Object)("SAM type is not a class: " + RenderIrElementKt.render$default(samType, null, 1, null)));
                }
                IrClass samClass = irClass;
                semanticsHazard = false;
                abiHazard = false;
                inliningHazard = false;
                shouldBeSerializable = false;
                functionHazard = false;
                if (!(IrUtilsKt.isLambda(reference2.getOrigin()) || IrUtilsKt.isFromJava(samClass) && !this.isJavaSamConversionWithEqualsHashCode)) {
                    semanticsHazard = true;
                }
                if (forceSerializability || this.isInheritedFromSerializable(samClass)) {
                    shouldBeSerializable = true;
                }
                IrSimpleFunction irSimpleFunction = JvmIrUtilsKt.getSingleAbstractMethod(samClass);
                if (irSimpleFunction == null) {
                    throw new AssertionError((Object)("SAM class has no single abstract method: " + RenderIrElementKt.render$default(samClass, null, 1, null)));
                }
                samMethod = irSimpleFunction;
                if (samMethod.isSuspend()) {
                    abiHazard = true;
                }
                if (this.requiresDelegationToDefaultImpls(samClass)) {
                    abiHazard = true;
                }
                implFun = ((IrFunctionSymbol)reference2.getSymbol()).getOwner();
                Iterable $this$any$iv2 = implFun.getTypeParameters();
                boolean $i$f$any2 = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv2) {
                        IrTypeParameter it = (IrTypeParameter)element$iv2;
                        boolean bl3 = false;
                        if (!it.isReified()) continue;
                        bl2 = true;
                        break block34;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                functionHazard = true;
            }
            if (this.context.getGetIntrinsic().invoke(implFun.getSymbol()) != null) {
                functionHazard = true;
            }
            if (implFun.isInline()) {
                functionHazard = true;
            }
            if (this.isConstructorRequiringAccessor(implFun)) {
                functionHazard = true;
            }
            if (implFun instanceof IrSimpleFunction) {
                IrClass baseFunClass;
                IrSimpleFunction baseFun = JvmIrUtilsKt.findSuperDeclaration((IrSimpleFunction)implFun);
                IrDeclarationParent irDeclarationParent = baseFun.getParent();
                IrClass irClass = baseFunClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
                if (baseFunClass != null && Intrinsics.areEqual(baseFunClass.getVisibility(), JavaDescriptorVisibilities.PACKAGE_VISIBILITY)) {
                    functionHazard = true;
                }
            }
            if ((implFunParent = implFun.getParent()) instanceof IrClass && Intrinsics.areEqual(((IrClass)implFunParent).getOrigin(), IrDeclarationOrigin.Companion.getJVM_MULTIFILE_CLASS())) {
                functionHazard = true;
            }
            if (!this.context.getConfig().getIndyAllowAnnotatedLambdas() && IrUtilsKt.isLambda(reference2.getOrigin())) {
                boolean bl4;
                block35: {
                    Iterable $this$any$iv3 = implFun.getAnnotations();
                    boolean $i$f$any3 = false;
                    if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                        bl4 = false;
                    } else {
                        for (Object element$iv3 : $this$any$iv3) {
                            IrConstructorCall annotation = (IrConstructorCall)element$iv3;
                            boolean bl5 = false;
                            if (!(IrUtilsKt.getAnnotationRetention(AdditionalIrUtilsKt.getConstructedClass((IrConstructor)annotation.getSymbol().getOwner())) == KotlinRetention.RUNTIME)) continue;
                            bl4 = true;
                            break block35;
                        }
                        bl4 = false;
                    }
                }
                if (bl4) {
                    abiHazard = true;
                }
            }
            if (AdditionalIrUtilsKt.hasAnnotation(implFun.getAnnotations(), JvmAnnotationUtilKt.JVM_SERIALIZABLE_LAMBDA_ANNOTATION_FQ_NAME)) {
                semanticsHazard = true;
            }
            if (plainLambda && (parametersCount = implFun.getParameters().size()) >= 23) {
                abiHazard = true;
            }
            $this$any$iv = IrUtilsKt.getParents(implFun);
            $i$f$any = false;
            iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv3 = iterator2.next();
                IrDeclarationParent it = (IrDeclarationParent)element$iv3;
                boolean bl6 = false;
                if (!(this.isInlineFunction(it) || this.isCrossinlineLambda(it))) continue;
                bl = true;
                break block36;
            }
            bl = false;
        }
        if (bl) {
            inliningHazard = true;
        }
        if (samType instanceof IrSimpleType) {
            boolean bl7;
            block37: {
                $this$any$iv = ((IrSimpleType)samType).getArguments();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl7 = false;
                } else {
                    iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        element$iv3 = iterator2.next();
                        IrTypeArgument it = (IrTypeArgument)element$iv3;
                        boolean bl8 = false;
                        if (!(it instanceof IrStarProjection || it instanceof IrTypeProjection && ((IrTypeProjection)it).getVariance() != Variance.INVARIANT)) continue;
                        bl7 = true;
                        break block37;
                    }
                    bl7 = false;
                }
            }
            if (bl7) {
                abiHazard = true;
            }
        }
        if (semanticsHazard) {
            return MetafactoryArgumentsResult.Failure.LambdaMetafactorySemanticsHazard.INSTANCE;
        }
        if (abiHazard) {
            return MetafactoryArgumentsResult.Failure.LambdaMetafactoryAbiHazard.INSTANCE;
        }
        if (inliningHazard) {
            return MetafactoryArgumentsResult.Failure.InliningHazard.INSTANCE;
        }
        if (functionHazard) {
            return MetafactoryArgumentsResult.Failure.FunctionHazard.INSTANCE;
        }
        LambdaMetafactoryArguments lambdaMetafactoryArguments = this.getLambdaMetafactoryArgsOrNullInner(reference2, samMethod, samType, implFun, shouldBeSerializable);
        return lambdaMetafactoryArguments != null ? (MetafactoryArgumentsResult)lambdaMetafactoryArguments : (MetafactoryArgumentsResult)MetafactoryArgumentsResult.Failure.FunctionHazard.INSTANCE;
    }

    private final boolean isConstructorRequiringAccessor(IrFunction implFun) {
        if (!(implFun instanceof IrConstructor)) {
            return false;
        }
        DescriptorVisibility visibility = implFun.getVisibility();
        return Intrinsics.areEqual(visibility, DescriptorVisibilities.PROTECTED) || DescriptorVisibilities.isPrivate(visibility);
    }

    private final boolean isInheritedFromSerializable(IrClass $this$isInheritedFromSerializable) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = IrTypeUtilsKt.getAllSuperclasses($this$isInheritedFromSerializable);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrClass it = (IrClass)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(IrUtilsKt.getFqNameWhenAvailable(it), this.javaIoSerializableFqn)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean requiresDelegationToDefaultImpls(IrClass $this$requiresDelegationToDefaultImpls) {
        Sequence<IrSimpleFunction> functionsAndAccessors = SequencesKt.plus(SequencesKt.plus(IrUtilsKt.getFunctions($this$requiresDelegationToDefaultImpls), SequencesKt.mapNotNull(IrUtilsKt.getProperties($this$requiresDelegationToDefaultImpls), LambdaMetafactoryArgumentsBuilder::requiresDelegationToDefaultImpls$lambda$5)), SequencesKt.mapNotNull(IrUtilsKt.getProperties($this$requiresDelegationToDefaultImpls), LambdaMetafactoryArgumentsBuilder::requiresDelegationToDefaultImpls$lambda$6));
        Iterator<IrSimpleFunction> iterator2 = functionsAndAccessors.iterator();
        while (iterator2.hasNext()) {
            IrSimpleFunction irImplFun;
            IrSimpleFunction irSimpleFunction;
            IrSimpleFunction irMemberFun = iterator2.next();
            if (irMemberFun.getModality() == Modality.ABSTRACT) continue;
            if (irMemberFun.isFakeOverride()) {
                irSimpleFunction = JvmDefaultUtilsKt.findInterfaceImplementation$default(irMemberFun, this.context.getConfig().getJvmDefaultMode(), false, 2, null);
                if (irSimpleFunction == null) {
                    continue;
                }
            } else {
                irSimpleFunction = irMemberFun;
            }
            if (Intrinsics.areEqual((irImplFun = irSimpleFunction).getOrigin(), IrDeclarationOrigin.Companion.getIR_EXTERNAL_JAVA_DECLARATION_STUB()) || JvmDefaultUtilsKt.isCompiledToJvmDefault(irImplFun, this.context.getConfig().getJvmDefaultMode())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final LambdaMetafactoryArguments getLambdaMetafactoryArgsOrNullInner(IrFunctionReference reference2, IrSimpleFunction samMethod, IrType samType, IrFunction implFun, boolean shouldBeSerializable) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = IrUtilsKt.allOverridden$default(samMethod, false, 1, null);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv$iv;
            boolean bl = false;
            if (it.isFakeOverride()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List<IrSimpleFunction> nonFakeOverriddenFuns = (List<IrSimpleFunction>)destination$iv$iv;
        List<IrSimpleFunction> relevantOverriddenFuns = samMethod.isFakeOverride() ? nonFakeOverriddenFuns : CollectionsKt.plus((Collection)nonFakeOverriddenFuns, samMethod);
        IrFactory $this$buildClass$iv = this.context.getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
        boolean bl = false;
        IrClassBuilder $this$getLambdaMetafactoryArgsOrNullInner_u24lambda_u248 = $this$buildClass_u24lambda_u241$iv;
        boolean bl2 = false;
        Name name2 = Name.special("<fake>");
        Intrinsics.checkNotNullExpressionValue(name2, "special(...)");
        $this$getLambdaMetafactoryArgsOrNullInner_u24lambda_u248.setName(name2);
        IrClass fakeClass = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u241$iv);
        fakeClass.setParent(this.context.getSymbols().getKotlinJvmInternalInvokeDynamicPackage());
        IrOverridableMember irOverridableMember = FakeOverrideBuilderStrategyKt.buildFakeOverrideMember$default(samType, samMethod, fakeClass, null, 8, null);
        Intrinsics.checkNotNull(irOverridableMember, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
        IrSimpleFunction fakeInstanceMethod = (IrSimpleFunction)irOverridableMember;
        ((IrFunctionWithLateBinding)fakeInstanceMethod).acquireSymbol(new IrSimpleFunctionSymbolImpl(null, null, 3, null));
        fakeInstanceMethod.setOverriddenSymbols((List<? extends IrSimpleFunctionSymbol>)CollectionsKt.listOf(samMethod.getSymbol()));
        LambdaMetafactoryArgumentsBuilder $this$getLambdaMetafactoryArgsOrNullInner_u24lambda_u249 = this;
        boolean bl3 = false;
        SignatureAdaptationConstraints result2 = new SignatureAdaptationConstraints(MapsKt.emptyMap(), null);
        for (IrSimpleFunction overriddenFun : relevantOverriddenFuns) {
            SignatureAdaptationConstraints constraintsFromOverridden;
            if ($this$getLambdaMetafactoryArgsOrNullInner_u24lambda_u249.computeSignatureAdaptationConstraints(fakeInstanceMethod, overriddenFun) == null) {
                return null;
            }
            if ($this$getLambdaMetafactoryArgsOrNullInner_u24lambda_u249.joinSignatureAdaptationConstraints(result2, constraintsFromOverridden) != null) continue;
            return null;
        }
        SignatureAdaptationConstraints signatureAdaptationConstraints = result2;
        if (signatureAdaptationConstraints.hasConflicts()) {
            return null;
        }
        this.adaptFakeInstanceMethodSignature(fakeInstanceMethod, signatureAdaptationConstraints);
        if (this.isAdaptable(implFun)) {
            Intrinsics.checkNotNull(implFun, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
            this.adaptLambdaSignature((IrSimpleFunction)implFun, fakeInstanceMethod, signatureAdaptationConstraints);
        } else if (!this.checkMethodSignatureCompliance(implFun, fakeInstanceMethod, signatureAdaptationConstraints, reference2)) {
            return null;
        }
        if (Intrinsics.areEqual(implFun.getOrigin(), IrDeclarationOrigin.Companion.getLOCAL_FUNCTION_FOR_LAMBDA()) || AdditionalIrUtilsKt.isAnonymousFunction(implFun)) {
            Intrinsics.checkNotNull(implFun, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
            this.adjustLambdaFunction((IrSimpleFunction)implFun);
        }
        if (samMethod.isFakeOverride() && nonFakeOverriddenFuns.size() == 1) {
            return new LambdaMetafactoryArguments(CollectionsKt.single(nonFakeOverriddenFuns), fakeInstanceMethod, reference2, CollectionsKt.emptyList(), shouldBeSerializable);
        }
        return new LambdaMetafactoryArguments(samMethod, fakeInstanceMethod, reference2, nonFakeOverriddenFuns, shouldBeSerializable);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkMethodSignatureCompliance(IrFunction implFun, IrSimpleFunction fakeInstanceMethod, SignatureAdaptationConstraints constraints, IrFunctionReference reference2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = CollectionsKt.zip((Iterable)implFun.getParameters(), reference2.getArguments());
        boolean $i$f$mapNotNull = false;
        Pair pair3 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrValueParameter it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Pair pair2 = (Pair)element$iv$iv;
            boolean bl2 = false;
            IrValueParameter implParameter = (IrValueParameter)pair2.component1();
            IrExpression referenceArgument = (IrExpression)pair2.component2();
            if ((referenceArgument == null ? implParameter : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List implParameters = (List)destination$iv$iv;
        List<IrValueParameter> methodParameters = IrUtilsKt.getNonDispatchParameters(fakeInstanceMethod);
        this.validateMethodParameters(implParameters, methodParameters, implFun, fakeInstanceMethod);
        for (Pair pair3 : CollectionsKt.zip((Iterable)implParameters, (Iterable)methodParameters)) {
            IrValueParameter implParameter = (IrValueParameter)pair3.component1();
            IrValueParameter methodParameter = (IrValueParameter)pair3.component2();
            TypeAdaptationConstraint constraint = constraints.getParameters().get(methodParameter);
            if (this.checkTypeCompliesWithConstraint(implParameter.getType(), constraint)) continue;
            return false;
        }
        if (!this.checkTypeCompliesWithConstraint(implFun.getReturnType(), constraints.getReturnType())) {
            return false;
        }
        return !IrTypePredicatesKt.isUnit(implFun.getReturnType()) || IrTypePredicatesKt.isUnit(fakeInstanceMethod.getReturnType());
    }

    private final boolean checkTypeCompliesWithConstraint(IrType irType, TypeAdaptationConstraint constraint) {
        boolean bl;
        TypeAdaptationConstraint typeAdaptationConstraint = constraint;
        switch (typeAdaptationConstraint == null ? -1 : WhenMappings.$EnumSwitchMapping$0[typeAdaptationConstraint.ordinal()]) {
            case -1: {
                bl = true;
                break;
            }
            case 1: {
                bl = IrTypeUtilsKt.isNullable(irType);
                break;
            }
            case 2: {
                if (!IrTypeUtilsKt.isNullable(irType)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                if (IrTypePredicatesKt.getPrimitiveType(irType) != null) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final boolean isAdaptable(IrFunction $this$isAdaptable) {
        IrDeclarationOrigin irDeclarationOrigin = $this$isAdaptable.getOrigin();
        return Intrinsics.areEqual(irDeclarationOrigin, IrDeclarationOrigin.Companion.getLOCAL_FUNCTION_FOR_LAMBDA()) || Intrinsics.areEqual(irDeclarationOrigin, JvmLoweredDeclarationOrigin.INSTANCE.getPROXY_FUN_FOR_METAFACTORY()) || Intrinsics.areEqual(irDeclarationOrigin, JvmLoweredDeclarationOrigin.INSTANCE.getSYNTHETIC_PROXY_FUN_FOR_METAFACTORY()) ? true : (Intrinsics.areEqual(irDeclarationOrigin, IrDeclarationOrigin.Companion.getLOCAL_FUNCTION()) ? AdditionalIrUtilsKt.isAnonymousFunction($this$isAdaptable) : false);
    }

    private final void adaptLambdaSignature(IrSimpleFunction implFun, IrSimpleFunction fakeInstanceMethod, SignatureAdaptationConstraints constraints) {
        if (!this.isAdaptable(implFun)) {
            throw new AssertionError((Object)("Function origin should be adaptable: " + DumpIrTreeKt.dump$default(implFun, null, 1, null)));
        }
        List<IrValueParameter> implParameters = IrUtilsKt.getNonDispatchParameters(implFun);
        List<IrValueParameter> methodParameters = IrUtilsKt.getNonDispatchParameters(fakeInstanceMethod);
        this.validateMethodParameters(implParameters, methodParameters, implFun, fakeInstanceMethod);
        for (Pair pair : CollectionsKt.zip((Iterable)implParameters, (Iterable)methodParameters)) {
            IrValueParameter implParameter = (IrValueParameter)pair.component1();
            IrValueParameter methodParameter = (IrValueParameter)pair.component2();
            TypeAdaptationConstraint parameterConstraint = constraints.getParameters().get(methodParameter);
            if (!this.requiresImplLambdaBoxing(parameterConstraint)) continue;
            this.makeLambdaParameterNullable(implFun, implParameter);
        }
        if (this.requiresImplLambdaBoxing(constraints.getReturnType()) || IrTypePredicatesKt.isUnit(implFun.getReturnType()) && !IrTypePredicatesKt.isUnit(fakeInstanceMethod.getReturnType())) {
            implFun.setReturnType(IrTypesKt.makeNullable(implFun.getReturnType()));
        }
    }

    private final void makeLambdaParameterNullable(IrFunction function2, IrValueParameter parameter) {
        block0: {
            parameter.setType(IrTypesKt.makeNullable(parameter.getType()));
            IrBody irBody = function2.getBody();
            if (irBody == null) break block0;
            irBody.accept(new IrVisitorVoid(parameter){
                final /* synthetic */ IrValueParameter $parameter;
                {
                    this.$parameter = $parameter;
                }

                public void visitElement(IrElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    element.acceptChildren(this, null);
                }

                public void visitGetValue(IrGetValue expression2) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    if (Intrinsics.areEqual(expression2.getSymbol(), this.$parameter.getSymbol())) {
                        expression2.setType(IrTypesKt.makeNullable(expression2.getType()));
                    }
                    super.visitGetValue(expression2);
                }
            }, null);
        }
    }

    private final void validateMethodParameters(List<? extends IrValueParameter> implParameters, List<? extends IrValueParameter> methodParameters, IrFunction implFun, IrSimpleFunction fakeInstanceMethod) {
        if (implParameters.size() != methodParameters.size()) {
            throw new AssertionError((Object)("Mismatching lambda and instance method parameters:\nimplFun: " + RenderIrElementKt.render$default(implFun, null, 1, null) + "\n  (" + implParameters.size() + " parameters)\ninstance method: " + RenderIrElementKt.render$default(fakeInstanceMethod, null, 1, null) + "\n  (" + methodParameters.size() + " parameters)"));
        }
    }

    private final void adjustLambdaFunction(IrSimpleFunction lambda) {
        Iterable $this$forEach$iv = lambda.getParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrValueParameter parameter = (IrValueParameter)element$iv;
            boolean bl = false;
            if (parameter.getKind() == IrParameterKind.DispatchReceiver) continue;
            parameter.setKind(IrParameterKind.Regular);
        }
    }

    private final void adaptFakeInstanceMethodSignature(IrSimpleFunction fakeInstanceMethod, SignatureAdaptationConstraints constraints) {
        for (Map.Entry<IrValueParameter, TypeAdaptationConstraint> entry : constraints.getParameters().entrySet()) {
            IrValueParameter valueParameter2 = entry.getKey();
            TypeAdaptationConstraint constraint = entry.getValue();
            if (!Intrinsics.areEqual(valueParameter2.getParent(), fakeInstanceMethod)) {
                throw new AssertionError((Object)("Unexpected value parameter: " + RenderIrElementKt.render$default(valueParameter2, null, 1, null) + "; fakeInstanceMethod:\n" + DumpIrTreeKt.dump$default(fakeInstanceMethod, null, 1, null)));
            }
            if (!this.requiresInstanceMethodBoxing(constraint)) continue;
            valueParameter2.setType(IrTypesKt.makeNullable(valueParameter2.getType()));
        }
        if (this.requiresInstanceMethodBoxing(constraints.getReturnType())) {
            fakeInstanceMethod.setReturnType(IrTypesKt.makeNullable(fakeInstanceMethod.getReturnType()));
        }
    }

    private final boolean requiresInstanceMethodBoxing(TypeAdaptationConstraint $this$requiresInstanceMethodBoxing) {
        return $this$requiresInstanceMethodBoxing == TypeAdaptationConstraint.FORCE_BOXING || $this$requiresInstanceMethodBoxing == TypeAdaptationConstraint.BOX_PRIMITIVE;
    }

    private final boolean requiresImplLambdaBoxing(TypeAdaptationConstraint $this$requiresImplLambdaBoxing) {
        return $this$requiresImplLambdaBoxing == TypeAdaptationConstraint.FORCE_BOXING;
    }

    private final SignatureAdaptationConstraints computeSignatureAdaptationConstraints(IrSimpleFunction adapteeFun, IrSimpleFunction expectedFun) {
        TypeAdaptationConstraint returnTypeConstraint = this.computeReturnTypeAdaptationConstraint(adapteeFun, expectedFun);
        if (returnTypeConstraint == TypeAdaptationConstraint.CONFLICT) {
            return null;
        }
        HashMap valueParameterConstraints = new HashMap();
        List<IrValueParameter> adapteeParameters = IrUtilsKt.getNonDispatchParameters(adapteeFun);
        List<IrValueParameter> expectedParameters = IrUtilsKt.getNonDispatchParameters(expectedFun);
        if (adapteeParameters.size() != expectedParameters.size()) {
            throw new AssertionError((Object)("Mismatching value parameters:\nadaptee: " + RenderIrElementKt.render$default(adapteeFun, null, 1, null) + "\n  " + adapteeParameters.size() + " value parameters;\nexpected: " + RenderIrElementKt.render$default(expectedFun, null, 1, null) + "\n  " + expectedParameters.size() + " value parameters."));
        }
        for (Pair pair : CollectionsKt.zip((Iterable)adapteeParameters, (Iterable)expectedParameters)) {
            TypeAdaptationConstraint parameterConstraint;
            IrValueParameter adapteeParameter = (IrValueParameter)pair.component1();
            IrValueParameter expectedParameter = (IrValueParameter)pair.component2();
            if (this.computeParameterTypeAdaptationConstraint(adapteeParameter.getType(), expectedParameter.getType()) == null) continue;
            if (parameterConstraint == TypeAdaptationConstraint.CONFLICT) {
                return null;
            }
            ((Map)valueParameterConstraints).put(adapteeParameter, parameterConstraint);
        }
        return new SignatureAdaptationConstraints(valueParameterConstraints.isEmpty() ? MapsKt.emptyMap() : (Map)valueParameterConstraints, returnTypeConstraint);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final TypeAdaptationConstraint computeParameterTypeAdaptationConstraint(IrType adapteeType, IrType expectedType) {
        TypeAdaptationConstraint typeAdaptationConstraint;
        if (!(adapteeType instanceof IrSimpleType)) {
            throw new AssertionError((Object)("Simple type expected: " + RenderIrElementKt.render$default(adapteeType, null, 1, null)));
        }
        if (!(expectedType instanceof IrSimpleType)) {
            throw new AssertionError((Object)("Simple type expected: " + RenderIrElementKt.render$default(expectedType, null, 1, null)));
        }
        if (IrTypePredicatesKt.isNothing(adapteeType)) return TypeAdaptationConstraint.CONFLICT;
        if (IrTypePredicatesKt.isNullableNothing(adapteeType)) {
            return TypeAdaptationConstraint.CONFLICT;
        }
        if (IrTypePredicatesKt.isPrimitiveType$default(adapteeType, false, 1, null)) {
            TypeAdaptationConstraint typeAdaptationConstraint2;
            if (IrTypePredicatesKt.isPrimitiveType$default(expectedType, false, 1, null)) {
                IrAnnotationContainer irAnnotationContainer = expectedType;
                FqName fqName = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
                Intrinsics.checkNotNullExpressionValue(fqName, "ENHANCED_NULLABILITY_ANNOTATION");
                if (!IrUtilsKt.hasAnnotation(irAnnotationContainer, fqName)) {
                    typeAdaptationConstraint2 = TypeAdaptationConstraint.KEEP_UNBOXED;
                    return typeAdaptationConstraint2;
                }
            }
            typeAdaptationConstraint2 = TypeAdaptationConstraint.BOX_PRIMITIVE;
            return typeAdaptationConstraint2;
        }
        IrClass erasedAdapteeClass = this.getErasedClassForSignatureAdaptation((IrSimpleType)adapteeType);
        if (!IrDeclarationsKt.isSingleFieldValueClass(erasedAdapteeClass)) {
            if (!MfvcNodeKt.needsMfvcFlattening(adapteeType)) return null;
            return TypeAdaptationConstraint.CONFLICT;
        }
        IrSimpleType underlyingAdapteeType = InlineClassesKt.getInlineClassUnderlyingType(erasedAdapteeClass);
        if (!IrTypeUtilsKt.isNullable(underlyingAdapteeType) && !IrTypePredicatesKt.isPrimitiveType$default(underlyingAdapteeType, false, 1, null)) {
            return TypeAdaptationConstraint.CONFLICT;
        }
        IrClass erasedExpectedClass = this.getErasedClassForSignatureAdaptation((IrSimpleType)expectedType);
        if (IrDeclarationsKt.isSingleFieldValueClass(erasedExpectedClass)) {
            typeAdaptationConstraint = TypeAdaptationConstraint.CONFLICT;
            return typeAdaptationConstraint;
        }
        typeAdaptationConstraint = TypeAdaptationConstraint.FORCE_BOXING;
        return typeAdaptationConstraint;
    }

    private final IrClass getErasedClassForSignatureAdaptation(IrSimpleType irType) {
        IrClass irClass;
        IrSymbolOwner classifier = irType.getClassifier().getOwner();
        if (classifier instanceof IrTypeParameter) {
            irClass = IrTypeErasureUtilsKt.getErasedUpperBound((IrTypeParameter)classifier);
        } else if (classifier instanceof IrClass) {
            irClass = (IrClass)classifier;
        } else {
            throw new AssertionError((Object)("Unexpected classifier: " + RenderIrElementKt.render$default(classifier, null, 1, null)));
        }
        return irClass;
    }

    private final TypeAdaptationConstraint computeReturnTypeAdaptationConstraint(IrSimpleFunction adapteeFun, IrSimpleFunction expectedFun) {
        IrType adapteeReturnType = adapteeFun.getReturnType();
        if (IrTypePredicatesKt.isUnit(adapteeReturnType)) {
            return IrTypePredicatesKt.isUnit(expectedFun.getReturnType()) ? TypeAdaptationConstraint.KEEP_UNBOXED : TypeAdaptationConstraint.FORCE_BOXING;
        }
        IrType expectedReturnType = expectedFun.getReturnType();
        return this.computeParameterTypeAdaptationConstraint(adapteeReturnType, expectedReturnType);
    }

    private final SignatureAdaptationConstraints joinSignatureAdaptationConstraints(SignatureAdaptationConstraints sig1, SignatureAdaptationConstraints sig2) {
        Map map;
        TypeAdaptationConstraint newReturnTypeConstraint = this.composeTypeAdaptationConstraints(sig1.getReturnType(), sig2.getReturnType());
        if (newReturnTypeConstraint == TypeAdaptationConstraint.CONFLICT) {
            return null;
        }
        if (sig1.getParameters().isEmpty()) {
            map = sig2.getParameters();
        } else if (sig2.getParameters().isEmpty()) {
            map = sig1.getParameters();
        } else {
            HashMap<IrValueParameter, TypeAdaptationConstraint> joined = new HashMap<IrValueParameter, TypeAdaptationConstraint>();
            joined.putAll(sig1.getParameters());
            for (Map.Entry<IrValueParameter, TypeAdaptationConstraint> entry : sig2.getParameters().entrySet()) {
                TypeAdaptationConstraint tx;
                IrValueParameter vp2 = entry.getKey();
                TypeAdaptationConstraint t2 = entry.getValue();
                if (this.composeTypeAdaptationConstraints((TypeAdaptationConstraint)((Object)joined.get(vp2)), t2) == null) continue;
                if (tx == TypeAdaptationConstraint.CONFLICT) {
                    return null;
                }
                ((Map)joined).put(vp2, tx);
            }
            map = joined;
        }
        Map newValueParameterConstraints = map;
        return new SignatureAdaptationConstraints(newValueParameterConstraints, newReturnTypeConstraint);
    }

    private final TypeAdaptationConstraint composeTypeAdaptationConstraints(TypeAdaptationConstraint t1, TypeAdaptationConstraint t2) {
        return t1 == null ? t2 : (t2 == null ? t1 : (t1 == t2 ? t1 : TypeAdaptationConstraint.CONFLICT));
    }

    private final boolean isInlineFunction(IrDeclarationParent $this$isInlineFunction) {
        return $this$isInlineFunction instanceof IrSimpleFunction && ((IrSimpleFunction)$this$isInlineFunction).isInline() && !Intrinsics.areEqual(((IrSimpleFunction)$this$isInlineFunction).getOrigin(), IrDeclarationOrigin.Companion.getLOCAL_FUNCTION_FOR_LAMBDA());
    }

    private final boolean isCrossinlineLambda(IrDeclarationParent $this$isCrossinlineLambda) {
        return $this$isCrossinlineLambda instanceof IrSimpleFunction && this.crossinlineLambdas.contains($this$isCrossinlineLambda);
    }

    private static final IrSimpleFunction requiresDelegationToDefaultImpls$lambda$5(IrProperty it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getGetter();
    }

    private static final IrSimpleFunction requiresDelegationToDefaultImpls$lambda$6(IrProperty it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getSetter();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArgumentsBuilder$SignatureAdaptationConstraints;", "", "parameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArgumentsBuilder$TypeAdaptationConstraint;", "returnType", "<init>", "(Ljava/util/Map;Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArgumentsBuilder$TypeAdaptationConstraint;)V", "getParameters", "()Ljava/util/Map;", "getReturnType", "()Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArgumentsBuilder$TypeAdaptationConstraint;", "hasConflicts", "", "backend.jvm.lower"})
    private static final class SignatureAdaptationConstraints {
        @NotNull
        private final Map<IrValueParameter, TypeAdaptationConstraint> parameters;
        @Nullable
        private final TypeAdaptationConstraint returnType;

        public SignatureAdaptationConstraints(@NotNull Map<IrValueParameter, ? extends TypeAdaptationConstraint> parameters, @Nullable TypeAdaptationConstraint returnType) {
            Intrinsics.checkNotNullParameter(parameters, "parameters");
            this.parameters = parameters;
            this.returnType = returnType;
        }

        @NotNull
        public final Map<IrValueParameter, TypeAdaptationConstraint> getParameters() {
            return this.parameters;
        }

        @Nullable
        public final TypeAdaptationConstraint getReturnType() {
            return this.returnType;
        }

        public final boolean hasConflicts() {
            return this.returnType == TypeAdaptationConstraint.CONFLICT || this.parameters.values().contains((Object)TypeAdaptationConstraint.CONFLICT);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArgumentsBuilder$TypeAdaptationConstraint;", "", "<init>", "(Ljava/lang/String;I)V", "FORCE_BOXING", "BOX_PRIMITIVE", "KEEP_UNBOXED", "CONFLICT", "backend.jvm.lower"})
    private static final class TypeAdaptationConstraint
    extends Enum<TypeAdaptationConstraint> {
        public static final /* enum */ TypeAdaptationConstraint FORCE_BOXING = new TypeAdaptationConstraint();
        public static final /* enum */ TypeAdaptationConstraint BOX_PRIMITIVE = new TypeAdaptationConstraint();
        public static final /* enum */ TypeAdaptationConstraint KEEP_UNBOXED = new TypeAdaptationConstraint();
        public static final /* enum */ TypeAdaptationConstraint CONFLICT = new TypeAdaptationConstraint();
        private static final /* synthetic */ TypeAdaptationConstraint[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TypeAdaptationConstraint[] values() {
            return (TypeAdaptationConstraint[])$VALUES.clone();
        }

        public static TypeAdaptationConstraint valueOf(String value2) {
            return Enum.valueOf(TypeAdaptationConstraint.class, value2);
        }

        @NotNull
        public static EnumEntries<TypeAdaptationConstraint> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeAdaptationConstraintArray = new TypeAdaptationConstraint[]{TypeAdaptationConstraint.FORCE_BOXING, TypeAdaptationConstraint.BOX_PRIMITIVE, TypeAdaptationConstraint.KEEP_UNBOXED, TypeAdaptationConstraint.CONFLICT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TypeAdaptationConstraint.values().length];
            try {
                nArray[TypeAdaptationConstraint.FORCE_BOXING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeAdaptationConstraint.KEEP_UNBOXED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeAdaptationConstraint.BOX_PRIMITIVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeAdaptationConstraint.CONFLICT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

