/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.verifier;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.ArtifactVerificationOperation;
import org.gradle.api.internal.artifacts.verification.model.ArtifactVerificationMetadata;
import org.gradle.api.internal.artifacts.verification.model.Checksum;
import org.gradle.api.internal.artifacts.verification.model.ChecksumKind;
import org.gradle.api.internal.artifacts.verification.model.ComponentVerificationMetadata;
import org.gradle.api.internal.artifacts.verification.model.IgnoredKey;
import org.gradle.api.internal.artifacts.verification.signatures.SignatureVerificationResultBuilder;
import org.gradle.api.internal.artifacts.verification.signatures.SignatureVerificationService;
import org.gradle.api.internal.artifacts.verification.verifier.ArtifactVerificationResultBuilder;
import org.gradle.api.internal.artifacts.verification.verifier.ChecksumVerificationFailure;
import org.gradle.api.internal.artifacts.verification.verifier.DeletedArtifact;
import org.gradle.api.internal.artifacts.verification.verifier.DependencyVerificationConfiguration;
import org.gradle.api.internal.artifacts.verification.verifier.MissingChecksums;
import org.gradle.api.internal.artifacts.verification.verifier.MissingSignature;
import org.gradle.api.internal.artifacts.verification.verifier.OnlyIgnoredKeys;
import org.gradle.api.internal.artifacts.verification.verifier.SignatureVerificationFailure;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.hash.HashCode;
import org.gradle.security.internal.Fingerprint;
import org.gradle.security.internal.PublicKeyService;

public class DependencyVerifier {
    private final Map<String, ComponentVerificationMetadata> verificationMetadata;
    private final DependencyVerificationConfiguration config;
    private final List<String> topLevelComments;

    DependencyVerifier(Map<ModuleComponentIdentifier, ComponentVerificationMetadata> verificationMetadata, DependencyVerificationConfiguration config, List<String> topLevelComments) {
        this.verificationMetadata = (Map)verificationMetadata.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> this.toStringKey((ModuleComponentIdentifier)entry.getKey()), Map.Entry::getValue));
        this.config = config;
        this.topLevelComments = topLevelComments;
    }

    public void verify(ChecksumService checksumService, SignatureVerificationService signatureVerificationService, ArtifactVerificationOperation.ArtifactKind kind, ModuleComponentArtifactIdentifier foundArtifact, File artifactFile, File signatureFile, ArtifactVerificationResultBuilder builder) {
        if (this.shouldSkipVerification(kind)) {
            return;
        }
        this.performVerification(foundArtifact, checksumService, signatureVerificationService, artifactFile, signatureFile, failure -> {
            if (this.isTrustedArtifact(foundArtifact)) {
                return;
            }
            builder.failWith(failure);
        });
    }

    private boolean shouldSkipVerification(ArtifactVerificationOperation.ArtifactKind kind) {
        return kind == ArtifactVerificationOperation.ArtifactKind.METADATA && !this.config.isVerifyMetadata();
    }

    private boolean isTrustedArtifact(ModuleComponentArtifactIdentifier id) {
        return this.config.getTrustedArtifacts().stream().anyMatch(artifact -> artifact.matches(id));
    }

    private void performVerification(ModuleComponentArtifactIdentifier foundArtifact, ChecksumService checksumService, SignatureVerificationService signatureVerificationService, File file, File signature, ArtifactVerificationResultBuilder builder) {
        if (!file.exists()) {
            builder.failWith(new DeletedArtifact(file));
            return;
        }
        this.doVerifyArtifact(foundArtifact, checksumService, signatureVerificationService, file, signature, builder);
    }

    private void doVerifyArtifact(ModuleComponentArtifactIdentifier foundArtifact, ChecksumService checksumService, SignatureVerificationService signatureVerificationService, File file, File signature, ArtifactVerificationResultBuilder builder) {
        PublicKeyService publicKeyService = signatureVerificationService.getPublicKeyService();
        ComponentVerificationMetadata componentVerification = this.verificationMetadata.get(this.toStringKey(foundArtifact.getComponentIdentifier()));
        if (componentVerification != null) {
            String foundArtifactFileName = foundArtifact.getFileName();
            List<ArtifactVerificationMetadata> verifications = componentVerification.getArtifactVerifications();
            for (ArtifactVerificationMetadata verification : verifications) {
                String verifiedArtifact = verification.getArtifactName();
                if (!verifiedArtifact.equals(foundArtifactFileName)) continue;
                if (signature == null) {
                    if (this.config.isVerifySignatures()) {
                        builder.failWith(new MissingSignature(file));
                    }
                    if (verification.getChecksums().isEmpty()) {
                        builder.failWith(new MissingChecksums(file));
                        return;
                    }
                } else {
                    DefaultSignatureVerificationResultBuilder result = new DefaultSignatureVerificationResultBuilder(file, signature);
                    this.verifySignature(signatureVerificationService, file, signature, this.allTrustedKeys(foundArtifact, verification.getTrustedPgpKeys()), this.allIgnoredKeys(verification.getIgnoredPgpKeys()), result);
                    if (result.hasOnlyIgnoredKeys()) {
                        builder.failWith(new OnlyIgnoredKeys(file));
                        if (verification.getChecksums().isEmpty()) {
                            builder.failWith(new MissingChecksums(file));
                            return;
                        }
                        this.verifyChecksums(checksumService, file, verification, builder);
                        return;
                    }
                    if (result.hasError()) {
                        builder.failWith(result.asError(publicKeyService));
                        return;
                    }
                }
                this.verifyChecksums(checksumService, file, verification, builder);
                return;
            }
        }
        if (signature != null) {
            DefaultSignatureVerificationResultBuilder result = new DefaultSignatureVerificationResultBuilder(file, signature);
            this.verifySignature(signatureVerificationService, file, signature, this.allTrustedKeys(foundArtifact, Collections.emptySet()), this.allIgnoredKeys(Collections.emptySet()), result);
            if (result.hasError()) {
                builder.failWith(result.asError(publicKeyService));
                return;
            }
            if (!result.hasOnlyIgnoredKeys()) {
                return;
            }
        }
        builder.failWith(new MissingChecksums(file));
    }

    private String toStringKey(ModuleComponentIdentifier moduleComponentIdentifier) {
        return moduleComponentIdentifier.getGroup() + ":" + moduleComponentIdentifier.getModule() + ":" + moduleComponentIdentifier.getVersion();
    }

    private Set<String> allTrustedKeys(ModuleComponentArtifactIdentifier id, Set<String> artifactSpecificKeys) {
        if (this.config.getTrustedKeys().isEmpty()) {
            return artifactSpecificKeys;
        }
        HashSet allKeys = Sets.newHashSet(artifactSpecificKeys);
        this.config.getTrustedKeys().stream().filter(trustedKey -> trustedKey.matches(id)).forEach(trustedKey -> allKeys.add(trustedKey.getKeyId()));
        return allKeys;
    }

    private Set<String> allIgnoredKeys(Set<IgnoredKey> artifactSpecificKeys) {
        if (this.config.getIgnoredKeys().isEmpty()) {
            return artifactSpecificKeys.stream().map(IgnoredKey::getKeyId).collect(Collectors.toSet());
        }
        if (artifactSpecificKeys.isEmpty()) {
            return this.config.getIgnoredKeys().stream().map(IgnoredKey::getKeyId).collect(Collectors.toSet());
        }
        HashSet allKeys = Sets.newHashSet();
        artifactSpecificKeys.stream().map(IgnoredKey::getKeyId).forEach(allKeys::add);
        this.config.getIgnoredKeys().stream().map(IgnoredKey::getKeyId).forEach(allKeys::add);
        return allKeys;
    }

    private void verifySignature(SignatureVerificationService signatureVerificationService, File file, File signature, Set<String> trustedKeys, Set<String> ignoredKeys, SignatureVerificationResultBuilder result) {
        signatureVerificationService.verify(file, signature, trustedKeys, ignoredKeys, result);
    }

    private void verifyChecksums(ChecksumService checksumService, File file, ArtifactVerificationMetadata verification, ArtifactVerificationResultBuilder builder) {
        List<Checksum> checksums = verification.getChecksums();
        for (Checksum checksum : checksums) {
            DependencyVerifier.verifyChecksum(checksum.getKind(), file, checksum.getValue(), checksum.getAlternatives(), checksumService, builder);
        }
    }

    private static void verifyChecksum(ChecksumKind algorithm, File file, String expected, Set<String> alternatives, ChecksumService cache, ArtifactVerificationResultBuilder builder) {
        String actualChecksum = DependencyVerifier.checksumOf(algorithm, file, cache);
        if (expected.equals(actualChecksum)) {
            return;
        }
        if (alternatives != null) {
            for (String alternative : alternatives) {
                if (!actualChecksum.equals(alternative)) continue;
                return;
            }
        }
        builder.failWith(new ChecksumVerificationFailure(file, algorithm, expected, actualChecksum));
    }

    private static String checksumOf(ChecksumKind algorithm, File file, ChecksumService cache) {
        HashCode hashValue = null;
        switch (algorithm) {
            case md5: {
                hashValue = cache.md5(file);
                break;
            }
            case sha1: {
                hashValue = cache.sha1(file);
                break;
            }
            case sha256: {
                hashValue = cache.sha256(file);
                break;
            }
            case sha512: {
                hashValue = cache.sha512(file);
            }
        }
        return hashValue.toString();
    }

    public Collection<ComponentVerificationMetadata> getVerificationMetadata() {
        return this.verificationMetadata.values();
    }

    public DependencyVerificationConfiguration getConfiguration() {
        return this.config;
    }

    public List<String> getTopLevelComments() {
        return this.topLevelComments;
    }

    public List<String> getSuggestedWriteFlags() {
        LinkedHashSet writeFlags = Sets.newLinkedHashSet();
        if (this.config.isVerifySignatures()) {
            writeFlags.add("pgp");
        }
        this.getVerificationMetadata().forEach(md -> md.getArtifactVerifications().forEach(av -> av.getChecksums().forEach(checksum -> writeFlags.add(checksum.getKind().name()))));
        if (Collections.singleton("pgp").equals(writeFlags)) {
            writeFlags.add("sha512");
        }
        return ImmutableList.copyOf((Collection)writeFlags);
    }

    private static SignatureVerificationFailure.SignatureError error(@Nullable PGPPublicKey key, SignatureVerificationFailure.FailureKind kind) {
        return new SignatureVerificationFailure.SignatureError(key, kind);
    }

    private static class DefaultSignatureVerificationResultBuilder
    implements SignatureVerificationResultBuilder {
        private final File file;
        private final File signatureFile;
        private List<String> missingKeys = null;
        private List<PGPPublicKey> trustedKeys = null;
        private List<PGPPublicKey> validNotTrusted = null;
        private List<PGPPublicKey> failedKeys = null;
        private List<String> ignoredKeys = null;

        private DefaultSignatureVerificationResultBuilder(File file, File signatureFile) {
            this.file = file;
            this.signatureFile = signatureFile;
        }

        @Override
        public void missingKey(String keyId) {
            if (this.missingKeys == null) {
                this.missingKeys = Lists.newArrayList();
            }
            this.missingKeys.add(keyId);
        }

        @Override
        public void verified(PGPPublicKey key, boolean trusted) {
            if (trusted) {
                if (this.trustedKeys == null) {
                    this.trustedKeys = Lists.newArrayList();
                }
                this.trustedKeys.add(key);
            } else {
                if (this.validNotTrusted == null) {
                    this.validNotTrusted = Lists.newArrayList();
                }
                this.validNotTrusted.add(key);
            }
        }

        @Override
        public void failed(PGPPublicKey pgpPublicKey) {
            if (this.failedKeys == null) {
                this.failedKeys = Lists.newArrayList();
            }
            this.failedKeys.add(pgpPublicKey);
        }

        @Override
        public void ignored(String keyId) {
            if (this.ignoredKeys == null) {
                this.ignoredKeys = Lists.newArrayList();
            }
            this.ignoredKeys.add(keyId);
        }

        boolean hasOnlyIgnoredKeys() {
            return this.ignoredKeys != null && this.trustedKeys == null && this.validNotTrusted == null && this.missingKeys == null && this.failedKeys == null;
        }

        public SignatureVerificationFailure asError(PublicKeyService publicKeyService) {
            HashMap errors = Maps.newHashMap();
            if (this.missingKeys != null) {
                for (String missingKey : this.missingKeys) {
                    errors.put(missingKey, DependencyVerifier.error(null, SignatureVerificationFailure.FailureKind.MISSING_KEY));
                }
            }
            if (this.failedKeys != null) {
                for (PGPPublicKey failedKey : this.failedKeys) {
                    errors.put(Fingerprint.of((PGPPublicKey)failedKey).toString(), DependencyVerifier.error(failedKey, SignatureVerificationFailure.FailureKind.FAILED));
                }
            }
            if (this.validNotTrusted != null) {
                for (PGPPublicKey trustedKey : this.validNotTrusted) {
                    errors.put(Fingerprint.of((PGPPublicKey)trustedKey).toString(), DependencyVerifier.error(trustedKey, SignatureVerificationFailure.FailureKind.PASSED_NOT_TRUSTED));
                }
            }
            if (this.ignoredKeys != null) {
                for (String ignoredKey : this.ignoredKeys) {
                    errors.put(ignoredKey, DependencyVerifier.error(null, SignatureVerificationFailure.FailureKind.IGNORED_KEY));
                }
            }
            return new SignatureVerificationFailure(this.file, this.signatureFile, (Map<String, SignatureVerificationFailure.SignatureError>)ImmutableMap.copyOf((Map)errors), publicKeyService);
        }

        public boolean hasError() {
            return this.failedKeys != null || this.validNotTrusted != null || this.missingKeys != null;
        }
    }
}

