/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jvm.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.ConfigurationVariantDetails;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.internal.artifacts.ConfigurationVariantInternal;
import org.gradle.api.internal.artifacts.JavaEcosystemSupport;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.internal.tasks.compile.HasCompileOptions;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.AbstractConfigurationBuilder;
import org.gradle.api.plugins.jvm.internal.DefaultJvmEcosystemAttributesDetails;
import org.gradle.api.plugins.jvm.internal.DefaultJvmLanguageGeneratedSourceDirectoryBuilder;
import org.gradle.api.plugins.jvm.internal.DefaultJvmLanguageSourceDirectoryBuilder;
import org.gradle.api.plugins.jvm.internal.DefaultJvmVariantBuilder;
import org.gradle.api.plugins.jvm.internal.JvmEcosystemAttributesDetails;
import org.gradle.api.plugins.jvm.internal.JvmLanguageGeneratedSourceDirectoryBuilder;
import org.gradle.api.plugins.jvm.internal.JvmLanguageSourceDirectoryBuilder;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.plugins.jvm.internal.JvmVariantBuilder;
import org.gradle.api.plugins.jvm.internal.OutgoingElementsBuilder;
import org.gradle.api.plugins.jvm.internal.ResolvableConfigurationBuilder;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;
import org.gradle.internal.instantiation.InstanceGenerator;

public class DefaultJvmPluginServices
implements JvmPluginServices {
    private final ConfigurationContainer configurations;
    private final ObjectFactory objectFactory;
    private final TaskContainer tasks;
    private final SoftwareComponentContainer components;
    private final InstanceGenerator instanceGenerator;
    private final Map<ConfigurationInternal, Set<TaskProvider<?>>> configurationToCompileTasks;
    private SourceSetContainer sourceSets;
    private ProjectInternal project;

    @Inject
    public DefaultJvmPluginServices(ConfigurationContainer configurations, ObjectFactory objectFactory, TaskContainer tasks, SoftwareComponentContainer components, InstanceGenerator instanceGenerator) {
        this.configurations = configurations;
        this.objectFactory = objectFactory;
        this.tasks = tasks;
        this.components = components;
        this.instanceGenerator = instanceGenerator;
        this.configurationToCompileTasks = new HashMap(5);
    }

    @Override
    public void inject(ProjectInternal project, SourceSetContainer sourceSets) {
        this.project = project;
        this.sourceSets = sourceSets;
    }

    @Override
    public void configureClassesDirectoryVariant(String configurationName, SourceSet sourceSet) {
        this.configurations.all(config -> {
            if (configurationName.equals(config.getName())) {
                this.registerClassesDirVariant(sourceSet, (Configuration)config);
            }
        });
    }

    @Override
    public <T> void configureAsCompileClasspath(HasConfigurableAttributes<T> configuration) {
        this.configureAttributes(configuration, (Action<? super JvmEcosystemAttributesDetails>)((Action)details -> details.library().apiUsage().withExternalDependencies().preferStandardJVM()));
    }

    @Override
    public <T> void configureAsRuntimeClasspath(HasConfigurableAttributes<T> configuration) {
        this.configureAttributes(configuration, (Action<? super JvmEcosystemAttributesDetails>)((Action)details -> details.library().runtimeUsage().asJar().withExternalDependencies().preferStandardJVM()));
    }

    @Override
    public <T> void configureAttributes(HasConfigurableAttributes<T> configurable, Action<? super JvmEcosystemAttributesDetails> configuration) {
        AttributeContainerInternal attributes = (AttributeContainerInternal)configurable.getAttributes();
        DefaultJvmEcosystemAttributesDetails details = (DefaultJvmEcosystemAttributesDetails)this.instanceGenerator.newInstance(DefaultJvmEcosystemAttributesDetails.class, new Object[]{this.objectFactory, attributes});
        configuration.execute((Object)details);
    }

    @Override
    public <COMPILE extends AbstractCompile> void useDefaultTargetPlatformInference(Configuration configuration, TaskProvider<COMPILE> compileTask) {
        ConfigurationInternal configurationInternal = (ConfigurationInternal)configuration;
        Set compileTasks = this.configurationToCompileTasks.computeIfAbsent(configurationInternal, key -> {
            HashSet taskProviders = new HashSet();
            configurationInternal.beforeLocking(this.configureDefaultTargetPlatform(configuration.isCanBeConsumed(), taskProviders));
            return taskProviders;
        });
        compileTasks.add(compileTask);
    }

    @Override
    public void replaceArtifacts(Configuration outgoingConfiguration, Object ... providers) {
        this.clearArtifacts(outgoingConfiguration);
        ConfigurationPublications outgoing = outgoingConfiguration.getOutgoing();
        for (Object provider : providers) {
            outgoing.artifact(provider);
        }
    }

    @Override
    public void registerJvmLanguageSourceDirectory(SourceSet sourceSet, String name, Action<? super JvmLanguageSourceDirectoryBuilder> configuration) {
        DefaultJvmLanguageSourceDirectoryBuilder builder = (DefaultJvmLanguageSourceDirectoryBuilder)this.instanceGenerator.newInstance(DefaultJvmLanguageSourceDirectoryBuilder.class, new Object[]{name, this.project, sourceSet});
        configuration.execute((Object)builder);
        builder.build();
    }

    @Override
    public void registerJvmLanguageGeneratedSourceDirectory(SourceSet sourceSet, Action<? super JvmLanguageGeneratedSourceDirectoryBuilder> configuration) {
        DefaultJvmLanguageGeneratedSourceDirectoryBuilder builder = (DefaultJvmLanguageGeneratedSourceDirectoryBuilder)this.instanceGenerator.newInstance(DefaultJvmLanguageGeneratedSourceDirectoryBuilder.class, new Object[]{this.project, sourceSet});
        configuration.execute((Object)builder);
        builder.build();
    }

    @Override
    public Provider<Configuration> registerDependencyBucket(String name, String description) {
        return this.project.getConfigurations().register(name, cnf -> {
            cnf.setCanBeResolved(false);
            cnf.setCanBeConsumed(false);
            cnf.setDescription(description);
        });
    }

    private void clearArtifacts(Configuration outgoingConfiguration) {
        outgoingConfiguration.getOutgoing().getArtifacts().clear();
        for (Configuration configuration : outgoingConfiguration.getExtendsFrom()) {
            this.clearArtifacts(configuration);
        }
    }

    private void registerClassesDirVariant(final SourceSet sourceSet, Configuration configuration) {
        ConfigurationPublications publications = configuration.getOutgoing();
        ConfigurationVariantInternal variant = (ConfigurationVariantInternal)publications.getVariants().maybeCreate("classes");
        variant.setDescription("Directories containing compiled class files for " + sourceSet.getName() + ".");
        variant.getAttributes().attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)this.objectFactory.named(LibraryElements.class, "classes")));
        variant.artifactsProvider((Factory)new Factory<List<PublishArtifact>>(){

            @Nullable
            public List<PublishArtifact> create() {
                Set classesDirs = sourceSet.getOutput().getClassesDirs().getFiles();
                DefaultSourceSetOutput output = (DefaultSourceSetOutput)Cast.uncheckedCast((Object)sourceSet.getOutput());
                TaskDependency classesContributors = output.getClassesContributors();
                ImmutableList.Builder artifacts = ImmutableList.builderWithExpectedSize((int)classesDirs.size());
                for (final File classesDir : classesDirs) {
                    artifacts.add((Object)new JvmPluginsHelper.IntermediateJavaArtifact("java-classes-directory", classesContributors){

                        public File getFile() {
                            return classesDir;
                        }
                    });
                }
                return artifacts.build();
            }
        });
    }

    private <COMPILE extends AbstractCompile> Action<ConfigurationInternal> configureDefaultTargetPlatform(boolean alwaysEnabled, Set<TaskProvider<COMPILE>> compileTasks) {
        return conf -> {
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)this.project.getExtensions().findByType(JavaPluginExtension.class);
            if (alwaysEnabled || javaPluginExtension == null || !javaPluginExtension.getAutoTargetJvmDisabled()) {
                int majorVersion = 0;
                for (TaskProvider compileTaskProvider : compileTasks) {
                    AbstractCompile compileTask = (AbstractCompile)compileTaskProvider.get();
                    if (((HasCompileOptions)compileTask).getOptions().getRelease().isPresent()) {
                        majorVersion = Math.max(majorVersion, (Integer)((HasCompileOptions)compileTask).getOptions().getRelease().get());
                        continue;
                    }
                    int releaseFlag = DefaultJvmPluginServices.getReleaseOption(((HasCompileOptions)compileTask).getOptions().getCompilerArgs());
                    if (releaseFlag != 0) {
                        majorVersion = Math.max(majorVersion, releaseFlag);
                        continue;
                    }
                    majorVersion = Math.max(majorVersion, Integer.parseInt(JavaVersion.toVersion((Object)compileTask.getTargetCompatibility()).getMajorVersion()));
                }
                if (majorVersion != 0) {
                    JavaEcosystemSupport.configureDefaultTargetPlatform((HasAttributes)conf, (int)majorVersion);
                }
            }
        };
    }

    @Override
    public Configuration createOutgoingElements(String name, Action<? super OutgoingElementsBuilder> configuration) {
        DefaultElementsConfigurationBuilder builder = (DefaultElementsConfigurationBuilder)this.instanceGenerator.newInstance(DefaultElementsConfigurationBuilder.class, new Object[]{name, this, this.configurations, this.components, this.tasks});
        configuration.execute((Object)builder);
        return builder.build();
    }

    @Override
    public Configuration createResolvableConfiguration(String name, Action<? super ResolvableConfigurationBuilder> action) {
        DefaultResolvableConfigurationBuilder builder = (DefaultResolvableConfigurationBuilder)this.instanceGenerator.newInstance(DefaultResolvableConfigurationBuilder.class, new Object[]{name, this, this.configurations});
        action.execute((Object)builder);
        return builder.build();
    }

    @Override
    public void createJvmVariant(String name, Action<? super JvmVariantBuilder> configuration) {
        DefaultJvmVariantBuilder builder = (DefaultJvmVariantBuilder)this.instanceGenerator.newInstance(DefaultJvmVariantBuilder.class, new Object[]{name, new ProjectDerivedCapability((Project)this.project, name), this, this.sourceSets, this.configurations, this.tasks, this.components, this.project});
        configuration.execute((Object)builder);
        builder.build();
    }

    private static int getReleaseOption(List<String> compilerArgs) {
        int flagIndex = compilerArgs.indexOf("--release");
        if (flagIndex != -1 && flagIndex + 1 < compilerArgs.size()) {
            return Integer.parseInt(String.valueOf(compilerArgs.get(flagIndex + 1)));
        }
        return 0;
    }

    public static class DefaultResolvableConfigurationBuilder
    extends AbstractConfigurationBuilder<DefaultResolvableConfigurationBuilder>
    implements ResolvableConfigurationBuilder {
        private Boolean libraryApi;
        private Boolean libraryRuntime;
        private Map<String, String> buckets;

        @Inject
        public DefaultResolvableConfigurationBuilder(String name, JvmPluginServices jvmEcosystemUtilities, ConfigurationContainer configurations) {
            super(name, jvmEcosystemUtilities, configurations);
        }

        @Override
        public ResolvableConfigurationBuilder usingDependencyBucket(String name) {
            return this.usingDependencyBucket(name, null);
        }

        @Override
        public ResolvableConfigurationBuilder usingDependencyBucket(String name, String description) {
            if (this.buckets == null) {
                this.buckets = Maps.newLinkedHashMap();
            }
            this.buckets.put(name, description);
            return this;
        }

        @Override
        Configuration build() {
            if (this.buckets != null) {
                for (Map.Entry<String, String> entry : this.buckets.entrySet()) {
                    String bucketName = entry.getKey();
                    String description = entry.getValue();
                    Configuration bucket = (Configuration)this.configurations.maybeCreate(bucketName);
                    if (description != null) {
                        bucket.setDescription(description);
                    } else if (this.description != null) {
                        bucket.setDescription("Dependencies for " + this.description);
                    }
                    bucket.setVisible(false);
                    bucket.setCanBeConsumed(false);
                    bucket.setCanBeResolved(false);
                    this.extendsFrom(new Configuration[]{bucket});
                }
            }
            Configuration resolvable = (Configuration)this.configurations.maybeCreate(this.name);
            if (this.description != null) {
                resolvable.setDescription(this.description);
            }
            resolvable.setVisible(false);
            resolvable.setCanBeConsumed(false);
            resolvable.setCanBeResolved(true);
            Configuration[] extendsFrom = this.buildExtendsFrom();
            if (extendsFrom != null) {
                resolvable.extendsFrom(extendsFrom);
            }
            this.jvmEcosystemUtilities.configureAttributes(resolvable, (Action<? super JvmEcosystemAttributesDetails>)((Action)details -> {
                if (this.libraryApi != null && this.libraryApi.booleanValue()) {
                    details.library().asJar().withExternalDependencies().apiUsage();
                } else if (this.libraryRuntime != null && this.libraryRuntime.booleanValue()) {
                    details.library().asJar().withExternalDependencies().runtimeUsage();
                }
                if (this.libraryRuntime == null && this.libraryApi == null && this.attributesRefiner == null) {
                    throw new IllegalStateException("You didn't tell what kind of component to look for. You need to configure at least one attribute");
                }
                if (this.attributesRefiner != null) {
                    this.attributesRefiner.execute(details);
                }
            }));
            return resolvable;
        }

        @Override
        public ResolvableConfigurationBuilder requiresJavaLibrariesRuntime() {
            this.libraryApi = null;
            this.libraryRuntime = true;
            return this;
        }

        @Override
        public ResolvableConfigurationBuilder requiresJavaLibrariesAPI() {
            this.libraryRuntime = null;
            this.libraryApi = true;
            return this;
        }

        @Override
        public ResolvableConfigurationBuilder requiresAttributes(Action<? super JvmEcosystemAttributesDetails> refiner) {
            return (ResolvableConfigurationBuilder)this.attributes(refiner);
        }
    }

    public static class DefaultElementsConfigurationBuilder
    extends AbstractConfigurationBuilder<DefaultElementsConfigurationBuilder>
    implements OutgoingElementsBuilder {
        final SoftwareComponentContainer components;
        private final TaskContainer tasks;
        boolean api;
        SourceSet sourceSet;
        List<Object> artifactProducers;
        List<Capability> capabilities;
        boolean classDirectory;
        private boolean published;

        @Inject
        public DefaultElementsConfigurationBuilder(String name, JvmPluginServices jvmEcosystemUtilities, ConfigurationContainer configurations, SoftwareComponentContainer components, TaskContainer tasks) {
            super(name, jvmEcosystemUtilities, configurations);
            this.components = components;
            this.tasks = tasks;
        }

        @Override
        Configuration build() {
            AdhocComponentWithVariants component;
            Configuration cnf = (Configuration)this.configurations.maybeCreate(this.name);
            if (this.description != null) {
                cnf.setDescription(this.description);
            }
            cnf.setVisible(false);
            cnf.setCanBeConsumed(true);
            cnf.setCanBeResolved(false);
            Configuration[] extendsFrom = this.buildExtendsFrom();
            if (extendsFrom != null) {
                cnf.extendsFrom(extendsFrom);
            }
            this.jvmEcosystemUtilities.configureAttributes(cnf, (Action<? super JvmEcosystemAttributesDetails>)((Action)details -> {
                details.library().withExternalDependencies();
                if (this.api) {
                    details.apiUsage();
                } else {
                    details.runtimeUsage();
                }
                if (this.attributesRefiner != null) {
                    this.attributesRefiner.execute(details);
                }
                if ("library".equals(((Category)cnf.getAttributes().getAttribute(Category.CATEGORY_ATTRIBUTE)).getName()) && !cnf.getAttributes().contains(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE)) {
                    details.asJar();
                }
            }));
            if (this.sourceSet != null) {
                this.jvmEcosystemUtilities.useDefaultTargetPlatformInference(cnf, this.tasks.named(this.sourceSet.getCompileJavaTaskName(), JavaCompile.class));
            }
            ConfigurationPublications outgoing = cnf.getOutgoing();
            if (this.artifactProducers != null) {
                for (Object provider : this.artifactProducers) {
                    outgoing.artifact(provider);
                }
            }
            if (this.capabilities != null) {
                for (Capability capability : this.capabilities) {
                    outgoing.capability((Object)capability);
                }
            }
            if (this.classDirectory) {
                if (!this.api) {
                    throw new IllegalStateException("Cannot add a class directory variant for a runtime outgoing variant");
                }
                if (this.sourceSet == null) {
                    throw new IllegalStateException("Cannot add a class directory variant without specifying the source set");
                }
                this.jvmEcosystemUtilities.configureClassesDirectoryVariant(this.name, this.sourceSet);
            }
            if (this.published && (component = this.findJavaComponent()) != null) {
                component.addVariantsFromConfiguration(cnf, ConfigurationVariantDetails::mapToOptional);
            }
            return cnf;
        }

        @Override
        public OutgoingElementsBuilder providesApi() {
            this.api = true;
            return this;
        }

        @Override
        public OutgoingElementsBuilder providesRuntime() {
            this.api = false;
            return this;
        }

        @Override
        public OutgoingElementsBuilder fromSourceSet(SourceSet sourceSet) {
            this.sourceSet = sourceSet;
            return this;
        }

        @Override
        public OutgoingElementsBuilder artifact(Object producer) {
            if (this.artifactProducers == null) {
                this.artifactProducers = Lists.newArrayList();
            }
            this.artifactProducers.add(producer);
            return this;
        }

        @Override
        public OutgoingElementsBuilder providesAttributes(Action<? super JvmEcosystemAttributesDetails> refiner) {
            return (OutgoingElementsBuilder)this.attributes(refiner);
        }

        @Override
        public OutgoingElementsBuilder withCapabilities(List<Capability> capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        @Override
        public OutgoingElementsBuilder capability(String group, String name, String version) {
            ImmutableCapability capability;
            if (this.capabilities == null) {
                this.capabilities = Lists.newArrayList();
            }
            if ((capability = new ImmutableCapability(group, name, version)).getVersion() == null) {
                throw new InvalidUserDataException("Capabilities declared on outgoing variants must have a version");
            }
            this.capabilities.add((Capability)capability);
            return this;
        }

        @Override
        public OutgoingElementsBuilder withClassDirectoryVariant() {
            this.classDirectory = true;
            return this;
        }

        @Override
        public OutgoingElementsBuilder published() {
            this.published = true;
            return this;
        }

        @Nullable
        public AdhocComponentWithVariants findJavaComponent() {
            SoftwareComponent component = (SoftwareComponent)this.components.findByName("java");
            if (component instanceof AdhocComponentWithVariants) {
                return (AdhocComponentWithVariants)component;
            }
            return null;
        }
    }
}

