/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.impl.FirNoReceiverExpression;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirOptInUsageAccessChecker
extends FirExpressionChecker<FirQualifiedAccess> {
    @NotNull
    public static final FirOptInUsageAccessChecker INSTANCE = new FirOptInUsageAccessChecker();

    private FirOptInUsageAccessChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccess expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirExpression firExpression2;
        KtSourceElementKind sourceKind;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement ktSourceElement = expression2.getSource();
        KtSourceElementKind ktSourceElementKind = sourceKind = ktSourceElement != null ? ktSourceElement.getKind() : null;
        if (sourceKind instanceof KtFakeSourceElementKind.DataClassGeneratedMembers || sourceKind instanceof KtFakeSourceElementKind.PropertyFromParameter) {
            return;
        }
        FirBasedSymbol<?> firBasedSymbol = UtilsKt.getResolvedSymbol(expression2.getCalleeReference());
        if (firBasedSymbol == null) {
            return;
        }
        FirBasedSymbol<?> resolvedSymbol = firBasedSymbol;
        FirExpression it = firExpression2 = expression2.getDispatchReceiver();
        boolean bl = false;
        Object object = !(it instanceof FirNoReceiverExpression) ? firExpression2 : null;
        ConeKotlinType dispatchReceiverType = object != null && (object = ((FirExpression)object).getTypeRef()) != null && (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) != null ? TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)object, context2.getSession()) : null;
        FirOptInUsageBaseChecker $this$check_u24lambda_u2d1 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl2 = false;
        if (expression2 instanceof FirVariableAssignment && resolvedSymbol instanceof FirPropertySymbol) {
            Set experimentalities = SetsKt.plus($this$check_u24lambda_u2d1.loadExperimentalities(resolvedSymbol, context2, true, dispatchReceiverType), (Iterable)$this$check_u24lambda_u2d1.loadExperimentalitiesFromTypeArguments(context2, expression2.getTypeArguments()));
            $this$check_u24lambda_u2d1.reportNotAcceptedExperimentalities(experimentalities, ((FirVariableAssignment)expression2).getLValue(), context2, reporter);
            return;
        }
        Set experimentalities = SetsKt.plus($this$check_u24lambda_u2d1.loadExperimentalities(resolvedSymbol, context2, false, dispatchReceiverType), (Iterable)$this$check_u24lambda_u2d1.loadExperimentalitiesFromTypeArguments(context2, expression2.getTypeArguments()));
        $this$check_u24lambda_u2d1.reportNotAcceptedExperimentalities(experimentalities, expression2, context2, reporter);
    }
}

