/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints;

import java.io.Serializable;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Arrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntComparator;

public final class IntArrays {
    public static final int[] EMPTY_ARRAY = new int[0];
    public static final int[] DEFAULT_EMPTY_ARRAY = new int[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<int[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static int[] forceCapacity(int[] array2, int length, int preserve) {
        int[] t = new int[length];
        System.arraycopy(array2, 0, t, 0, preserve);
        return t;
    }

    public static void ensureOffsetLength(int[] a, int offset2, int length) {
        Arrays.ensureOffsetLength(a.length, offset2, length);
    }

    public static void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    public static void swap(int[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            IntArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(int[] x, int a, int b, int c, IntComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(int[] a, int from2, int to, IntComparator comp) {
        for (int i = from2; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (comp.compare(a[j], a[m]) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            int u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(int[] a, int from2, int to, IntComparator comp) {
        int i = from2;
        while (++i < to) {
            int t = a[i];
            int j = i;
            int u = a[j - 1];
            while (comp.compare(t, u) < 0) {
                a[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void quickSort(int[] x, int from2, int to, IntComparator comp) {
        int c;
        int a;
        int len = to - from2;
        if (len < 16) {
            IntArrays.selectionSort(x, from2, to, comp);
            return;
        }
        int m = from2 + len / 2;
        int l = from2;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = IntArrays.med3(x, l, l + s, l + 2 * s, comp);
            m = IntArrays.med3(x, m - s, m, m + s, comp);
            n = IntArrays.med3(x, n - 2 * s, n - s, n, comp);
        }
        m = IntArrays.med3(x, l, m, n, comp);
        int v = x[m];
        int b = a = from2;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            IntArrays.swap(x, b++, c--);
        }
        int s = Math.min(a - from2, b - a);
        IntArrays.swap(x, from2, b - s, s);
        s = Math.min(d - c, to - d - 1);
        IntArrays.swap(x, b, to - s, s);
        s = b - a;
        if (s > 1) {
            IntArrays.quickSort(x, from2, from2 + s, comp);
        }
        if ((s = d - c) > 1) {
            IntArrays.quickSort(x, to - s, to, comp);
        }
    }

    private static int med3(int[] x, int a, int b, int c) {
        int ab = Integer.compare(x[a], x[b]);
        int ac = Integer.compare(x[a], x[c]);
        int bc = Integer.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(int[] a, int from2, int to) {
        for (int i = from2; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (a[j] >= a[m]) continue;
                m = j;
            }
            if (m == i) continue;
            int u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    public static void quickSort(int[] x, int from2, int to) {
        int c;
        int a;
        int len = to - from2;
        if (len < 16) {
            IntArrays.selectionSort(x, from2, to);
            return;
        }
        int m = from2 + len / 2;
        int l = from2;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = IntArrays.med3(x, l, l + s, l + 2 * s);
            m = IntArrays.med3(x, m - s, m, m + s);
            n = IntArrays.med3(x, n - 2 * s, n - s, n);
        }
        m = IntArrays.med3(x, l, m, n);
        int v = x[m];
        int b = a = from2;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = Integer.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = Integer.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            IntArrays.swap(x, b++, c--);
        }
        int s = Math.min(a - from2, b - a);
        IntArrays.swap(x, from2, b - s, s);
        s = Math.min(d - c, to - d - 1);
        IntArrays.swap(x, b, to - s, s);
        s = b - a;
        if (s > 1) {
            IntArrays.quickSort(x, from2, from2 + s);
        }
        if ((s = d - c) > 1) {
            IntArrays.quickSort(x, to - s, to);
        }
    }

    public static void unstableSort(int[] a, int from2, int to) {
        if (to - from2 >= 2000) {
            IntArrays.radixSort(a, from2, to);
        } else {
            IntArrays.quickSort(a, from2, to);
        }
    }

    public static void unstableSort(int[] a) {
        IntArrays.unstableSort(a, 0, a.length);
    }

    public static void unstableSort(int[] a, int from2, int to, IntComparator comp) {
        IntArrays.quickSort(a, from2, to, comp);
    }

    public static void unstableSort(int[] a, IntComparator comp) {
        IntArrays.unstableSort(a, 0, a.length, comp);
    }

    public static void mergeSort(int[] a, int from2, int to, IntComparator comp, int[] supp) {
        int len = to - from2;
        if (len < 16) {
            IntArrays.insertionSort(a, from2, to, comp);
            return;
        }
        int mid = from2 + to >>> 1;
        IntArrays.mergeSort(supp, from2, mid, comp, a);
        IntArrays.mergeSort(supp, mid, to, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a, from2, len);
            return;
        }
        int p = from2;
        int q = mid;
        for (int i = from2; i < to; ++i) {
            a[i] = q >= to || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(int[] a, int from2, int to, IntComparator comp) {
        IntArrays.mergeSort(a, from2, to, comp, (int[])a.clone());
    }

    public static void stableSort(int[] a, int from2, int to) {
        IntArrays.unstableSort(a, from2, to);
    }

    public static void stableSort(int[] a, int from2, int to, IntComparator comp) {
        IntArrays.mergeSort(a, from2, to, comp);
    }

    public static void stableSort(int[] a, IntComparator comp) {
        IntArrays.stableSort(a, 0, a.length, comp);
    }

    public static void radixSort(int[] a, int from2, int to) {
        if (to - from2 < 1024) {
            IntArrays.quickSort(a, from2, to);
            return;
        }
        int maxLevel = 3;
        int stackSize = 766;
        int stackPos = 0;
        int[] offsetStack = new int[766];
        int[] lengthStack = new int[766];
        int[] levelStack = new int[766];
        offsetStack[stackPos] = from2;
        lengthStack[stackPos] = to - from2;
        levelStack[stackPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        while (stackPos > 0) {
            int first = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 4 == 0 ? 128 : 0;
            int shift = (3 - level % 4) * 8;
            int i = first + length;
            while (i-- != first) {
                int n = a[i] >>> shift & 0xFF ^ signMask;
                count[n] = count[n] + 1;
            }
            int lastUsed = -1;
            int p = first;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count[i2] != 0) {
                    lastUsed = i2;
                }
                pos[i2] = p += count[i2];
            }
            int end = first + length - count[lastUsed];
            int c = -1;
            for (int i3 = first; i3 <= end; i3 += count[c]) {
                int t = a[i3];
                c = t >>> shift & 0xFF ^ signMask;
                if (i3 < end) {
                    while (true) {
                        int n = c;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i3) break;
                        int z = t;
                        t = a[d];
                        a[d] = z;
                        c = t >>> shift & 0xFF ^ signMask;
                    }
                    a[i3] = t;
                }
                if (level < 3 && count[c] > 1) {
                    if (count[c] < 1024) {
                        IntArrays.quickSort(a, i3, i3 + count[c]);
                    } else {
                        offsetStack[stackPos] = i3;
                        lengthStack[stackPos] = count[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count[c] = 0;
            }
        }
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset2, int length, int level) {
            this.offset = offset2;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<int[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(int[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(int[] a, int[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }
}

