/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.execution.plan.FinalizerGroup;
import org.gradle.execution.plan.HasFinalizers;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeGroup;
import org.gradle.execution.plan.OrdinalGroup;

public class CompositeNodeGroup
extends HasFinalizers {
    private final NodeGroup ordinalGroup;
    private final Set<FinalizerGroup> finalizerGroups;
    private final boolean reachableFromEntryPoint;

    public CompositeNodeGroup(NodeGroup ordinalGroup, Set<FinalizerGroup> finalizerGroups) {
        this.ordinalGroup = ordinalGroup;
        this.finalizerGroups = finalizerGroups;
        this.reachableFromEntryPoint = this.reachableFromEntryPoint();
    }

    public CompositeNodeGroup(boolean reachableFromEntryPoint, NodeGroup newOrdinal, Set<FinalizerGroup> finalizerGroups) {
        this.ordinalGroup = newOrdinal;
        this.finalizerGroups = finalizerGroups;
        this.reachableFromEntryPoint = reachableFromEntryPoint;
    }

    public String toString() {
        return "composite group, entry point: " + this.isReachableFromEntryPoint() + ", ordinal: " + this.ordinalGroup + ", groups: " + this.finalizerGroups;
    }

    @Override
    @Nullable
    public OrdinalGroup asOrdinal() {
        return this.ordinalGroup.asOrdinal();
    }

    @Override
    public NodeGroup withOrdinalGroup(OrdinalGroup newOrdinal) {
        return new CompositeNodeGroup(this.reachableFromEntryPoint, newOrdinal, this.finalizerGroups);
    }

    @Override
    public NodeGroup getOrdinalGroup() {
        return this.ordinalGroup;
    }

    @Override
    public boolean isReachableFromEntryPoint() {
        return this.reachableFromEntryPoint;
    }

    private boolean reachableFromEntryPoint() {
        if (this.ordinalGroup.isReachableFromEntryPoint()) {
            return true;
        }
        for (FinalizerGroup group : this.finalizerGroups) {
            if (!group.isReachableFromEntryPoint()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addMember(Node node) {
        for (FinalizerGroup group : this.finalizerGroups) {
            group.addMember(node);
        }
    }

    @Override
    public void removeMember(Node node) {
        for (FinalizerGroup group : this.finalizerGroups) {
            group.removeMember(node);
        }
    }

    @Override
    public Set<FinalizerGroup> getFinalizerGroups() {
        return this.finalizerGroups;
    }

    @Override
    public boolean isCanCancel() {
        for (FinalizerGroup group : this.finalizerGroups) {
            if (group.isCanCancel()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Node.DependenciesState checkSuccessorsCompleteFor(Node node) {
        if (this.ordinalGroup.isReachableFromEntryPoint()) {
            return Node.DependenciesState.COMPLETE_AND_SUCCESSFUL;
        }
        Node.DependenciesState state = Node.DependenciesState.COMPLETE_AND_CAN_SKIP;
        for (FinalizerGroup group : this.finalizerGroups) {
            Node.DependenciesState groupState = group.checkSuccessorsCompleteFor(node);
            if (groupState == Node.DependenciesState.COMPLETE_AND_SUCCESSFUL) {
                return Node.DependenciesState.COMPLETE_AND_SUCCESSFUL;
            }
            if (groupState != Node.DependenciesState.NOT_COMPLETE) continue;
            state = Node.DependenciesState.NOT_COMPLETE;
        }
        return state;
    }
}

