/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cli.io.support;

import io.micronaut.cli.io.support.Resource;
import io.micronaut.cli.io.support.ResourceUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;

public class FileSystemResource
implements Resource {
    private final File file;
    private final String path;

    public FileSystemResource(File file) {
        this.assertNotNull(file, "File must not be null");
        this.file = file;
        this.path = ResourceUtils.cleanPath(file.getPath());
    }

    public FileSystemResource(String path) {
        this.assertNotNull(path, "Path must not be null");
        this.file = new File(path);
        this.path = ResourceUtils.cleanPath(path);
    }

    public final String getPath() {
        return this.path;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isReadable() {
        return this.file.canRead() && !this.file.isDirectory();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public URL getURL() throws IOException {
        return this.file.toURI().toURL();
    }

    @Override
    public URI getURI() throws IOException {
        return this.file.toURI();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public long contentLength() throws IOException {
        return this.file.length();
    }

    @Override
    public long lastModified() throws IOException {
        return this.file.lastModified();
    }

    @Override
    public String getFilename() {
        return this.file.getName();
    }

    @Override
    public String getDescription() {
        return "file [" + this.file.getAbsolutePath() + "]";
    }

    @Override
    public Resource createRelative(String relativePath) {
        String pathToUse = ResourceUtils.applyRelativePath(this.path, relativePath);
        return new FileSystemResource(pathToUse);
    }

    public boolean isWritable() {
        return this.file.canWrite() && !this.file.isDirectory();
    }

    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.file);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof FileSystemResource && this.path.equals(((FileSystemResource)obj).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    protected void assertNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public String toString() {
        return this.file.toString();
    }
}

