/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.init;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.boot.cli.command.init.InitializrServiceMetadata;
import org.springframework.boot.cli.command.init.ProjectGenerationRequest;
import org.springframework.boot.cli.command.init.ProjectGenerationResponse;
import org.springframework.boot.cli.command.init.ReportableException;
import org.springframework.boot.cli.util.Log;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

class InitializrService {
    private static final String FILENAME_HEADER_PREFIX = "filename=\"";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final String ACCEPT_META_DATA = "application/vnd.initializr.v2.1+json,application/vnd.initializr.v2+json";
    public static final String ACCEPT_SERVICE_CAPABILITIES = "text/plain,application/vnd.initializr.v2.1+json,application/vnd.initializr.v2+json";
    private CloseableHttpClient http;

    InitializrService() {
    }

    InitializrService(CloseableHttpClient http) {
        this.http = http;
    }

    protected CloseableHttpClient getHttp() {
        if (this.http == null) {
            this.http = HttpClientBuilder.create().useSystemProperties().build();
        }
        return this.http;
    }

    public ProjectGenerationResponse generate(ProjectGenerationRequest request) throws IOException {
        Log.info("Using service at " + request.getServiceUrl());
        InitializrServiceMetadata metadata = this.loadMetadata(request.getServiceUrl());
        URI url = request.generateUrl(metadata);
        CloseableHttpResponse httpResponse = this.executeProjectGenerationRequest(url);
        HttpEntity httpEntity = httpResponse.getEntity();
        this.validateResponse(httpResponse, request.getServiceUrl());
        return this.createResponse(httpResponse, httpEntity);
    }

    public InitializrServiceMetadata loadMetadata(String serviceUrl) throws IOException {
        CloseableHttpResponse httpResponse = this.executeInitializrMetadataRetrieval(serviceUrl);
        this.validateResponse(httpResponse, serviceUrl);
        return this.parseJsonMetadata(httpResponse.getEntity());
    }

    public Object loadServiceCapabilities(String serviceUrl) throws IOException {
        HttpGet request = new HttpGet(serviceUrl);
        request.setHeader(new BasicHeader("Accept", ACCEPT_SERVICE_CAPABILITIES));
        CloseableHttpResponse httpResponse = this.execute(request, serviceUrl, "retrieve help");
        this.validateResponse(httpResponse, serviceUrl);
        HttpEntity httpEntity = httpResponse.getEntity();
        ContentType contentType = ContentType.getOrDefault(httpEntity);
        if (contentType.getMimeType().equals("text/plain")) {
            return this.getContent(httpEntity);
        }
        return this.parseJsonMetadata(httpEntity);
    }

    private InitializrServiceMetadata parseJsonMetadata(HttpEntity httpEntity) throws IOException {
        try {
            return new InitializrServiceMetadata(this.getContentAsJson(httpEntity));
        }
        catch (JSONException ex) {
            throw new ReportableException("Invalid content received from server (" + ex.getMessage() + ")", ex);
        }
    }

    private void validateResponse(CloseableHttpResponse httpResponse, String serviceUrl) {
        if (httpResponse.getEntity() == null) {
            throw new ReportableException("No content received from server '" + serviceUrl + "'");
        }
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw this.createException(serviceUrl, httpResponse);
        }
    }

    private ProjectGenerationResponse createResponse(CloseableHttpResponse httpResponse, HttpEntity httpEntity) throws IOException {
        ProjectGenerationResponse response = new ProjectGenerationResponse(ContentType.getOrDefault(httpEntity));
        response.setContent(FileCopyUtils.copyToByteArray(httpEntity.getContent()));
        String fileName = this.extractFileName(httpResponse.getFirstHeader("Content-Disposition"));
        if (fileName != null) {
            response.setFileName(fileName);
        }
        return response;
    }

    private CloseableHttpResponse executeProjectGenerationRequest(URI url) {
        return this.execute(new HttpGet(url), url, "generate project");
    }

    private CloseableHttpResponse executeInitializrMetadataRetrieval(String url) {
        HttpGet request = new HttpGet(url);
        request.setHeader(new BasicHeader("Accept", ACCEPT_META_DATA));
        return this.execute(request, url, "retrieve metadata");
    }

    private CloseableHttpResponse execute(HttpUriRequest request, Object url, String description) {
        try {
            request.addHeader("User-Agent", "SpringBootCli/" + this.getClass().getPackage().getImplementationVersion());
            return this.getHttp().execute(request);
        }
        catch (IOException ex) {
            throw new ReportableException("Failed to " + description + " from service at '" + url + "' (" + ex.getMessage() + ")");
        }
    }

    private ReportableException createException(String url, CloseableHttpResponse httpResponse) {
        String message = "Initializr service call failed using '" + url + "' - service returned " + httpResponse.getStatusLine().getReasonPhrase();
        String error = this.extractMessage(httpResponse.getEntity());
        if (StringUtils.hasText(error)) {
            message = message + ": '" + error + "'";
        } else {
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            message = message + " (unexpected " + statusCode + " error)";
        }
        throw new ReportableException(message);
    }

    private String extractMessage(HttpEntity entity) {
        if (entity != null) {
            try {
                JSONObject error = this.getContentAsJson(entity);
                if (error.has("message")) {
                    return error.getString("message");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private JSONObject getContentAsJson(HttpEntity entity) throws IOException, JSONException {
        return new JSONObject(this.getContent(entity));
    }

    private String getContent(HttpEntity entity) throws IOException {
        ContentType contentType = ContentType.getOrDefault(entity);
        Charset charset = contentType.getCharset();
        charset = charset != null ? charset : UTF_8;
        byte[] content = FileCopyUtils.copyToByteArray(entity.getContent());
        return new String(content, charset);
    }

    private String extractFileName(Header header) {
        int end;
        String value;
        int start;
        if (header != null && (start = (value = header.getValue()).indexOf(FILENAME_HEADER_PREFIX)) != -1 && (end = (value = value.substring(start + FILENAME_HEADER_PREFIX.length())).indexOf("\"")) != -1) {
            return value.substring(0, end);
        }
        return null;
    }
}

