/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.cli.internal.extension.model.CoreExtension;
import org.apache.maven.cli.internal.extension.model.io.xpp3.CoreExtensionsXpp3Reader;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.mvndaemon.mvnd.client.BuildProperties;
import org.mvndaemon.mvnd.common.Environment;
import org.mvndaemon.mvnd.common.Os;
import org.mvndaemon.mvnd.common.SocketFamily;
import org.mvndaemon.mvnd.common.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaemonParameters {
    public static final String LOG_EXTENSION = ".log";
    private static final Logger LOG = LoggerFactory.getLogger(DaemonParameters.class);
    private static final String EXT_CLASS_PATH = "maven.ext.class.path";
    private static final String EXTENSIONS_FILENAME = ".mvn/extensions.xml";
    protected final Map<Path, Properties> mvndProperties = new ConcurrentHashMap<Path, Properties>();
    protected final Function<Path, Properties> provider = path -> this.mvndProperties.computeIfAbsent((Path)path, p -> DaemonParameters.loadProperties(path));
    private final Map<String, String> properties;

    public DaemonParameters() {
        this.properties = Collections.emptyMap();
    }

    protected DaemonParameters(PropertiesBuilder propertiesBuilder) {
        this.properties = propertiesBuilder.build();
    }

    public List<String> getDaemonOpts() {
        return this.discriminatingValues().map(envValue -> envValue.envKey.asDaemonOpt(envValue.asString())).collect(Collectors.toList());
    }

    public Map<String, String> getDaemonOptsMap() {
        return this.discriminatingValues().collect(Collectors.toMap(envValue -> envValue.envKey.getProperty(), EnvValue::asString));
    }

    Stream<EnvValue> discriminatingValues() {
        return Arrays.stream(Environment.values()).filter(Environment::isDiscriminating).map(this::property).filter(EnvValue::isSet);
    }

    public void discriminatingCommandLineOptions(List<String> args) {
        this.discriminatingValues().forEach(envValue -> envValue.envKey.addCommandLineOption((Collection)args, envValue.asString()));
    }

    public Path mvndHome() {
        return this.value(Environment.MVND_HOME).or(new ValueSource(description -> description.append("path relative to the mvnd executable"), this::mvndHomeFromExecutable)).orSystemProperty().orEnvironmentVariable().orLocalProperty(this.provider, this.suppliedPropertiesPath()).orLocalProperty(this.provider, this.localPropertiesPath()).orLocalProperty(this.provider, this.userPropertiesPath()).orFail().asPath().toAbsolutePath().normalize();
    }

    private String mvndHomeFromExecutable() {
        Path mvndDaemonLib;
        Path mvndH;
        Optional<String> cmd = ProcessHandle.current().info().command();
        if (Environment.isNative() && cmd.isPresent() && (mvndH = Paths.get(cmd.get(), new String[0]).getParent().getParent()) != null && Files.exists(mvndDaemonLib = mvndH.resolve("mvn/lib/ext/mvnd-daemon-" + BuildProperties.getInstance().getVersion() + ".jar"), new LinkOption[0])) {
            return mvndH.toString();
        }
        return null;
    }

    public Path javaHome() {
        Path result = this.value(Environment.JAVA_HOME).orEnvironmentVariable().orLocalProperty(this.provider, this.suppliedPropertiesPath()).orLocalProperty(this.provider, this.localPropertiesPath()).orLocalProperty(this.provider, this.userPropertiesPath()).orLocalProperty(this.provider, this.globalPropertiesPath()).orSystemProperty().orFail().asPath();
        try {
            return result.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get a real path from path " + result);
        }
    }

    public Path userDir() {
        return this.value(Environment.USER_DIR).orSystemProperty().orFail().asPath().toAbsolutePath();
    }

    public Path userHome() {
        return this.value(Environment.USER_HOME).orSystemProperty().orFail().asPath().toAbsolutePath();
    }

    public Path suppliedPropertiesPath() {
        return this.value(Environment.MVND_PROPERTIES_PATH).orEnvironmentVariable().orSystemProperty().asPath();
    }

    public Path jvmConfigPath() {
        return this.multiModuleProjectDirectory().resolve(".mvn/jvm.config");
    }

    public Path localPropertiesPath() {
        return this.multiModuleProjectDirectory().resolve(".mvn/mvnd.properties");
    }

    public Path userPropertiesPath() {
        return this.userHome().resolve(".m2/mvnd.properties");
    }

    public Path globalPropertiesPath() {
        return this.mvndHome().resolve("conf/mvnd.properties");
    }

    public Path daemonStorage() {
        return this.value(Environment.MVND_DAEMON_STORAGE).orSystemProperty().orDefault(() -> this.userHome().resolve(".m2/mvnd/registry/" + BuildProperties.getInstance().getVersion()).toString()).asPath();
    }

    public Path registry() {
        return this.daemonStorage().resolve("registry.bin");
    }

    public Path daemonLog(String daemon) {
        return this.daemonStorage().resolve("daemon-" + daemon + LOG_EXTENSION);
    }

    public Path daemonOutLog(String daemon) {
        return this.daemonStorage().resolve("daemon-" + daemon + ".out.log");
    }

    public Path multiModuleProjectDirectory() {
        return this.multiModuleProjectDirectory(this.userDir());
    }

    public Path multiModuleProjectDirectory(Path projectDir) {
        return this.value(Environment.MAVEN_MULTIMODULE_PROJECT_DIRECTORY).orSystemProperty().orDefault(() -> DaemonParameters.findDefaultMultimoduleProjectDirectory(projectDir)).asPath().toAbsolutePath().normalize();
    }

    public Path logbackConfigurationPath() {
        return this.property(Environment.MVND_LOGBACK).orDefault(() -> this.mvndHome().resolve("conf/logback.xml").toString()).orFail().asPath();
    }

    public String minHeapSize() {
        return this.property(Environment.MVND_MIN_HEAP_SIZE).asString();
    }

    public String maxHeapSize() {
        return this.property(Environment.MVND_MAX_HEAP_SIZE).asString();
    }

    public String threadStackSize() {
        return this.property(Environment.MVND_THREAD_STACK_SIZE).asString();
    }

    public String jvmArgs() {
        return this.property(Environment.MVND_JVM_ARGS).asString();
    }

    public String jdkJavaOpts() {
        return this.property(Environment.JDK_JAVA_OPTIONS).asString();
    }

    public String threads() {
        return this.property(Environment.MVND_THREADS).orDefault(() -> String.valueOf(this.property(Environment.MVND_MIN_THREADS).asInt(m -> Math.max(Runtime.getRuntime().availableProcessors() - 1, m)))).orFail().asString();
    }

    public String builder() {
        return this.property(Environment.MVND_BUILDER).orFail().asString();
    }

    public Path settings() {
        return this.property(Environment.MAVEN_SETTINGS).asPath();
    }

    public Path file() {
        return this.value(Environment.MAVEN_FILE).asPath();
    }

    public Path mavenRepoLocal() {
        return this.property(Environment.MAVEN_REPO_LOCAL).asPath();
    }

    public boolean noDaemon() {
        return this.value(Environment.MVND_NO_DAEMON).orSystemProperty().orEnvironmentVariable().orDefault().asBoolean();
    }

    public boolean serial() {
        return this.value(Environment.SERIAL).orSystemProperty().orDefault().asBoolean();
    }

    public DaemonParameters cd(Path newUserDir) {
        return this.derive(b -> b.put(Environment.USER_DIR, newUserDir));
    }

    public DaemonParameters withJdkJavaOpts(String opts, boolean before) {
        String org = this.properties.getOrDefault(Environment.JDK_JAVA_OPTIONS.getProperty(), "");
        return this.derive(b -> b.put(Environment.JDK_JAVA_OPTIONS, org.isEmpty() ? opts : (before ? opts + " " + org : org + " " + opts)));
    }

    public DaemonParameters withJvmArgs(String opts, boolean before) {
        String org = this.properties.getOrDefault(Environment.MVND_JVM_ARGS.getProperty(), "");
        return this.derive(b -> b.put(Environment.MVND_JVM_ARGS, org.isEmpty() ? opts : (before ? opts + " " + org : org + " " + opts)));
    }

    protected DaemonParameters derive(Consumer<PropertiesBuilder> customizer) {
        PropertiesBuilder builder = new PropertiesBuilder().putAll(this.properties);
        customizer.accept(builder);
        return new DaemonParameters(builder);
    }

    public Duration keepAlive() {
        return this.property(Environment.MVND_KEEP_ALIVE).orFail().asDuration();
    }

    public int maxLostKeepAlive() {
        return this.property(Environment.MVND_MAX_LOST_KEEP_ALIVE).orFail().asInt();
    }

    public boolean noBuffering() {
        return this.property(Environment.MVND_NO_BUFERING).orFail().asBoolean();
    }

    public int rollingWindowSize() {
        return this.property(Environment.MVND_ROLLING_WINDOW_SIZE).orFail().asInt();
    }

    public Duration purgeLogPeriod() {
        return this.property(Environment.MVND_LOG_PURGE_PERIOD).orFail().asDuration();
    }

    public Optional<SocketFamily> socketFamily() {
        return this.property(Environment.MVND_SOCKET_FAMILY).asOptional().map(SocketFamily::valueOf);
    }

    public static String findDefaultMultimoduleProjectDirectory(Path pwd) {
        Path dir = pwd;
        do {
            if (!Files.isDirectory(dir.resolve(".mvn"), new LinkOption[0])) continue;
            return dir.toString();
        } while ((dir = dir.getParent()) != null);
        return pwd.toString();
    }

    public EnvValue property(Environment env) {
        return this.value(env).orSystemProperty().orLocalProperty(this.provider, this.suppliedPropertiesPath()).orLocalProperty(this.provider, this.localPropertiesPath()).orLocalProperty(this.provider, this.userPropertiesPath()).orLocalProperty(this.provider, this.globalPropertiesPath()).orDefault(() -> this.defaultValue(env));
    }

    protected EnvValue value(Environment env) {
        return new EnvValue(env, new ValueSource(description -> description.append("value: ").append(env.getProperty()), () -> this.properties.get(env.getProperty())));
    }

    public static EnvValue systemProperty(Environment env) {
        return new EnvValue(env, EnvValue.systemPropertySource(env));
    }

    public static EnvValue environmentVariable(Environment env) {
        return new EnvValue(env, EnvValue.environmentVariableSource(env));
    }

    public static EnvValue fromValueSource(Environment env, ValueSource valueSource) {
        return new EnvValue(env, valueSource);
    }

    private String defaultValue(Environment env) {
        if (env == Environment.MVND_EXT_CLASSPATH) {
            List<String> cp = DaemonParameters.parseExtClasspath(this.userHome());
            return String.join((CharSequence)",", cp);
        }
        if (env == Environment.MVND_CORE_EXTENSIONS) {
            try {
                List extensions = DaemonParameters.readCoreExtensionsDescriptor(this.multiModuleProjectDirectory()).stream().map(e -> e.getGroupId() + ":" + e.getArtifactId() + ":" + e.getVersion()).collect(Collectors.toList());
                return String.join((CharSequence)";", extensions);
            }
            catch (IOException | XmlPullParserException e2) {
                throw new RuntimeException("Unable to parse core extensions", e2);
            }
        }
        return env.getDefault();
    }

    private static List<String> parseExtClasspath(Path userDir) {
        String extClassPath = System.getProperty(EXT_CLASS_PATH);
        ArrayList<String> jars = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)extClassPath)) {
            for (String jar : StringUtils.split((String)extClassPath, (String)File.pathSeparator)) {
                Path path = userDir.resolve(jar).toAbsolutePath();
                jars.add(path.toString());
            }
        }
        return jars;
    }

    private static List<CoreExtension> readCoreExtensionsDescriptor(Path multiModuleProjectDirectory) throws IOException, XmlPullParserException {
        if (multiModuleProjectDirectory == null) {
            return Collections.emptyList();
        }
        Path extensionsFile = multiModuleProjectDirectory.resolve(EXTENSIONS_FILENAME);
        if (!Files.exists(extensionsFile, new LinkOption[0])) {
            return Collections.emptyList();
        }
        CoreExtensionsXpp3Reader parser = new CoreExtensionsXpp3Reader();
        try (InputStream is = Files.newInputStream(extensionsFile, new OpenOption[0]);){
            List list = parser.read(is).getExtensions();
            return list;
        }
    }

    private static Properties loadProperties(Path path) {
        Properties result = new Properties();
        if (Files.exists(path, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                result.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read " + path);
            }
        }
        return result;
    }

    public static class PropertiesBuilder {
        private Map<String, String> properties = new LinkedHashMap<String, String>();

        public PropertiesBuilder put(Environment envKey, Object value) {
            if (value == null) {
                this.properties.remove(envKey.getProperty());
            } else {
                this.properties.put(envKey.getProperty(), value.toString());
            }
            return this;
        }

        public PropertiesBuilder putAll(Map<String, String> props) {
            this.properties.putAll(props);
            return this;
        }

        public Map<String, String> build() {
            Map<String, String> props = this.properties;
            this.properties = null;
            return Collections.unmodifiableMap(props);
        }
    }

    public static class EnvValue {
        static Map<String, String> env = System.getenv();
        private final Environment envKey;
        private final ValueSource valueSource;
        protected EnvValue previous;

        public EnvValue(Environment envKey, ValueSource valueSource) {
            this.previous = null;
            this.envKey = envKey;
            this.valueSource = valueSource;
        }

        public EnvValue(EnvValue previous, Environment envKey, ValueSource valueSource) {
            this.previous = previous;
            this.envKey = envKey;
            this.valueSource = valueSource;
        }

        private static ValueSource systemPropertySource(Environment env) {
            String property = env.getProperty();
            if (property == null) {
                throw new IllegalStateException("Cannot use " + Environment.class.getName() + " for getting a system property");
            }
            return new ValueSource(description -> description.append("system property ").append(property), () -> Environment.getProperty((String)property));
        }

        private static ValueSource environmentVariableSource(Environment env) {
            String envVar = env.getEnvironmentVariable();
            if (envVar == null) {
                throw new IllegalStateException("Cannot use " + Environment.class.getName() + "." + env.name() + " for getting an environment variable");
            }
            return new ValueSource(description -> description.append("environment variable ").append(envVar), () -> env.get(envVar));
        }

        public EnvValue orSystemProperty() {
            return new EnvValue(this, this.envKey, EnvValue.systemPropertySource(this.envKey));
        }

        public EnvValue orLocalProperty(Function<Path, Properties> provider, Path localPropertiesPath) {
            if (localPropertiesPath != null) {
                return new EnvValue(this, this.envKey, new ValueSource(description -> description.append("property ").append(this.envKey.getProperty()).append(" in ").append(localPropertiesPath), () -> ((Properties)provider.apply(localPropertiesPath)).getProperty(this.envKey.getProperty())));
            }
            return this;
        }

        public EnvValue orEnvironmentVariable() {
            return new EnvValue(this, this.envKey, EnvValue.environmentVariableSource(this.envKey));
        }

        public EnvValue or(ValueSource source) {
            return new EnvValue(this, this.envKey, source);
        }

        public EnvValue orDefault() {
            return this.orDefault(() -> ((Environment)this.envKey).getDefault());
        }

        public EnvValue orDefault(Supplier<String> defaultSupplier) {
            return new EnvValue(this, this.envKey, new ValueSource(sb -> sb.append("default: ").append((String)defaultSupplier.get()), defaultSupplier));
        }

        public EnvValue orFail() {
            return new EnvValue(this, this.envKey, new ValueSource(sb -> sb, () -> {
                throw this.couldNotgetValue();
            }));
        }

        IllegalStateException couldNotgetValue() {
            EnvValue val = this;
            StringBuilder sb = new StringBuilder("Could not get value for ").append(Environment.class.getSimpleName()).append(".").append(this.envKey.name()).append(" from any of the following sources: ");
            Function<StringBuilder, StringBuilder> description = s -> s;
            while (val != null) {
                description = description.compose(val.valueSource.descriptionFunction);
                val = val.previous;
                if (val == null) continue;
                description = description.compose(s -> s.append(", "));
            }
            description.apply(sb);
            return new IllegalStateException(sb.toString());
        }

        String get() {
            String result;
            if (this.previous != null && (result = this.previous.get()) != null) {
                return result;
            }
            result = this.valueSource.valueSupplier.get();
            if (result != null && LOG.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder("Loaded environment value for key [").append(this.envKey.name()).append("] from ");
                this.valueSource.descriptionFunction.apply(sb);
                sb.append(": [").append(result).append(']');
                LOG.trace(sb.toString());
            }
            return result;
        }

        public String asString() {
            return this.get();
        }

        public Optional<String> asOptional() {
            return Optional.ofNullable(this.get());
        }

        public Path asPath() {
            String result = this.get();
            if (result != null && Os.current().isCygwin()) {
                result = Environment.cygpath((String)result);
            }
            return result == null ? null : Paths.get(result, new String[0]);
        }

        public boolean asBoolean() {
            String val = this.get();
            return "".equals(val) || Boolean.parseBoolean(val);
        }

        public int asInt() {
            return Integer.parseInt(this.get());
        }

        public int asInt(IntUnaryOperator function) {
            return function.applyAsInt(this.asInt());
        }

        public Duration asDuration() {
            return TimeUtils.toDuration((String)this.get());
        }

        public boolean isSet() {
            if (this.get() != null) {
                return true;
            }
            if (this.envKey.isOptional()) {
                return false;
            }
            throw this.couldNotgetValue();
        }
    }

    public static class ValueSource {
        final Function<StringBuilder, StringBuilder> descriptionFunction;
        final Supplier<String> valueSupplier;

        public ValueSource(Function<StringBuilder, StringBuilder> descriptionFunction, Supplier<String> valueSupplier) {
            this.descriptionFunction = descriptionFunction;
            this.valueSupplier = valueSupplier;
        }

        public String toString() {
            return this.descriptionFunction.apply(new StringBuilder()).toString();
        }
    }
}

