/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mvndaemon.mvnd.common.Os;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OsUtils.class);
    private static final long KB = 1024L;
    private static final String UNITS = "Bkmgt";

    private OsUtils() {
    }

    public static String bytesTohumanReadable(long bytes) {
        int unit;
        for (unit = 0; bytes >= 1024L && unit < UNITS.length() - 1; bytes /= 1024L, ++unit) {
        }
        String kbString = String.valueOf(bytes);
        return new StringBuilder(kbString.length() + 1).append(kbString).append(UNITS.charAt(unit)).toString();
    }

    public static String kbTohumanReadable(long kb) {
        int unit;
        for (unit = 1; kb >= 1024L && unit < UNITS.length() - 1; kb /= 1024L, ++unit) {
        }
        String kbString = String.valueOf(kb);
        return new StringBuilder(kbString.length() + 1).append(kbString).append(UNITS.charAt(unit)).toString();
    }

    public static long findProcessRssInKb(long pid) {
        Os os = Os.current();
        if (os.isUnixLike()) {
            String[] cmd = new String[]{"ps", "-o", "rss=", "-p", String.valueOf(pid)};
            ArrayList<String> output = new ArrayList<String>(1);
            OsUtils.exec(cmd, output);
            if (output.size() == 1) {
                try {
                    return Long.parseLong(((String)output.get(0)).trim());
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Could not parse the output of " + Stream.of(cmd).collect(Collectors.joining(" ")) + " as a long:\n" + output.stream().collect(Collectors.joining("\n")));
                }
            } else {
                LOGGER.warn("Unexpected output of " + Stream.of(cmd).collect(Collectors.joining(" ")) + ":\n" + output.stream().collect(Collectors.joining("\n")));
            }
            return -1L;
        }
        if (os == Os.WINDOWS) {
            String[] cmd = new String[]{"wmic", "process", "where", "processid=" + pid, "get", "WorkingSetSize"};
            ArrayList<String> output = new ArrayList<String>(1);
            OsUtils.exec(cmd, output);
            List nonEmptyLines = output.stream().filter(l -> !l.isEmpty()).collect(Collectors.toList());
            if (nonEmptyLines.size() >= 2) {
                try {
                    return Long.parseLong(((String)nonEmptyLines.get(1)).trim()) / 1024L;
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Could not parse the second line of " + Stream.of(cmd).collect(Collectors.joining(" ")) + " output as a long:\n" + nonEmptyLines.stream().collect(Collectors.joining("\n")));
                }
            } else {
                LOGGER.warn("Unexpected output of " + Stream.of(cmd).collect(Collectors.joining(" ")) + ":\n" + output.stream().collect(Collectors.joining("\n")));
            }
            return -1L;
        }
        return -1L;
    }

    private static void exec(String[] cmd, List<String> output) {
        ProcessBuilder builder = new ProcessBuilder(cmd).redirectErrorStream(true);
        try (CommandProcess ps = new CommandProcess(builder.start(), output::add);){
            int exitCode = ps.waitFor(1000L);
            if (exitCode != 0) {
                LOGGER.warn(Stream.of(cmd).collect(Collectors.joining(" ")) + " exited with " + exitCode + ":\n" + output.stream().collect(Collectors.joining("\n")));
            }
        }
        catch (IOException e) {
            LOGGER.warn("Could not execute " + Stream.of(cmd).collect(Collectors.joining(" ")));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static class CommandProcess
    implements AutoCloseable {
        public static final int TIMEOUT_EXIT_CODE = -2147483606;
        private final Process process;
        private final Thread shutDownHook;
        private final StreamGobbler stdOut;

        public CommandProcess(Process process, Consumer<String> outputConsumer) {
            this.process = process;
            this.stdOut = new StreamGobbler(process.getInputStream(), outputConsumer);
            this.stdOut.start();
            this.shutDownHook = new Thread(new Runnable(){

                @Override
                public void run() {
                    stdOut.cancel();
                    process.destroy();
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutDownHook);
        }

        @Override
        public void close() {
            this.process.destroy();
        }

        public int waitFor(long timeoutMs) throws InterruptedException, IOException {
            long deadline = System.currentTimeMillis() + timeoutMs;
            boolean timeouted = !this.process.waitFor(timeoutMs, TimeUnit.MILLISECONDS);
            timeoutMs = Math.max(0L, deadline - System.currentTimeMillis());
            this.stdOut.join(timeoutMs);
            this.stdOut.assertSuccess();
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int exitCode = timeouted ? -2147483606 : this.process.exitValue();
            return exitCode;
        }

        static class StreamGobbler
        extends Thread {
            private volatile boolean cancelled;
            private IOException exception;
            private final InputStream in;
            private final Consumer<String> out;

            private StreamGobbler(InputStream in, Consumer<String> out) {
                this.in = in;
                this.out = out;
            }

            public void assertSuccess() throws IOException {
                if (this.exception != null) {
                    throw this.exception;
                }
            }

            public void cancel() {
                this.cancelled = true;
            }

            @Override
            public void run() {
                try (BufferedReader r = new BufferedReader(new InputStreamReader(this.in, StandardCharsets.UTF_8));){
                    String line;
                    while (!this.cancelled && (line = r.readLine()) != null) {
                        this.out.accept(line);
                    }
                }
                catch (IOException e) {
                    this.exception = e;
                }
            }
        }
    }
}

