/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.client;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.mvndaemon.mvnd.client.DaemonClientConnection;
import org.mvndaemon.mvnd.client.DaemonDiagnostics;
import org.mvndaemon.mvnd.client.DaemonParameters;
import org.mvndaemon.mvnd.common.DaemonCompatibilitySpec;
import org.mvndaemon.mvnd.common.DaemonConnection;
import org.mvndaemon.mvnd.common.DaemonException;
import org.mvndaemon.mvnd.common.DaemonInfo;
import org.mvndaemon.mvnd.common.DaemonRegistry;
import org.mvndaemon.mvnd.common.DaemonState;
import org.mvndaemon.mvnd.common.DaemonStopEvent;
import org.mvndaemon.mvnd.common.Environment;
import org.mvndaemon.mvnd.common.MavenDaemon;
import org.mvndaemon.mvnd.common.Message;
import org.mvndaemon.mvnd.common.Os;
import org.mvndaemon.mvnd.common.SocketFamily;
import org.mvndaemon.mvnd.common.logging.ClientOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaemonConnector {
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    public static final int CANCELED_WAIT_TIMEOUT = 3000;
    private static final int CONNECT_TIMEOUT = 10000;
    private static final Logger LOGGER = LoggerFactory.getLogger(DaemonConnector.class);
    private final DaemonRegistry registry;
    private final DaemonParameters parameters;

    public DaemonConnector(DaemonParameters parameters, DaemonRegistry registry) {
        this.parameters = parameters;
        this.registry = registry;
    }

    public DaemonClientConnection maybeConnect(DaemonCompatibilitySpec constraint) {
        return this.findConnection(this.getCompatibleDaemons(this.registry.getAll(), constraint));
    }

    public DaemonClientConnection maybeConnect(DaemonInfo daemon) {
        try {
            return this.connectToDaemon(daemon, new CleanupOnStaleAddress(daemon), false);
        }
        catch (DaemonException.ConnectException e) {
            LOGGER.debug("Cannot connect to daemon {} due to {}. Ignoring.", (Object)daemon, (Object)e);
            return null;
        }
    }

    public DaemonClientConnection connect(ClientOutput output) {
        if (this.parameters.noDaemon()) {
            return this.connectNoDaemon();
        }
        DaemonCompatibilitySpec constraint = new DaemonCompatibilitySpec(this.parameters.javaHome(), this.parameters.getDaemonOpts());
        output.accept((Message)Message.buildStatus((String)"Looking up daemon..."));
        Map<Boolean, List<DaemonInfo>> idleBusy = this.registry.getAll().stream().collect(Collectors.groupingBy(di -> di.getState() == DaemonState.Idle));
        Collection idleDaemons = idleBusy.getOrDefault(true, Collections.emptyList());
        Collection busyDaemons = idleBusy.getOrDefault(false, Collections.emptyList());
        DaemonClientConnection connection = this.connectToIdleDaemon(idleDaemons, constraint);
        if (connection != null) {
            return connection;
        }
        connection = this.connectToCanceledDaemon(busyDaemons, constraint);
        if (connection != null) {
            return connection;
        }
        String daemonId = DaemonConnector.newId();
        String message = this.handleStopEvents(daemonId, idleDaemons, busyDaemons);
        output.accept((Message)Message.buildStatus((String)message));
        return this.startDaemon(daemonId);
    }

    private DaemonClientConnection connectNoDaemon() {
        if (Environment.isNative()) {
            throw new UnsupportedOperationException("The " + Environment.MVND_NO_DAEMON.getProperty() + " property is not supported in native mode.");
        }
        String daemon = ProcessHandle.current().pid() + "-" + System.currentTimeMillis();
        Properties properties = new Properties();
        properties.put(Environment.JAVA_HOME.getProperty(), this.parameters.javaHome().toString());
        properties.put(Environment.USER_DIR.getProperty(), this.parameters.userDir().toString());
        properties.put(Environment.USER_HOME.getProperty(), this.parameters.userHome().toString());
        properties.put(Environment.MVND_HOME.getProperty(), this.parameters.mvndHome().toString());
        properties.put(Environment.MVND_ID.getProperty(), daemon);
        properties.put(Environment.MVND_DAEMON_STORAGE.getProperty(), this.parameters.daemonStorage().toString());
        properties.put(Environment.MVND_REGISTRY.getProperty(), this.parameters.registry().toString());
        properties.putAll(this.parameters.getDaemonOptsMap());
        Environment.setProperties((Properties)properties);
        AtomicReference throwable = new AtomicReference();
        Thread serverThread = new Thread(() -> {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass("org.mvndaemon.mvnd.daemon.Server");
                try (AutoCloseable server = (AutoCloseable)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);){
                    ((Runnable)((Object)server)).run();
                }
            }
            catch (Throwable t) {
                throwable.set(t);
            }
        });
        serverThread.start();
        long start = System.currentTimeMillis();
        do {
            DaemonClientConnection daemonConnection;
            if ((daemonConnection = this.connectToDaemonWithId(daemon, true)) != null) {
                return daemonConnection;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new DaemonException.InterruptedException((Throwable)e);
            }
        } while (serverThread.isAlive() && System.currentTimeMillis() - start < 30000L);
        throw new RuntimeException("Unable to connect to internal daemon", (Throwable)throwable.get());
    }

    private String handleStopEvents(String daemonId, Collection<DaemonInfo> idleDaemons, Collection<DaemonInfo> busyDaemons) {
        List stopEvents = this.registry.getStopEvents();
        long time = System.currentTimeMillis() - TimeUnit.HOURS.toMillis(1L);
        List oldStopEvents = stopEvents.stream().filter(e -> e.getTimestamp() < time).collect(Collectors.toList());
        this.registry.removeStopEvents(oldStopEvents);
        List recentStopEvents = stopEvents.stream().filter(e -> e.getTimestamp() >= time).collect(Collectors.groupingBy(DaemonStopEvent::getDaemonId, Collectors.minBy(this::compare))).values().stream().map(Optional::get).collect(Collectors.toList());
        for (DaemonStopEvent stopEvent : recentStopEvents) {
            LOGGER.debug("Previous Daemon ({}) stopped at {} {}", new Object[]{stopEvent.getDaemonId(), stopEvent.getTimestamp(), stopEvent.getReason()});
        }
        return DaemonConnector.generate(daemonId, busyDaemons.size(), idleDaemons.size(), recentStopEvents.size());
    }

    public static String generate(String daemonId, int numBusy, int numIncompatible, int numStopped) {
        int totalUnavailableDaemons = numBusy + numIncompatible + numStopped;
        if (totalUnavailableDaemons > 0) {
            ArrayList<CallSite> reasons = new ArrayList<CallSite>();
            if (numBusy > 0) {
                reasons.add((CallSite)((Object)(numBusy + " busy")));
            }
            if (numIncompatible > 0) {
                reasons.add((CallSite)((Object)(numIncompatible + " incompatible")));
            }
            if (numStopped > 0) {
                reasons.add((CallSite)((Object)(numStopped + " stopped")));
            }
            return "Starting new daemon " + daemonId + ", " + String.join((CharSequence)" and ", reasons) + " daemon" + (totalUnavailableDaemons > 1 ? "s" : "") + " could not be reused, use --status for details";
        }
        return "Starting new daemon " + daemonId + " (subsequent builds will be faster)...";
    }

    private int compare(DaemonStopEvent event1, DaemonStopEvent event2) {
        if (event1.getStatus() != null && event2.getStatus() == null) {
            return -1;
        }
        if (event1.getStatus() == null && event2.getStatus() != null) {
            return 1;
        }
        if (event1.getStatus() != null && event2.getStatus() != null) {
            return event2.getStatus().compareTo((Enum)event1.getStatus());
        }
        return 0;
    }

    private DaemonClientConnection connectToIdleDaemon(Collection<DaemonInfo> idleDaemons, DaemonCompatibilitySpec constraint) {
        List<DaemonInfo> compatibleIdleDaemons = this.getCompatibleDaemons(idleDaemons, constraint);
        LOGGER.debug("Found {} idle daemons, {} compatibles", (Object)idleDaemons.size(), (Object)compatibleIdleDaemons.size());
        return this.findConnection(compatibleIdleDaemons);
    }

    private DaemonClientConnection connectToCanceledDaemon(Collection<DaemonInfo> busyDaemons, DaemonCompatibilitySpec constraint) {
        DaemonClientConnection connection = null;
        List<DaemonInfo> canceledBusy = busyDaemons.stream().filter(di -> di.getState() == DaemonState.Canceled).collect(Collectors.toList());
        List<DaemonInfo> compatibleCanceledDaemons = this.getCompatibleDaemons(canceledBusy, constraint);
        LOGGER.debug("Found {} busy daemons, {} cancelled, {} compatibles", new Object[]{busyDaemons.size(), canceledBusy.size(), compatibleCanceledDaemons.size()});
        if (!compatibleCanceledDaemons.isEmpty()) {
            LOGGER.debug("Waiting for daemons with canceled builds to become available");
            long start = System.currentTimeMillis();
            while (connection == null && System.currentTimeMillis() - start < 3000L) {
                try {
                    Thread.sleep(200L);
                    connection = this.connectToIdleDaemon(this.registry.getIdle(), constraint);
                }
                catch (InterruptedException e) {
                    throw new DaemonException.InterruptedException((Throwable)e);
                }
            }
        }
        return connection;
    }

    private List<DaemonInfo> getCompatibleDaemons(Iterable<DaemonInfo> daemons, DaemonCompatibilitySpec constraint) {
        LinkedList<DaemonInfo> compatibleDaemons = new LinkedList<DaemonInfo>();
        for (DaemonInfo daemon : daemons) {
            DaemonCompatibilitySpec.Result result = constraint.isSatisfiedBy(daemon);
            if (result.isCompatible()) {
                compatibleDaemons.add(daemon);
                continue;
            }
            LOGGER.debug("{} daemon {} does not match the desired criteria: " + result.getWhy(), (Object)daemon.getState(), (Object)daemon.getId());
        }
        return compatibleDaemons;
    }

    private DaemonClientConnection findConnection(List<DaemonInfo> compatibleDaemons) {
        for (DaemonInfo daemon : compatibleDaemons) {
            try {
                return this.connectToDaemon(daemon, new CleanupOnStaleAddress(daemon), false);
            }
            catch (DaemonException.ConnectException e) {
                LOGGER.debug("Cannot connect to daemon {} due to {}. Trying a different daemon...", (Object)daemon, (Object)e);
            }
        }
        return null;
    }

    public DaemonClientConnection startDaemon(String daemonId) {
        Process process = this.startDaemonProcess(daemonId);
        LOGGER.debug("Started Maven daemon {}", (Object)daemonId);
        long start = System.currentTimeMillis();
        do {
            DaemonClientConnection daemonConnection;
            if ((daemonConnection = this.connectToDaemonWithId(daemonId, true)) != null) {
                return daemonConnection;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                throw new DaemonException.InterruptedException((Throwable)e);
            }
        } while (process.isAlive() && System.currentTimeMillis() - start < 30000L);
        DaemonDiagnostics diag = new DaemonDiagnostics(daemonId, this.parameters);
        throw new DaemonException.ConnectException("Timeout waiting to connect to the Maven daemon.\n" + diag.describe());
    }

    static String newId() {
        return String.format("%08x", new Random().nextInt());
    }

    private Process startDaemonProcess(String daemonId) {
        Process process;
        block18: {
            Path mvndHome = this.parameters.mvndHome();
            Path workingDir = this.parameters.userDir();
            String command = "";
            DirectoryStream<Path> jarPaths = Files.newDirectoryStream(mvndHome.resolve("mvn/lib/ext"));
            try {
                Process process2;
                String threadStackSize;
                String maxHeapSize;
                String string;
                String jvmArgs;
                ArrayList<String> args = new ArrayList<String>();
                String java = Os.current().isUnixLike() ? "bin/java" : "bin\\java.exe";
                args.add(this.parameters.javaHome().resolve(java).toString());
                String mvndCommonPath = null;
                String mvndAgentPath = null;
                for (Path path : jarPaths) {
                    String s = path.getFileName().toString();
                    if (!s.endsWith(".jar")) continue;
                    if (s.startsWith("mvnd-common-")) {
                        mvndCommonPath = path.toString();
                        continue;
                    }
                    if (!s.startsWith("mvnd-agent-")) continue;
                    mvndAgentPath = path.toString();
                }
                if (mvndCommonPath == null) {
                    throw new IllegalStateException("Could not find mvnd-common jar in mvn/lib/ext/");
                }
                if (mvndAgentPath == null) {
                    throw new IllegalStateException("Could not find mvnd-agent jar in mvn/lib/ext/");
                }
                args.add("-classpath");
                args.add(mvndCommonPath + File.pathSeparator + mvndAgentPath);
                args.add("-javaagent:" + mvndAgentPath);
                if (this.parameters.property(Environment.MVND_DEBUG).asBoolean()) {
                    args.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=8000");
                }
                if ((jvmArgs = this.parameters.jvmArgs()) != null) {
                    for (String arg : jvmArgs.split(" ")) {
                        if (arg.isEmpty()) continue;
                        args.add(arg);
                    }
                }
                if ((string = this.parameters.minHeapSize()) != null) {
                    args.add("-Xms" + string);
                }
                if ((maxHeapSize = this.parameters.maxHeapSize()) != null) {
                    args.add("-Xmx" + maxHeapSize);
                }
                if ((threadStackSize = this.parameters.threadStackSize()) != null) {
                    args.add("-Xss" + threadStackSize);
                }
                Environment.MVND_HOME.addCommandLineOption(args, mvndHome.toString());
                args.add("-Dmaven.home=" + mvndHome.resolve("mvn"));
                args.add("-Dmaven.conf=" + mvndHome.resolve("mvn/conf"));
                Environment.MVND_JAVA_HOME.addCommandLineOption(args, this.parameters.javaHome().toString());
                Environment.LOGBACK_CONFIGURATION_FILE.addCommandLineOption(args, this.parameters.logbackConfigurationPath().toString());
                Environment.MVND_ID.addCommandLineOption(args, daemonId);
                Environment.MVND_DAEMON_STORAGE.addCommandLineOption(args, this.parameters.daemonStorage().toString());
                Environment.MVND_REGISTRY.addCommandLineOption(args, this.parameters.registry().toString());
                Environment.MVND_SOCKET_FAMILY.addCommandLineOption(args, this.parameters.socketFamily().orElseGet(() -> this.getJavaVersion() >= 16.0f ? SocketFamily.unix : SocketFamily.inet).toString());
                this.parameters.discriminatingCommandLineOptions(args);
                args.add(MavenDaemon.class.getName());
                command = String.join((CharSequence)" ", args);
                LOGGER.debug("Starting daemon process: id = {}, workingDir = {}, daemonArgs: {}", new Object[]{daemonId, workingDir, command});
                ProcessBuilder.Redirect redirect = ProcessBuilder.Redirect.appendTo(this.parameters.daemonOutLog(daemonId).toFile());
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                processBuilder.environment().put(Environment.JDK_JAVA_OPTIONS.getEnvironmentVariable(), this.parameters.jdkJavaOpts());
                process = process2 = processBuilder.directory(workingDir.toFile()).command(args).redirectOutput(redirect).redirectError(redirect).start();
                if (jarPaths == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (jarPaths != null) {
                        try {
                            jarPaths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DaemonException.StartException(String.format("Error starting daemon: id = %s, workingDir = %s, daemonArgs: %s", daemonId, workingDir, command), (Throwable)e);
                }
            }
            jarPaths.close();
        }
        return process;
    }

    private float getJavaVersion() {
        try {
            String java = Os.current().isUnixLike() ? "bin/java" : "bin\\java.exe";
            Path javaExec = this.parameters.javaHome().resolve(java);
            ArrayList<String> args = new ArrayList<String>();
            args.add(javaExec.toString());
            args.add("-version");
            Process process = new ProcessBuilder(new String[0]).directory(this.parameters.mvndHome().toFile()).command(args).start();
            process.waitFor();
            Scanner sc = new Scanner(process.getErrorStream());
            sc.next();
            sc.next();
            String version = sc.next();
            LOGGER.warn("JAVA VERSION: " + version);
            int is = version.charAt(0) == '\"' ? 1 : 0;
            int ie = version.indexOf(46, version.indexOf(46, is));
            return Float.parseFloat(version.substring(is, ie));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to detect java version", e);
        }
    }

    private DaemonClientConnection connectToDaemonWithId(String daemon, boolean newDaemon) throws DaemonException.ConnectException {
        DaemonInfo daemonInfo = this.registry.get(daemon);
        if (daemonInfo != null) {
            try {
                return this.connectToDaemon(daemonInfo, new CleanupOnStaleAddress(daemonInfo), newDaemon);
            }
            catch (DaemonException.ConnectException e) {
                DaemonDiagnostics diag = new DaemonDiagnostics(daemon, this.parameters);
                throw new DaemonException.ConnectException("Could not connect to the Maven daemon.\n" + diag.describe(), (Throwable)e);
            }
        }
        return null;
    }

    private DaemonClientConnection connectToDaemon(DaemonInfo daemon, DaemonClientConnection.StaleAddressDetector staleAddressDetector, boolean newDaemon) throws DaemonException.ConnectException {
        LOGGER.debug("Connecting to Daemon");
        try {
            DaemonConnection connection = this.connect(daemon.getAddress(), daemon.getToken());
            DaemonClientConnection daemonClientConnection = new DaemonClientConnection(connection, daemon, staleAddressDetector, newDaemon, this.parameters);
            return daemonClientConnection;
        }
        catch (DaemonException.ConnectException e) {
            staleAddressDetector.maybeStaleAddress((Exception)((Object)e));
            throw e;
        }
        finally {
            LOGGER.debug("Connected");
        }
    }

    public DaemonConnection connect(String str, byte[] token) throws DaemonException.ConnectException {
        SocketAddress address = SocketFamily.fromString((String)str);
        try {
            LOGGER.debug("Trying to connect to address {}.", (Object)address);
            SocketFamily family = SocketFamily.familyOf((SocketAddress)address);
            SocketChannel socketChannel = family.openSocket();
            socketChannel.configureBlocking(false);
            boolean connected = socketChannel.connect(address);
            if (!connected) {
                long t0 = System.nanoTime();
                long t1 = t0 + TimeUnit.MICROSECONDS.toNanos(10000L);
                while (!connected && t0 < t1) {
                    Thread.sleep(10L);
                    connected = socketChannel.finishConnect();
                    if (connected) continue;
                    t0 = System.nanoTime();
                }
                if (!connected) {
                    throw new IOException("Timeout");
                }
            }
            socketChannel.configureBlocking(true);
            LOGGER.debug("Connected to address {}.", (Object)socketChannel.getRemoteAddress());
            ByteBuffer tokenBuffer = ByteBuffer.wrap(token);
            do {
                socketChannel.write(tokenBuffer);
            } while (tokenBuffer.remaining() > 0);
            LOGGER.debug("Exchanged token successfully");
            return new DaemonConnection(socketChannel);
        }
        catch (DaemonException.ConnectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DaemonException.ConnectException(String.format("Could not connect to server %s.", address), (Throwable)e);
        }
    }

    private class CleanupOnStaleAddress
    implements DaemonClientConnection.StaleAddressDetector {
        private final DaemonInfo daemon;

        public CleanupOnStaleAddress(DaemonInfo daemon) {
            this.daemon = daemon;
        }

        @Override
        public boolean maybeStaleAddress(Exception failure) {
            LOGGER.debug("Removing daemon from the registry due to communication failure. Daemon information: {}", (Object)this.daemon);
            long timestamp = System.currentTimeMillis();
            DaemonStopEvent stopEvent = new DaemonStopEvent(this.daemon.getId(), timestamp, null, "by user or operating system");
            DaemonConnector.this.registry.storeStopEvent(stopEvent);
            DaemonConnector.this.registry.remove(this.daemon.getId());
            return true;
        }
    }
}

