/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class BuildProperties {
    private static final BuildProperties INSTANCE = BuildProperties.load();
    private final String version;
    private final String osName;
    private final String osArch;
    private final String revision;

    public static BuildProperties getInstance() {
        return INSTANCE;
    }

    public static BuildProperties load() {
        Properties buildProperties = new Properties();
        try (InputStream is = BuildProperties.class.getResourceAsStream("build.properties");){
            buildProperties.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read build.properties");
        }
        return new BuildProperties(buildProperties.getProperty("version"), buildProperties.getProperty("revision"), buildProperties.getProperty("os.detected.name"), buildProperties.getProperty("os.detected.arch"));
    }

    public BuildProperties(String version, String revision, String os, String arch) {
        this.version = version;
        this.revision = revision;
        this.osName = os;
        this.osArch = arch;
    }

    public String getVersion() {
        return this.version;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsArch() {
        return this.osArch;
    }

    public String getRevision() {
        return this.revision;
    }
}

