/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.sync;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.spi.synccontext.SyncContextFactory;
import org.eclipse.sisu.Priority;
import org.mvndaemon.mvnd.common.Environment;

@Singleton
@Named
@Priority(value=20)
public class MvndSyncContextFactory
implements SyncContextFactory {
    public static final String FACTORY_NOOP = "noop";
    public static final String FACTORY_IPC = "ipc";
    public static final String FACTORY_LOCAL = "local";
    public static final String IPC_SYNC_CONTEXT_FACTORY = "org.mvndaemon.mvnd.sync.IpcSyncContextFactory";
    private final Map<String, SyncContextFactory> factories;

    public MvndSyncContextFactory() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(FACTORY_LOCAL, new LocalSyncContextFactory());
            map.put(FACTORY_NOOP, new NoopSyncContextFactory());
            Class<?> factoryClass = this.getClass().getClassLoader().loadClass(IPC_SYNC_CONTEXT_FACTORY);
            map.put(FACTORY_IPC, (SyncContextFactory)factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            this.factories = Collections.unmodifiableMap(map);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create IpcSyncContextFactory instance", e);
        }
    }

    public SyncContext newInstance(RepositorySystemSession repositorySystemSession, boolean shared) {
        String name = Environment.MVND_SYNC_CONTEXT_FACTORY.asOptional().orElseGet(() -> ((Environment)Environment.MVND_SYNC_CONTEXT_FACTORY).getDefault());
        SyncContextFactory factory = this.factories.get(name);
        if (factory == null) {
            throw new RuntimeException("Unable to find SyncContextFactory named '" + name + "'");
        }
        return factory.newInstance(repositorySystemSession, shared);
    }

    private static class LocalSyncContextFactory
    implements SyncContextFactory {
        final Map<String, Lock> locks = new ConcurrentHashMap<String, Lock>();

        private LocalSyncContextFactory() {
        }

        public SyncContext newInstance(RepositorySystemSession session, boolean shared) {
            return new LocalSyncContext();
        }

        private class LocalSyncContext
        implements SyncContext {
            private final Deque<String> locked = new ArrayDeque<String>();

            private LocalSyncContext() {
            }

            public void acquire(Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
                this.stream(artifacts).map(this::getKey).sorted().forEach(this::acquire);
                this.stream(metadatas).map(this::getKey).sorted().forEach(this::acquire);
            }

            private void acquire(String key) {
                try {
                    this.getLock(key).lock();
                    this.locked.add(key);
                }
                catch (Exception e) {
                    this.close();
                    throw new IllegalStateException("Could not acquire lock for '" + key + "'", e);
                }
            }

            public void close() {
                String key;
                while ((key = this.locked.poll()) != null) {
                    this.getLock(key).unlock();
                }
            }

            private Lock getLock(String key) {
                return LocalSyncContextFactory.this.locks.computeIfAbsent(key, k -> new ReentrantLock());
            }

            private <T> Stream<T> stream(Collection<T> col) {
                return col != null ? col.stream() : Stream.empty();
            }

            private String getKey(Artifact a) {
                return "artifact:" + a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getBaseVersion();
            }

            private String getKey(Metadata m) {
                StringBuilder key = new StringBuilder("metadata:");
                if (!m.getGroupId().isEmpty()) {
                    key.append(m.getGroupId());
                    if (!m.getArtifactId().isEmpty()) {
                        key.append(':').append(m.getArtifactId());
                        if (!m.getVersion().isEmpty()) {
                            key.append(':').append(m.getVersion());
                        }
                    }
                }
                return key.toString();
            }
        }
    }

    private static class NoopSyncContextFactory
    implements SyncContextFactory {
        private NoopSyncContextFactory() {
        }

        public SyncContext newInstance(RepositorySystemSession repositorySystemSession, boolean shared) {
            return new SyncContext(){

                public void acquire(Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
                }

                public void close() {
                }
            };
        }
    }
}

