/************************************************************************
*																		*
* 			Pandora Products - Jim Schimpf Std Support Stuff			*
*					Copyright 1998 J.Schimpf							*
*  																		*
*					MAC FILE I/O INCLUDE FILE							*
*																		*
*		Module:filepac.h												*
*																		*
*	Version		Date	Person  	Description							*
*-----------------------------------------------------------------------*
*	0.1		12-Feb-88	J.Schimpf	Initial Version						*
*	0.2		 3-Aug-91	J.Schimpf	Add seek,tell & rewind				*
*	0.3		 1-Jan-92	J.Schimpf	Add file name to MFILE				*
*	0.4		 8-Aug-95	J.Schimpf	Convert to object					*
*	0.5		22-Sep-95	J.Schimpf	Add open/close by name				*
*	1.1		 9-Nov-95	J.Schimpf	Change to buffered only				*
*	1.2		14-May-96	J.Schimpf	Add ref # to open by name			*
*	1.3		28-Jun-96	J.Schimpf	Add FSSpec operations				*
*	1.4		 2-Aug-96	J.Schimpf	Add FWRITE operation				*
*	1.5		 3-Aug-96	J.Schimpf	Add GETEOF (file size) operation	*
*	1.6		 3-Aug-96	J.Schimpf	FREAD returns # bytes				*
*	1.7		26-Sep-98	J.Schimpf	Convert to ANSI std operations		*
*																		*
*	DESCRIPTION:													    *
*		MAC File I/O operations as a buffered stream					*
*																		*
*																		*
************************************************************************/

//#include <Types.h>
//#include <StandardFile.h>
//#include <Files.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>

#pragma once

/*  USEFUL STUFF */
													
/************************************************************
*		OBJECT DEFS
************************************************************/

class  CBufFile {

	public:
	
		CBufFile(void);				// Class constructor
		~CBufFile(void);			// Class destructor
			
		bool fopen(char *name,char *type);
		void fclose(void);
		
		int fprintf(char *format,...);
		int fputs( char *str );
		char *fgets( char *str,int size );
		int fread( char *str,int size );
		int fwrite( char *buf,int size );
		
		int fseek( long offset,int whence);
		long ftell(void);
		int rewind( void );
		long GetEOFpsn( void );
		
		void fflush();

	private:
	
		FILE *fp;
};
