/************************************************************************
*																		*
* 			University of Utah - Jim Schimpf Std Support Stuff			*
*					Nu-Metrics - OBJECT CODE SUPPORT					*
*  					Copyright 1987 University of Utah					*
*					Copyright 1995 Nu-Metrics, Inc.						*
*					Copyright 1998 Jim Schimpf							*
*  																		*
*					MAC FILE LEXICAL ANALYZER FOR C						*
*																		*
*		Module:CTokFile.h												*
*																		*
*	Version		Date	Person  	Description							*
*-----------------------------------------------------------------------*
*	0.1		12-Feb-88	J.Schimpf	Initial Version						*
*	0.2		 3-Aug-91	J.Schimpf	Add seek,tell & rewind				*
*	0.3		 1-Jan-92	J.Schimpf	Add file name to MFILE				*
*	0.4		 8-Aug-95	J.Schimpf	Convert to object					*
*	0.5		22-Sep-95	J.Schimpf	Convert to file tokenizer			*
*	0.6		22-Jan-97	J.Schimpf	Add initializer						*
*	0.7		27-Sep-98	J.Schimpf	Convert to C lexical analyzer		*
*	0.8		 1-Feb-99	J.Schimpf	Add STRING/LSTRING support			*
*	0.9		20-May-99	J.Schimpf	Add packed/unpacked types			*
*																		*
*	DESCRIPTION:													    *
*		Converts file to a stream of tokens								*
*		TOKEN := [<WS chars>]<Contigious characters = TOKEN>[<WS>]		*
*				 Maximum # characters in token in MAX_TOK				*
*		Characters in a line following <COMMENT_CHAR> are ignored to EOL*
*		NOTE: Files are treated as lines and TOKENS cannot be extend	*
*		over line breaks												*
*																		*
*																		*
************************************************************************/

#include "CLexFile.h"

#pragma once

/*  USEFUL STUFF */

#define MAX_C_TOKEN		128

// *** POSSIBLE C TYPES TO BE DECODED ***
enum {
		C_TOK_CHAR,			// Var TYPES
		C_TOK_LSTRING,
		C_TOK_STRING,
		C_TOK_SHORT,
		C_TOK_INT,
		C_TOK_LONG,
		C_TOK_INT32,
		C_TOK_UINT32,
		C_TOK_FLOAT,
		C_TOK_UNSIGNED,

		C_TOK_STRUCT,		// SYNTAX ELEMENTS
		C_TOK_OPEN_BRACE,
		C_TOK_CLOSE_BRACE,
		C_TOK_OPEN_BRACKET,
		C_TOK_CLOSE_BRACKET,

		C_TOK_NAME,			// Variable name
		C_TOK_DEF,			// VAR Def value
		
		C_TOK_CLASS,			// DEFINES
		C_TOK_CNAME,
		C_TOK_TEST,
		C_TOK_TNAME,
		C_TOK_TYPE,
		C_TOK_DEVTYPE,
		C_TOK_PACKED,

		C_TOK_LINE_CMT,		// Syntatic noise
		C_TOK_CMT_OPEN,
		C_TOK_CMT_CLOSE,

		C_TOK_NOISE 		// Ignore stuff (i.e. :)
	};
			
/************************************************************
*		OBJECT DEFS
************************************************************/

class CcLexFile : public CLexFile {

	public:
	
		void init(void);	// Initialize for run
		
		int get_token( char *token );			// Get a token
		//void unget_token(char *token);			// Unget last token received
		int get_char( );						// Pull one character at a time
		void unget_char();						// Restore last char to buf
	private:

		int get_pending_token( char *token );

		char cur_token[MAX_C_TOKEN];
		int tok_psn;
};
