
/************************************************************************
*																		*
*		Pandora Proeucts - Jim Schimpf C SUPPORT CODE					*
*		Copyright 2002 J.Schimpf Pandora Products						*
*																		*
*			C SUPPORT ROUTINES											*
*																		*
*		Module:cutil.c													*
*																		*
*	Version	   Date		Person  	Description							*
*-----------------------------------------------------------------------*
*       0.1     29-Nov-88       J.Schimpf       Initial Version         *
*		0.2		27-Jul-2002 	J.Schimpf		Conversion to UNIX		*
*												support routines		*
*																		*
*	DESCRIPTION:														*
*		These are useful C support routines for the PC & cmd line UNIX	*
*																		*
*	Procedures:															*
*																		*
*	Written+	Name		Description 								*
*-----------------------------------------------------------------------*
*	y		print_center()	Print text at center of screen				*
*	y		error_exit()	Exit program & tell user problem			*
*	y		flag_srch()	Read command args								*
*																		*
************************************************************************/

/******* INCLUDE FILES ******/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "base.h"
#include "cutil.h"

/***********************************************************************
*               SUPPORT ROUTINES
************************************************************************/
/***********************************************************************
*
*  PRINT_CENTER( str )  - Print this string in the center of the screen
*
*       INPUT:  str     - String to be printed
*
*       OUTPUT: Clear and print the string in the center of the screen
*
*       ASSUME: 24 Lines on screen
*               80 Characters across
*
***********************************************************************/

void print_center(char *str )
{
	int len,left;
	int i;

	/*  1) Calculate the # of spaces to move in for this string */

	len = strlen( str );
	left = (80-len)/2;

	/*  2) Print this number of spaces & then the string */

	for( i=0; i<left; i++)
		printf(" ");

	printf("%s\n",str);

}

/***********************************************************************
*
*  ERROR_EXIT( str )  - Print this string & error out
*
*       INPUT:  str     - String to be printed
*
*       OUTPUT: Clear and print the string in the center of the screen
*               Halt and wait for user to hit a key then EXIT
*
*       ASSUME: 80 Characters across
*
***********************************************************************/

void error_exit(char *str )
{
	/* 1) Print the string & output close the serial output */

	print_center( str );
	exit(-1);
}

/***********************************************************************
*
*  FLAG_SRCH(argc,argv,flag,get_value,&rtn )
*
*	INPUT:	argc,argv	- Command line parameters
*		flag		- String (flag) to be found
*		get_value	- TRUE return pointer to next item
*				  FALSE no pointer returned
*		rtn		- Return pointer (NULL if not used or
*				  found)
*
*	OUTPUT:	TRUE if flag found
*		FALSE if not
*		Scan argument list for flag
*		If found then TRUE is returned and if get_value TRUE
*		return rtn pointing to string in argv[] following 
*		the flag
*		NOTE only exact matches will be found
*
**********************************************************************/

int flag_srch(int argc,char *argv[],char *flag,int get_value,char **rtn )
{
	int i;
	char *ptr;
	
	/*  Scan through the argv's and look for a matching flag */
	
	for( i=0; i<argc; i++ )
	{
		ptr = argv[i];
		if( strcmp(ptr,flag) == 0 )
		{
		
		/*  Match found, return pointer to the following
			(if requested or NULL if not)
		*/
			i++;
			if( get_value && i < argc )
				*rtn = argv[i];
			else
				*rtn = NULL;
			return( TRUE );
		}
	}
	
	/*  Failure exit here, so return to user with FALSE */
	
	return( FALSE );
}
