/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class TranslationCheck
extends AbstractFileSetCheck {
    public TranslationCheck() {
        this.setFileExtensions(new String[]{"properties"});
    }

    private static String extractPropertyIdentifier(File aFile) {
        String filePath = aFile.getPath();
        int dirNameEnd = filePath.lastIndexOf(File.separatorChar);
        int baseNameStart = dirNameEnd + 1;
        int underscoreIdx = filePath.indexOf(95, baseNameStart);
        int dotIdx = filePath.indexOf(46, baseNameStart);
        int cutoffIdx = underscoreIdx != -1 ? underscoreIdx : dotIdx;
        return filePath.substring(0, cutoffIdx);
    }

    private static Map arrangePropertyFiles(File[] aPropFiles) {
        HashMap<String, HashSet<File>> propFileMap = new HashMap<String, HashSet<File>>();
        for (int i = 0; i < aPropFiles.length; ++i) {
            File f = aPropFiles[i];
            String identifier = TranslationCheck.extractPropertyIdentifier(f);
            HashSet<File> fileSet = (HashSet<File>)propFileMap.get(identifier);
            if (fileSet == null) {
                fileSet = new HashSet<File>();
                propFileMap.put(identifier, fileSet);
            }
            fileSet.add(f);
        }
        return propFileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set loadKeys(File aFile) {
        HashSet keys = new HashSet();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(aFile);
            Properties props = new Properties();
            props.load(inStream);
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                keys.add(e.nextElement());
            }
        }
        catch (IOException e) {
            this.logIOException(e, aFile);
        }
        finally {
            try {
                ((InputStream)inStream).close();
            }
            catch (IOException e) {
                this.logIOException(e, aFile);
            }
        }
        return keys;
    }

    private void logIOException(IOException aEx, File aFile) {
        Object[] args = null;
        String key = "general.fileNotFound";
        if (!(aEx instanceof FileNotFoundException)) {
            args = new String[]{aEx.getMessage()};
            key = "general.exception";
        }
        LocalizedMessage message = new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", key, args, this.getClass());
        LocalizedMessage[] messages = new LocalizedMessage[]{message};
        this.getMessageDispatcher().fireErrors(aFile.getPath(), messages);
        Utils.getExceptionLogger().debug("IOException occured.", aEx);
    }

    private void compareKeySets(Set aKeys, Map aFileMap) {
        Set fls = aFileMap.keySet();
        Iterator iter = fls.iterator();
        while (iter.hasNext()) {
            File currentFile = (File)iter.next();
            MessageDispatcher dispatcher = this.getMessageDispatcher();
            String path = currentFile.getPath();
            dispatcher.fireFileStarted(path);
            Set currentKeys = (Set)aFileMap.get(currentFile);
            HashSet keysClone = new HashSet(aKeys);
            keysClone.removeAll(currentKeys);
            if (!keysClone.isEmpty()) {
                Iterator it = keysClone.iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    this.log(0, "translation.missingKey", key);
                }
            }
            this.fireErrors(path);
            dispatcher.fireFileFinished(path);
        }
    }

    private void checkPropertyFileSets(Map aPropFiles) {
        Set keySet = aPropFiles.keySet();
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            String baseName = (String)iterator.next();
            Set files = (Set)aPropFiles.get(baseName);
            if (files.size() < 2) continue;
            HashSet keys = new HashSet();
            HashMap<File, Set> fileMap = new HashMap<File, Set>();
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                File file = (File)iter.next();
                Set fileKeys = this.loadKeys(file);
                keys.addAll(fileKeys);
                fileMap.put(file, fileKeys);
            }
            this.compareKeySets(keys, fileMap);
        }
    }

    public void process(File[] aFiles) {
        File[] propertyFiles = this.filter(aFiles);
        Map propFilesMap = TranslationCheck.arrangePropertyFiles(propertyFiles);
        this.checkPropertyFileSets(propFilesMap);
    }
}

