/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Data;
using System.Collections;
using System.Globalization;

namespace PostgreSql.Data.NPgClient
{
	internal class PgCharSetCollection : ArrayList
	{
		#region Properties

		public new PgCharSet this[int index]
		{
			get { return (PgCharSet)base[index]; }
			set { base[index] = (PgCharSet)value; }
		}

		public PgCharSet this[string name] 
		{
			get { return (PgCharSet)this[IndexOf(name)]; }
			set { this[IndexOf(name)] = (PgCharSet)value; }
		}

		#endregion

		#region Methods
	
		public bool Contains(string charset)
		{
			return(-1 != IndexOf(charset));
		}
		
		public int IndexOf(string charset)
		{
			int index = 0;
			foreach(PgCharSet item in this)
			{
				if (cultureAwareCompare(item.CharSet, charset))
				{
					return index;
				}
				index++;
			}
			return -1;
		}

		public void RemoveAt(string charset)
		{
			RemoveAt(IndexOf(charset));
		}

		public PgCharSet Add(PgCharSet charset)
		{
			base.Add(charset);

			return charset;
		}

		public PgCharSet Add(string charset, string systemCharset)
		{
			PgCharSet charSet = new PgCharSet(charset, systemCharset);

			base.Add(charSet);

			return charSet;
		}

		public PgCharSet Add(string charset, int cp)
		{
			PgCharSet charSet = new PgCharSet(charset, cp);

			base.Add(charSet);

			return charSet;
		}

		private bool cultureAwareCompare(string strA, string strB)
		{
			return CultureInfo.CurrentCulture.CompareInfo.Compare(
				strA, 
				strB, 
				CompareOptions.IgnoreKanaType | CompareOptions.IgnoreWidth | 
				CompareOptions.IgnoreCase) == 0 ? true : false;
		}

		#endregion
	}
}
