/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SimpleStepExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.SubExpressionInfo;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.CopyOf;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AncestorQualifiedPattern;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.ItemTypePattern;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternMaker;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlashExpression
extends Expression
implements ContextSwitchingExpression,
ContextMappingFunction<Item> {
    Expression start;
    Expression step;

    public SlashExpression(Expression start, Expression step) {
        this.start = start;
        this.step = step;
        this.adoptChildExpression(start);
        this.adoptChildExpression(step);
    }

    public void setStartExpression(Expression start2) {
        if (this.start != start2) {
            this.start = start2;
            this.adoptChildExpression(this.start);
        }
    }

    public void setStepExpression(Expression step2) {
        if (this.step != step2) {
            this.step = step2;
            this.adoptChildExpression(this.step);
        }
    }

    @Override
    public Expression getControllingExpression() {
        return this.start;
    }

    @Override
    public Expression getControlledExpression() {
        return this.step;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.setStartExpression(visitor.simplify(this.start));
        this.setStepExpression(visitor.simplify(this.step));
        return this;
    }

    @Override
    public final ItemType getItemType(TypeHierarchy th) {
        return this.step.getItemType(th);
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        return this.step.getIntegerBounds();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        Expression start2 = visitor.typeCheck(this.start, contextItemType);
        RoleLocator role0 = new RoleLocator(1, "/", 0);
        role0.setErrorCode("XPTY0019");
        this.setStartExpression(TypeChecker.staticTypeCheck(start2, SequenceType.NODE_SEQUENCE, false, role0, visitor));
        this.setStepExpression(visitor.typeCheck(this.step, new ExpressionVisitor.ContextItemType(this.start.getItemType(th), false)));
        SlashExpression e2 = this.simplifyDescendantPath(visitor.getStaticContext());
        if (e2 != null) {
            return ((Expression)e2).typeCheck(visitor, contextItemType);
        }
        if (this.start instanceof ContextItemExpression && (this.step.getSpecialProperties() & 0x20000) != 0) {
            return this.step;
        }
        if (this.step instanceof ContextItemExpression && (this.start.getSpecialProperties() & 0x20000) != 0) {
            return this.start;
        }
        return this;
    }

    private SlashExpression simplifyDescendantPath(StaticContext env) {
        Expression st = this.start;
        if (this.start instanceof AxisExpression) {
            AxisExpression stax = (AxisExpression)this.start;
            if (stax.getAxis() != 5) {
                return null;
            }
            ContextItemExpression cie = new ContextItemExpression();
            ExpressionTool.copyLocationInfo(this, cie);
            st = ExpressionTool.makePathExpression(cie, stax, false);
            ExpressionTool.copyLocationInfo(this, st);
        }
        if (!(st instanceof SlashExpression)) {
            return null;
        }
        SlashExpression startPath = (SlashExpression)st;
        if (!(startPath.step instanceof AxisExpression)) {
            return null;
        }
        AxisExpression mid = (AxisExpression)startPath.step;
        if (mid.getAxis() != 5) {
            return null;
        }
        NodeTest test = mid.getNodeTest();
        if (test != null && !(test instanceof AnyNodeTest)) {
            return null;
        }
        Expression underlyingStep = this.step;
        while (underlyingStep instanceof FilterExpression) {
            if (((FilterExpression)underlyingStep).isPositional(env.getConfiguration().getTypeHierarchy())) {
                return null;
            }
            underlyingStep = ((FilterExpression)underlyingStep).getControllingExpression();
        }
        if (!(underlyingStep instanceof AxisExpression)) {
            return null;
        }
        byte underlyingAxis = ((AxisExpression)underlyingStep).getAxis();
        if (underlyingAxis == 3 || underlyingAxis == 4 || underlyingAxis == 5) {
            byte newAxis = underlyingAxis == 5 ? (byte)5 : 4;
            Expression newStep = new AxisExpression(newAxis, ((AxisExpression)underlyingStep).getNodeTest());
            ExpressionTool.copyLocationInfo(this, newStep);
            underlyingStep = this.step;
            Stack<Expression> filters = new Stack<Expression>();
            while (underlyingStep instanceof FilterExpression) {
                filters.add(((FilterExpression)underlyingStep).getFilter());
                underlyingStep = ((FilterExpression)underlyingStep).getControllingExpression();
            }
            while (!filters.isEmpty()) {
                newStep = new FilterExpression(newStep, (Expression)filters.pop());
                ExpressionTool.copyLocationInfo(this.step, newStep);
            }
            Expression newPath = ExpressionTool.makePathExpression(startPath.start, newStep, false);
            if (!(newPath instanceof SlashExpression)) {
                return null;
            }
            ExpressionTool.copyLocationInfo(this, newPath);
            return (SlashExpression)newPath;
        }
        if (underlyingAxis == 2) {
            AxisExpression newStep = new AxisExpression(5, NodeKindTest.ELEMENT);
            ExpressionTool.copyLocationInfo(this, newStep);
            Expression e2 = ExpressionTool.makePathExpression(startPath.start, newStep, false);
            Expression e3 = ExpressionTool.makePathExpression(e2, this.step, false);
            if (!(e3 instanceof SlashExpression)) {
                return null;
            }
            ExpressionTool.copyLocationInfo(this, e3);
            return (SlashExpression)e3;
        }
        return null;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression rawStep;
        Expression k;
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        Optimizer opt = visitor.getConfiguration().obtainOptimizer();
        this.setStartExpression(visitor.optimize(this.start, contextItemType));
        this.setStepExpression(this.step.optimize(visitor, new ExpressionVisitor.ContextItemType(this.start.getItemType(th), false)));
        if (Literal.isEmptySequence(this.start) || Literal.isEmptySequence(this.step)) {
            return Literal.makeEmptySequence();
        }
        if (this.start instanceof RootExpression && th.isSubType(contextItemType.itemType, NodeKindTest.DOCUMENT)) {
            return this.step;
        }
        Expression lastStep = this.getLastStep();
        if (lastStep instanceof FilterExpression && !((FilterExpression)lastStep).isPositional(th)) {
            Expression leading = this.getLeadingSteps();
            Expression p2 = ExpressionTool.makePathExpression(leading, ((FilterExpression)lastStep).getControllingExpression(), false);
            FilterExpression f2 = new FilterExpression(p2, ((FilterExpression)lastStep).getFilter());
            return ((Expression)f2).optimize(visitor, contextItemType);
        }
        if (!visitor.isOptimizeForStreaming() && (k = opt.convertPathExpressionToKey(this, visitor)) != null) {
            return k.typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
        }
        if (this.start instanceof AxisExpression && ((AxisExpression)this.start).getAxis() == 4 && this.step instanceof AxisExpression && ((AxisExpression)this.step).getAxis() == 3) {
            k = new FilterExpression(new AxisExpression(4, ((AxisExpression)this.step).getNodeTest()), new AxisExpression(9, ((AxisExpression)this.start).getNodeTest()));
            if (!th.isSubType(contextItemType.itemType, NodeKindTest.DOCUMENT)) {
                k = new SlashExpression(new AxisExpression(3, NodeKindTest.ELEMENT), k);
            }
            opt.trace("Rewrote descendant::X/child::Y as descendant::Y[parent::X]", k);
            return k;
        }
        if (this.step instanceof AxisExpression && !Cardinality.allowsMany(this.start.getCardinality())) {
            SimpleStepExpression sse = new SimpleStepExpression(this.start, this.step);
            ExpressionTool.copyLocationInfo(this, sse);
            return sse;
        }
        k = this.promoteFocusIndependentSubexpressions(visitor, contextItemType);
        if (k != this) {
            return k;
        }
        if (visitor.isOptimizeForStreaming() && (rawStep = ExpressionTool.unfilteredExpression(this.step)) instanceof CopyOf && ((CopyOf)rawStep).getSelectExpression() instanceof ContextItemExpression) {
            ((CopyOf)rawStep).setSelectExpression(this.start);
            rawStep.resetLocalStaticProperties();
            this.step.resetLocalStaticProperties();
            return this.step;
        }
        return this;
    }

    public SlashExpression tryToMakeAbsolute(TypeHierarchy th) {
        SlashExpression se;
        SlashExpression se2;
        ItemType contextItemType;
        Expression first = this.getFirstStep();
        if (first.getItemType(th).getPrimitiveType() == 9) {
            return this;
        }
        if (first instanceof AxisExpression && (contextItemType = ((AxisExpression)first).getContextItemType()) != null && contextItemType.getPrimitiveType() == 9) {
            RootExpression root = new RootExpression();
            ExpressionTool.copyLocationInfo(this, root);
            Expression path = ExpressionTool.makePathExpression(root, this, false);
            ExpressionTool.copyLocationInfo(this, path);
            return (SlashExpression)path;
        }
        if (first instanceof DocumentSorter && ((DocumentSorter)first).getBaseExpression() instanceof SlashExpression && (se2 = (se = (SlashExpression)((DocumentSorter)first).getBaseExpression()).tryToMakeAbsolute(th)) != null) {
            if (se2 == se) {
                return this;
            }
            Expression rest = this.getRemainingSteps();
            DocumentSorter ds = new DocumentSorter(se2);
            return new SlashExpression(ds, rest);
        }
        return null;
    }

    protected Expression promoteFocusIndependentSubexpressions(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Optimizer opt = visitor.getConfiguration().obtainOptimizer();
        PromotionOffer offer = new PromotionOffer(opt);
        offer.action = 10;
        offer.promoteDocumentDependent = (this.start.getSpecialProperties() & 0x10000) != 0;
        offer.containingExpression = this;
        this.setStepExpression(this.doPromotion(this.step, offer));
        visitor.resetStaticProperties();
        if (offer.containingExpression != this) {
            offer.containingExpression = visitor.optimize(visitor.typeCheck(offer.containingExpression, contextItemType), contextItemType);
            return offer.containingExpression;
        }
        return this;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.setStartExpression(this.doPromotion(this.start, offer));
        if (offer.action == 12 || offer.action == 14) {
            this.setStepExpression(this.doPromotion(this.step, offer));
        }
        return this;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PairIterator<Expression>(this.start, this.step);
    }

    @Override
    public Iterator<SubExpressionInfo> iterateSubExpressionInfo() {
        SubExpressionInfo selectInfo = new SubExpressionInfo(this.start, true, false, 3);
        SubExpressionInfo actionInfo = new SubExpressionInfo(this.step, false, true, 2);
        return new PairIterator<SubExpressionInfo>(selectInfo, actionInfo);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.start == original) {
            this.setStartExpression(replacement);
            found = true;
        }
        if (this.step == original) {
            this.setStepExpression(replacement);
            found = true;
        }
        return found;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet target = this.start.addToPathMap(pathMap, pathMapNodeSet);
        return this.step.addToPathMap(pathMap, target);
    }

    @Override
    public int computeDependencies() {
        return this.start.getDependencies() | this.step.getDependencies() & 0x3E1;
    }

    @Override
    public Expression copy() {
        return ExpressionTool.makePathExpression(this.start.copy(), this.step.copy(), false);
    }

    @Override
    public int computeSpecialProperties() {
        int startProperties = this.start.getSpecialProperties();
        int stepProperties = this.step.getSpecialProperties();
        int p = 0;
        if (!Cardinality.allowsMany(this.start.getCardinality())) {
            startProperties |= 0x8A0000;
        }
        if (!Cardinality.allowsMany(this.step.getCardinality())) {
            stepProperties |= 0x8A0000;
        }
        if ((startProperties & stepProperties & 0x10000) != 0) {
            p |= 0x10000;
        }
        if ((startProperties & 0x800000) != 0 && (stepProperties & 0x10000) != 0) {
            p |= 0x800000;
        }
        if ((startProperties & stepProperties & 0x80000) != 0) {
            p |= 0x80000;
        }
        if ((startProperties & stepProperties & 0x100000) != 0) {
            p |= 0x100000;
        }
        if (this.testNaturallySorted(startProperties, stepProperties)) {
            p |= 0x20000;
        }
        if (this.testNaturallyReverseSorted()) {
            p |= 0x40000;
        }
        if ((startProperties & stepProperties & 0x400000) != 0) {
            p |= 0x400000;
        }
        return p;
    }

    private boolean testNaturallySorted(int startProperties, int stepProperties) {
        if ((stepProperties & 0x20000) == 0) {
            return false;
        }
        if (Cardinality.allowsMany(this.start.getCardinality())) {
            if ((startProperties & 0x20000) == 0) {
                return false;
            }
        } else {
            return true;
        }
        if ((stepProperties & 0x200000) != 0) {
            return true;
        }
        if ((stepProperties & 0x400000) == 0) {
            return true;
        }
        return (startProperties & 0x80000) != 0 && (stepProperties & 0x100000) != 0;
    }

    private boolean testNaturallyReverseSorted() {
        if (!Cardinality.allowsMany(this.start.getCardinality()) && this.step instanceof AxisExpression) {
            return !AxisInfo.isForwards[((AxisExpression)this.step).getAxis()];
        }
        return !Cardinality.allowsMany(this.step.getCardinality()) && this.start instanceof AxisExpression && !AxisInfo.isForwards[((AxisExpression)this.start).getAxis()];
    }

    @Override
    public int computeCardinality() {
        int c1 = this.start.getCardinality();
        int c2 = this.step.getCardinality();
        return Cardinality.multiply(c1, c2);
    }

    @Override
    public Pattern toPattern(Configuration config, boolean is30) throws XPathException {
        AxisExpression mid;
        SlashExpression start;
        ItemChecker checker;
        Expression head = this.getLeadingSteps();
        Expression tail = this.getLastStep();
        if (head instanceof ItemChecker && (checker = (ItemChecker)head).getBaseExpression() instanceof ContextItemExpression) {
            return tail.toPattern(config, is30);
        }
        Pattern tailPattern = tail.toPattern(config, is30);
        if (tailPattern instanceof ItemTypePattern && tailPattern.getItemType() instanceof ErrorType) {
            return tailPattern;
        }
        byte axis = 9;
        Pattern headPattern = null;
        if (head instanceof SlashExpression && (start = (SlashExpression)head).getControlledExpression() instanceof AxisExpression && (mid = (AxisExpression)start.getControlledExpression()).getAxis() == 5 && (mid.getNodeTest() == null || mid.getNodeTest() instanceof AnyNodeTest)) {
            axis = 0;
            headPattern = start.getControllingExpression().toPattern(config, is30);
        }
        if (headPattern == null) {
            axis = PatternMaker.getAxisForPathStep(tail);
            headPattern = head.toPattern(config, is30);
        }
        return new AncestorQualifiedPattern(tailPattern, headPattern, axis);
    }

    public boolean equals(Object other) {
        if (!(other instanceof SlashExpression)) {
            return false;
        }
        SlashExpression p = (SlashExpression)other;
        return this.start.equals(p.start) && this.step.equals(p.step);
    }

    public int hashCode() {
        return "SlashExpression".hashCode() + this.start.hashCode() + this.step.hashCode();
    }

    @Override
    public SequenceIterator<? extends Item> iterate(XPathContext context) throws XPathException {
        SequenceIterator<? extends Item> result = this.start.iterate(context);
        XPathContextMinor context2 = context.newMinorContext();
        context2.setCurrentIterator(result);
        return new ContextMappingIterator<Item>(this, context2);
    }

    @Override
    public SequenceIterator map(XPathContext context) throws XPathException {
        return this.step.iterate(context);
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("slash");
        if (this instanceof SimpleStepExpression) {
            destination.emitAttribute("simple-step", "true");
        }
        this.start.explain(destination);
        this.step.explain(destination);
        destination.endElement();
    }

    @Override
    public String toString() {
        return ExpressionTool.parenthesize(this.start) + "/" + ExpressionTool.parenthesize(this.step);
    }

    public Expression getFirstStep() {
        if (this.start instanceof SlashExpression) {
            return ((SlashExpression)this.start).getFirstStep();
        }
        return this.start;
    }

    public Expression getStep() {
        return this.step;
    }

    public Expression getRemainingSteps() {
        if (this.start instanceof SlashExpression) {
            SlashExpression rem = new SlashExpression(((SlashExpression)this.start).getRemainingSteps(), this.step);
            ExpressionTool.copyLocationInfo(this.start, rem);
            return rem;
        }
        return this.step;
    }

    public Expression getLastStep() {
        if (this.step instanceof SlashExpression) {
            return ((SlashExpression)this.step).getLastStep();
        }
        return this.step;
    }

    public Expression getLeadingSteps() {
        if (this.step instanceof SlashExpression) {
            SlashExpression rem = new SlashExpression(this.start, ((SlashExpression)this.step).getLeadingSteps());
            ExpressionTool.copyLocationInfo(this.start, rem);
            return rem;
        }
        return this.start;
    }

    public boolean isAbsolute(TypeHierarchy th) {
        Expression first = this.getFirstStep();
        return first.getItemType(th).getPrimitiveType() == 9;
    }
}

