/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptorMediator;
import org.apache.ivy.core.module.id.ModuleRevisionId;

public class OverrideDependencyDescriptorMediator
implements DependencyDescriptorMediator {
    private String version;
    private String branch;

    public OverrideDependencyDescriptorMediator(String branch, String version2) {
        this.branch = branch;
        this.version = version2;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBranch() {
        return this.branch;
    }

    public DependencyDescriptor mediate(DependencyDescriptor dd) {
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        if ((this.version == null || this.version.equals(mrid.getRevision())) && (this.branch == null || this.branch.equals(mrid.getBranch()))) {
            return dd;
        }
        String version2 = this.version == null ? mrid.getRevision() : this.version;
        String branch = this.branch == null ? mrid.getBranch() : this.branch;
        return dd.clone(ModuleRevisionId.newInstance(mrid.getOrganisation(), mrid.getName(), branch, version2, mrid.getQualifiedExtraAttributes()));
    }
}

