/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.LogOptions;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.repository.AbstractRepository;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.AbstractPatternsBasedResolver;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;

public class RepositoryResolver
extends AbstractPatternsBasedResolver {
    private Repository repository;
    private Boolean alwaysCheckExactRevision = null;

    public final Repository getRepository() {
        return this.repository;
    }

    public final void setRepository(Repository repository) {
        this.repository = repository;
    }

    public final void setName(String string) {
        super.setName(string);
        if (this.repository instanceof AbstractRepository) {
            ((AbstractRepository)this.repository).setName(string);
        }
    }

    protected final ResolvedResource findResourceUsingPattern(ModuleRevisionId moduleRevisionId, String string, Artifact artifact, ResourceMDParser resourceMDParser, Date date) {
        String string2 = this.getName();
        VersionMatcher versionMatcher = this.getSettings().getVersionMatcher();
        try {
            block14: {
                block13: {
                    if (!versionMatcher.isDynamic(moduleRevisionId)) break block13;
                    RepositoryResolver repositoryResolver = this;
                    if (!(repositoryResolver.alwaysCheckExactRevision == null ? true : repositoryResolver.alwaysCheckExactRevision)) break block14;
                }
                String string3 = IvyPatternHelper.substitute(string, moduleRevisionId, artifact);
                Message.debug("\t trying " + string3);
                this.logAttempt(string3);
                Resource resource = this.repository.getResource(string3);
                if (resource.exists()) {
                    String string4;
                    if (string.indexOf("revision") == -1) {
                        if ("ivy".equals(artifact.getType()) || "pom".equals(artifact.getType())) {
                            File file2 = File.createTempFile("ivy", artifact.getExt());
                            file2.deleteOnExit();
                            this.repository.get(resource.getName(), file2);
                            string4 = ModuleDescriptorParserRegistry.getInstance().getParser(resource).parseDescriptor(this.getParserSettings(), file2.toURI().toURL(), resource, false).getRevision();
                            if (string4 == null || string4.length() == 0) {
                                string4 = "working@" + string2;
                            }
                        } else {
                            string4 = "working@" + string2;
                        }
                    } else {
                        string4 = moduleRevisionId.getRevision();
                    }
                    return new ResolvedResource(resource, string4);
                }
                if (versionMatcher.isDynamic(moduleRevisionId)) {
                    return this.findDynamicResourceUsingPattern(resourceMDParser, moduleRevisionId, string, artifact, date);
                }
                Message.debug("\t" + string2 + ": resource not reachable for " + moduleRevisionId + ": res=" + resource);
                return null;
            }
            return this.findDynamicResourceUsingPattern(resourceMDParser, moduleRevisionId, string, artifact, date);
        }
        catch (IOException iOException) {
            throw new RuntimeException(string2 + ": unable to get resource for " + moduleRevisionId + ": res=" + IvyPatternHelper.substitute(string, moduleRevisionId, artifact) + ": " + iOException, iOException);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(string2 + ": unable to get resource for " + moduleRevisionId + ": res=" + IvyPatternHelper.substitute(string, moduleRevisionId, artifact) + ": " + parseException, parseException);
        }
    }

    private ResolvedResource findDynamicResourceUsingPattern(ResourceMDParser resourceMDParser, ModuleRevisionId moduleRevisionId, String string, Artifact artifact, Date date) {
        String string2 = this.getName();
        this.logAttempt(IvyPatternHelper.substitute(string, ModuleRevisionId.newInstance(moduleRevisionId, IvyPatternHelper.getTokenString("revision")), artifact));
        ResolvedResource[] resolvedResourceArray = this.listResources(this.repository, moduleRevisionId, string, artifact);
        if (resolvedResourceArray == null) {
            Message.debug("\t" + string2 + ": unable to list resources for " + moduleRevisionId + ": pattern=" + string);
            return null;
        }
        ResolvedResource resolvedResource = this.findResource(resolvedResourceArray, resourceMDParser, moduleRevisionId, date);
        if (resolvedResource == null) {
            Message.debug("\t" + string2 + ": no resource found for " + moduleRevisionId + ": pattern=" + string);
        }
        return resolvedResource;
    }

    protected ResolvedResource[] listResources(Repository repository, ModuleRevisionId moduleRevisionId, String string, Artifact artifact) {
        return LogOptions.findAll(repository, moduleRevisionId, string, artifact);
    }

    protected final long get(Resource resource, File file2) {
        Message.verbose("\t" + this.getName() + ": downloading " + resource.getName());
        Message.debug("\t\tto " + file2);
        if (file2.getParentFile() != null) {
            file2.getParentFile().mkdirs();
        }
        this.repository.get(resource.getName(), file2);
        return file2.length();
    }

    public DownloadReport download(Artifact[] artifactArray, DownloadOptions downloadOptions) {
        EventManager eventManager = this.getEventManager();
        try {
            if (eventManager != null) {
                this.repository.addTransferListener(eventManager);
            }
            DownloadReport downloadReport = super.download(artifactArray, downloadOptions);
            return downloadReport;
        }
        finally {
            if (eventManager != null) {
                this.repository.removeTransferListener(eventManager);
            }
        }
    }

    public String getTypeName() {
        return "repository";
    }

    public void dumpSettings() {
        super.dumpSettings();
        Message.debug("\t\trepository: " + this.repository);
    }

    public final void setSettings(ResolverSettings resolverSettings) {
        super.setSettings(resolverSettings);
        if (resolverSettings != null && this.alwaysCheckExactRevision == null) {
            this.alwaysCheckExactRevision = Boolean.valueOf(resolverSettings.getVariable("ivy.default.always.check.exact.revision"));
        }
    }
}

