/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionMaster;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class IdFunction
extends BaseFunction {
    IdFunctionMaster master;
    private int methodId;
    private boolean useCallAsConstructor;

    public IdFunction(IdFunctionMaster master, String name, int id) {
        this.functionName = name;
        this.master = master;
        this.methodId = id;
    }

    public static void define(Scriptable scope, String name, IdFunctionMaster master, int id) {
        IdFunction.define(scope, name, master, id, 2, false);
    }

    public static void define(Scriptable scope, String name, IdFunctionMaster master, int id, int attributes) {
        IdFunction.define(scope, name, master, id, attributes, false);
    }

    public static void define(Scriptable scope, String name, IdFunctionMaster master, int id, int attributes, boolean sealed) {
        IdFunction f = new IdFunction(master, name, id);
        f.setParentScope(scope);
        if (sealed) {
            f.sealObject();
        }
        ScriptableObject.defineProperty(scope, name, f, attributes);
    }

    public final int getMethodId() {
        return this.methodId;
    }

    public Scriptable getPrototype() {
        Scriptable proto = super.getPrototype();
        if (proto == null) {
            proto = ScriptableObject.getFunctionPrototype(this.getParentScope());
            this.setPrototype(proto);
        }
        return proto;
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        return this.master.execMethod(this.methodId, this, cx, scope, thisObj, args);
    }

    public Scriptable createObject(Context cx, Scriptable scope) {
        if (this.useCallAsConstructor) {
            return null;
        }
        throw ScriptRuntime.typeError1("msg.not.ctor", this.functionName);
    }

    String decompile(int indent, int flags) {
        boolean justbody;
        StringBuffer sb = new StringBuffer();
        boolean bl = justbody = 0 != (flags & 1);
        if (!justbody) {
            sb.append("function ");
            sb.append(this.getFunctionName());
            sb.append("() { ");
        }
        sb.append("[native code for ");
        if (this.master instanceof Scriptable) {
            Scriptable smaster = (Scriptable)((Object)this.master);
            sb.append(smaster.getClassName());
            sb.append('.');
        }
        sb.append(this.getFunctionName());
        sb.append(", arity=");
        sb.append(this.getArity());
        sb.append(justbody ? "]\n" : "] }\n");
        return sb.toString();
    }

    public int getArity() {
        int arity = this.master.methodArity(this.methodId);
        if (arity < 0) {
            throw IdFunction.onBadMethodId(this.master, this.methodId);
        }
        return arity;
    }

    public int getLength() {
        return this.getArity();
    }

    public void initAsConstructor(Scriptable scope, Scriptable prototype) {
        this.useCallAsConstructor = true;
        this.setParentScope(scope);
        this.setImmunePrototypeProperty(prototype);
    }

    static RuntimeException onBadMethodId(IdFunctionMaster master, int id) {
        return new RuntimeException("BAD FUNCTION ID=" + id + " MASTER=" + master);
    }
}

