/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

final class NativeCallPrototype
extends IdScriptable {
    private static final int Id_constructor = 1;
    private static final int MAX_PROTOTYPE_ID = 1;

    NativeCallPrototype(Context cx, Scriptable scope, boolean sealed) {
        this.addAsPrototype(1, cx, scope, sealed);
    }

    public String getClassName() {
        return "Call";
    }

    public int methodArity(int methodId) {
        if (methodId == 1) {
            return 1;
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (methodId == 1) {
            if (thisObj != null) {
                throw Context.reportRuntimeError1("msg.only.from.new", "Call");
            }
            ScriptRuntime.checkDeprecated(cx, "Call");
            NativeCall result = new NativeCall();
            result.setPrototype(ScriptableObject.getObjectPrototype(scope));
            return result;
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    protected String getIdName(int id) {
        if (id == 1) {
            return "constructor";
        }
        return null;
    }

    protected int mapNameToId(String s) {
        return s.equals("constructor") ? 1 : 0;
    }
}

