/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.filter.PortletRequestWrapper;
import javax.portlet.filter.PortletResponseWrapper;
import javax.servlet.http.Cookie;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortletUtils {
    public static File getTempDir(PortletContext portletContext) {
        Assert.notNull((Object)portletContext, (String)"PortletContext must not be null");
        return (File)portletContext.getAttribute("javax.servlet.context.tempdir");
    }

    public static String getRealPath(PortletContext portletContext, String path) throws FileNotFoundException {
        String realPath;
        Assert.notNull((Object)portletContext, (String)"PortletContext must not be null");
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((realPath = portletContext.getRealPath(path)) == null) {
            throw new FileNotFoundException("PortletContext resource [" + path + "] cannot be resolved to absolute file path - " + "web application archive not expanded?");
        }
        return realPath;
    }

    public static Object getSessionAttribute(PortletRequest request, String name) {
        return PortletUtils.getSessionAttribute(request, name, 2);
    }

    public static Object getSessionAttribute(PortletRequest request, String name, int scope) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        PortletSession session = request.getPortletSession(false);
        return session != null ? session.getAttribute(name, scope) : null;
    }

    public static Object getRequiredSessionAttribute(PortletRequest request, String name) throws IllegalStateException {
        return PortletUtils.getRequiredSessionAttribute(request, name, 2);
    }

    public static Object getRequiredSessionAttribute(PortletRequest request, String name, int scope) throws IllegalStateException {
        Object attr = PortletUtils.getSessionAttribute(request, name, scope);
        if (attr == null) {
            throw new IllegalStateException("No session attribute '" + name + "' found");
        }
        return attr;
    }

    public static void setSessionAttribute(PortletRequest request, String name, Object value) {
        PortletUtils.setSessionAttribute(request, name, value, 2);
    }

    public static void setSessionAttribute(PortletRequest request, String name, Object value, int scope) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        if (value != null) {
            request.getPortletSession().setAttribute(name, value, scope);
        } else {
            PortletSession session = request.getPortletSession(false);
            if (session != null) {
                session.removeAttribute(name, scope);
            }
        }
    }

    public static Object getOrCreateSessionAttribute(PortletSession session, String name, Class clazz) throws IllegalArgumentException {
        return PortletUtils.getOrCreateSessionAttribute(session, name, clazz, 2);
    }

    public static Object getOrCreateSessionAttribute(PortletSession session, String name, Class clazz, int scope) throws IllegalArgumentException {
        Assert.notNull((Object)session, (String)"Session must not be null");
        Object sessionObject = session.getAttribute(name, scope);
        if (sessionObject == null) {
            Assert.notNull((Object)clazz, (String)"Class must not be null if attribute value is to be instantiated");
            try {
                sessionObject = clazz.newInstance();
            }
            catch (InstantiationException ex) {
                throw new IllegalArgumentException("Could not instantiate class [" + clazz.getName() + "] for session attribute '" + name + "': " + ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException("Could not access default constructor of class [" + clazz.getName() + "] for session attribute '" + name + "': " + ex.getMessage());
            }
            session.setAttribute(name, sessionObject, scope);
        }
        return sessionObject;
    }

    public static Object getSessionMutex(PortletSession session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        Object mutex = session.getAttribute(WebUtils.SESSION_MUTEX_ATTRIBUTE, 1);
        if (mutex == null) {
            mutex = session;
        }
        return mutex;
    }

    public static <T> T getNativeRequest(PortletRequest request, Class<T> requiredType) {
        if (requiredType != null) {
            if (requiredType.isInstance(request)) {
                return (T)request;
            }
            if (request instanceof PortletRequestWrapper) {
                return PortletUtils.getNativeRequest(((PortletRequestWrapper)request).getRequest(), requiredType);
            }
        }
        return null;
    }

    public static <T> T getNativeResponse(PortletResponse response, Class<T> requiredType) {
        if (requiredType != null) {
            if (requiredType.isInstance(response)) {
                return (T)response;
            }
            if (response instanceof PortletResponseWrapper) {
                return PortletUtils.getNativeResponse(((PortletResponseWrapper)response).getResponse(), requiredType);
            }
        }
        return null;
    }

    public static void exposeRequestAttributes(PortletRequest request, Map<String, ?> attributes) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        Assert.notNull(attributes, (String)"Attributes Map must not be null");
        for (Map.Entry<String, ?> entry : attributes.entrySet()) {
            request.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public static Cookie getCookie(PortletRequest request, String name) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (name.equals(cookie.getName())) {
                    return cookie;
                }
                ++n2;
            }
        }
        return null;
    }

    public static boolean hasSubmitParameter(PortletRequest request, String name) {
        return PortletUtils.getSubmitParameter(request, name) != null;
    }

    public static String getSubmitParameter(PortletRequest request, String name) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        if (request.getParameter(name) != null) {
            return name;
        }
        int i = 0;
        while (i < WebUtils.SUBMIT_IMAGE_SUFFIXES.length) {
            String suffix = WebUtils.SUBMIT_IMAGE_SUFFIXES[i];
            String parameter = String.valueOf(name) + suffix;
            if (request.getParameter(parameter) != null) {
                return parameter;
            }
            ++i;
        }
        return null;
    }

    public static Map<String, Object> getParametersStartingWith(PortletRequest request, String prefix) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        Enumeration paramNames = request.getParameterNames();
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        if (prefix == null) {
            prefix = "";
        }
        while (paramNames != null && paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (!"".equals(prefix) && !paramName.startsWith(prefix)) continue;
            String unprefixed = paramName.substring(prefix.length());
            String[] values = request.getParameterValues(paramName);
            if (values == null || values.length == 0) continue;
            if (values.length > 1) {
                params.put(unprefixed, values);
                continue;
            }
            params.put(unprefixed, values[0]);
        }
        return params;
    }

    public static int getTargetPage(PortletRequest request, String paramPrefix, int currentPage) {
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (!paramName.startsWith(paramPrefix)) continue;
            int i = 0;
            while (i < WebUtils.SUBMIT_IMAGE_SUFFIXES.length) {
                String suffix = WebUtils.SUBMIT_IMAGE_SUFFIXES[i];
                if (paramName.endsWith(suffix)) {
                    paramName = paramName.substring(0, paramName.length() - suffix.length());
                }
                ++i;
            }
            return Integer.parseInt(paramName.substring(paramPrefix.length()));
        }
        return currentPage;
    }

    public static void passAllParametersToRenderPhase(ActionRequest request, ActionResponse response) {
        try {
            Enumeration en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String param = (String)en.nextElement();
                String[] values = request.getParameterValues(param);
                response.setRenderParameter(param, values);
            }
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public static void clearAllRenderParameters(ActionResponse response) {
        try {
            response.setRenderParameters(new HashMap(0));
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public static void serveResource(ResourceRequest request, ResourceResponse response, PortletContext context) throws PortletException, IOException {
        String id = request.getResourceID();
        if (id != null) {
            PortletRequestDispatcher rd;
            if (!PortletUtils.isProtectedResource(id) && (rd = context.getRequestDispatcher(id)) != null) {
                rd.forward((PortletRequest)request, (PortletResponse)response);
                return;
            }
            response.setProperty("portlet.http-status-code", "404");
        }
    }

    private static boolean isProtectedResource(String path) {
        return StringUtils.startsWithIgnoreCase((String)path, (String)"/WEB-INF") || StringUtils.startsWithIgnoreCase((String)path, (String)"/META-INF");
    }
}

