/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.model.cloudfront;

import java.util.Arrays;
import java.util.Date;
import org.jets3t.service.model.cloudfront.DistributionConfig;

public class Distribution {
    private static final String DEFAULT_ORIGIN_SUFFIX = ".s3.amazonaws.com";
    private String id = null;
    private String status = null;
    private Date lastModifiedTime = null;
    private String domainName = null;
    private String origin = null;
    private String[] cnames = new String[0];
    private String comment = null;
    private boolean enabled = false;
    private DistributionConfig config = null;

    public Distribution(String id, String status, Date lastModifiedDate, String domainName, String origin, String[] cnames, String comment, boolean enabled) {
        this.id = id;
        this.status = status;
        this.lastModifiedTime = lastModifiedDate;
        this.domainName = domainName;
        this.origin = origin;
        this.cnames = cnames;
        this.comment = comment;
        this.enabled = enabled;
    }

    public Distribution(String id, String status, Date lastModifiedDate, String domainName, DistributionConfig config) {
        this.id = id;
        this.status = status;
        this.lastModifiedTime = lastModifiedDate;
        this.domainName = domainName;
        this.config = config;
    }

    public boolean isSummary() {
        return this.getConfig() == null;
    }

    public String getComment() {
        return this.comment;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getId() {
        return this.id;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getOriginAsBucketName() {
        if (this.origin.endsWith(DEFAULT_ORIGIN_SUFFIX)) {
            return this.origin.substring(0, this.origin.length() - DEFAULT_ORIGIN_SUFFIX.length());
        }
        return this.origin;
    }

    public String[] getCNAMEs() {
        return this.cnames;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isDeployed() {
        return "Deployed".equals(this.getStatus());
    }

    public DistributionConfig getConfig() {
        return this.config;
    }

    public String toString() {
        return "CloudFrontDistribution: id=" + this.id + ", status=" + this.status + ", domainName=" + this.domainName + ", lastModifiedTime=" + this.lastModifiedTime + (this.isSummary() ? ", origin=" + this.origin + ", comment=" + this.comment + ", enabled=" + this.enabled + ", CNAMEs=" + Arrays.asList(this.cnames) : ", config=[" + this.config + "]");
    }
}

