/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import net.spy.memcached.ops.FlushOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.ascii.OperationImpl;

final class FlushOperationImpl
extends OperationImpl
implements FlushOperation {
    private static final byte[] FLUSH = "flush_all\r\n".getBytes();
    private static final OperationStatus OK = new OperationStatus(true, "OK");
    private final int delay;

    public FlushOperationImpl(int d, OperationCallback cb) {
        super(cb);
        this.delay = d;
    }

    @Override
    public void handleLine(String line) {
        this.getLogger().debug("Flush completed successfully");
        this.getCallback().receivedStatus(this.matchStatus(line, OK));
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        ByteBuffer b = null;
        if (this.delay == -1) {
            b = ByteBuffer.wrap(FLUSH);
        } else {
            b = ByteBuffer.allocate(32);
            b.put(("flush_all " + this.delay + "\r\n").getBytes());
            b.flip();
        }
        this.setBuffer(b);
    }

    public String toString() {
        return "Cmd: flush_all Delay: " + this.delay;
    }
}

