/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.util;

import de.jollyday.HolidayType;
import de.jollyday.config.Configuration;
import de.jollyday.config.Month;
import de.jollyday.config.ObjectFactory;
import de.jollyday.config.Weekday;
import de.jollyday.util.ClassLoadingUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class XMLUtil {
    public static final String PACKAGE = "de.jollyday.config";
    private static Logger LOG = Logger.getLogger(XMLUtil.class.getName());
    private JAXBContextCreator contextCreator = new JAXBContextCreator();
    private ClassLoadingUtil classLoadingUtil = new ClassLoadingUtil();

    public Configuration unmarshallConfiguration(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Stream is NULL. Cannot read XML.");
        }
        try {
            JAXBContext ctx = null;
            try {
                ctx = this.contextCreator.create(PACKAGE, this.classLoadingUtil.getClassloader());
            }
            catch (JAXBException e) {
                LOG.warning("Could not create JAXB context using the current threads context classloader. Defaulting to ObjectFactory classloader.");
                ctx = null;
            }
            if (ctx == null) {
                ctx = this.contextCreator.create(PACKAGE, ObjectFactory.class.getClassLoader());
            }
            Unmarshaller um = ctx.createUnmarshaller();
            JAXBElement el = (JAXBElement)um.unmarshal(stream);
            Configuration configuration = (Configuration)el.getValue();
            return configuration;
        }
        catch (JAXBException ue) {
            throw new IllegalStateException("Cannot parse holidays XML file.", ue);
        }
        finally {
            stream.close();
        }
    }

    public final int getWeekday(Weekday weekday) {
        switch (weekday) {
            case MONDAY: {
                return 1;
            }
            case TUESDAY: {
                return 2;
            }
            case WEDNESDAY: {
                return 3;
            }
            case THURSDAY: {
                return 4;
            }
            case FRIDAY: {
                return 5;
            }
            case SATURDAY: {
                return 6;
            }
            case SUNDAY: {
                return 7;
            }
        }
        throw new IllegalArgumentException("Unknown weekday " + (Object)((Object)weekday));
    }

    public int getMonth(Month month) {
        switch (month) {
            case JANUARY: {
                return 1;
            }
            case FEBRUARY: {
                return 2;
            }
            case MARCH: {
                return 3;
            }
            case APRIL: {
                return 4;
            }
            case MAY: {
                return 5;
            }
            case JUNE: {
                return 6;
            }
            case JULY: {
                return 7;
            }
            case AUGUST: {
                return 8;
            }
            case SEPTEMBER: {
                return 9;
            }
            case OCTOBER: {
                return 10;
            }
            case NOVEMBER: {
                return 11;
            }
            case DECEMBER: {
                return 12;
            }
        }
        throw new IllegalArgumentException("Unknown month " + (Object)((Object)month));
    }

    public HolidayType getType(de.jollyday.config.HolidayType type) {
        switch (type) {
            case OFFICIAL_HOLIDAY: {
                return HolidayType.OFFICIAL_HOLIDAY;
            }
            case UNOFFICIAL_HOLIDAY: {
                return HolidayType.UNOFFICIAL_HOLIDAY;
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)type));
    }

    public class JAXBContextCreator {
        public JAXBContext create(String packageName, ClassLoader classLoader) throws JAXBException {
            return JAXBContext.newInstance((String)packageName, (ClassLoader)classLoader);
        }
    }
}

