/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.generator;

import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.Items;
import com.pholser.junit.quickcheck.internal.ParameterContext;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.Zilch;
import com.pholser.junit.quickcheck.internal.generator.ArrayGenerator;
import com.pholser.junit.quickcheck.internal.generator.CompositeGenerator;
import com.pholser.junit.quickcheck.internal.generator.EnumGenerator;
import com.pholser.junit.quickcheck.internal.generator.LambdaGenerator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javaruntype.type.ExtendsTypeParameter;
import org.javaruntype.type.StandardTypeParameter;
import org.javaruntype.type.TypeParameter;
import org.javaruntype.type.Types;
import org.javaruntype.type.WildcardTypeParameter;

public class GeneratorRepository {
    private final SourceOfRandomness random;
    private final Map<Class<?>, Set<Generator<?>>> generators = new HashMap();

    public GeneratorRepository(SourceOfRandomness random) {
        this.random = random;
    }

    public GeneratorRepository register(Generator<?> source) {
        this.registerTypes(source);
        return this;
    }

    public GeneratorRepository register(Iterable<Generator<?>> source) {
        for (Generator<?> each : source) {
            this.registerTypes(each);
        }
        return this;
    }

    private void registerTypes(Generator<?> generator) {
        for (Class<?> each : generator.types()) {
            this.registerHierarchy(each, generator);
        }
    }

    private void registerHierarchy(Class<?> type, Generator<?> generator) {
        this.maybeRegisterGeneratorForType(type, generator);
        if (type.getSuperclass() != null) {
            this.registerHierarchy(type.getSuperclass(), generator);
        } else if (type.isInterface()) {
            this.registerHierarchy(Object.class, generator);
        }
        for (Class<?> each : type.getInterfaces()) {
            this.registerHierarchy(each, generator);
        }
    }

    private void maybeRegisterGeneratorForType(Class<?> type, Generator<?> generator) {
        if (generator.canRegisterAsType(type)) {
            this.registerGeneratorForType(type, generator);
        }
    }

    private void registerGeneratorForType(Class<?> type, Generator<?> generator) {
        Set<Generator<?>> forType = this.generators.get(type);
        if (forType == null) {
            forType = new LinkedHashSet();
            this.generators.put(type, forType);
        }
        forType.add(generator);
    }

    public Generator<?> generatorFor(ParameterContext parameter) {
        Generator<?> generator = !parameter.explicitGenerators().isEmpty() ? this.composite(Types.forJavaLangReflectType((Type)parameter.parameterType()), parameter.explicitGenerators()) : this.generatorFor(parameter.parameterType());
        generator.configure(parameter.configurations());
        generator.provideRepository(this);
        return generator;
    }

    public Generator<?> generatorFor(Type type) {
        return this.generatorForTypeToken(Types.forJavaLangReflectType((Type)type), true);
    }

    private Generator<?> generatorForTypeToken(org.javaruntype.type.Type<?> typeToken, boolean allowMixedTypes) {
        if (typeToken.isArray()) {
            return this.generatorForArrayType(typeToken);
        }
        if (typeToken.getRawClass().isEnum()) {
            return new EnumGenerator((Class<?>)typeToken.getRawClass());
        }
        List<Generator<?>> matches = this.findMatchingGenerators(typeToken, allowMixedTypes);
        return this.composite(typeToken, matches);
    }

    private Generator<?> generatorForArrayType(org.javaruntype.type.Type<?> typeToken) {
        org.javaruntype.type.Type<?> arrayTypeToken = typeToken;
        org.javaruntype.type.Type component = Types.arrayComponentOf(arrayTypeToken);
        return new ArrayGenerator(component.getRawClass(), this.generatorForTypeToken(component, true));
    }

    private List<Generator<?>> findMatchingGenerators(org.javaruntype.type.Type<?> typeToken, boolean allowMixedTypes) {
        ArrayList matches = new ArrayList();
        if (!this.hasGeneratorsForRawClass(typeToken.getRawClass())) {
            this.maybeAddLambdaGenerator(typeToken, matches);
        } else {
            this.maybeAddGeneratorsForRawClass(typeToken, allowMixedTypes, matches);
        }
        if (matches.isEmpty()) {
            throw new IllegalArgumentException("Cannot find generator for " + typeToken.getRawClass());
        }
        return matches;
    }

    private void maybeAddLambdaGenerator(org.javaruntype.type.Type<?> typeToken, List<Generator<?>> matches) {
        Method method = Reflection.singleAbstractMethodOf(typeToken.getRawClass());
        if (method != null) {
            LambdaGenerator lambda = new LambdaGenerator(typeToken.getRawClass(), this.generatorFor(method.getGenericReturnType()));
            matches.add(lambda);
        }
    }

    private void maybeAddGeneratorsForRawClass(org.javaruntype.type.Type<?> typeToken, boolean allowMixedTypes, List<Generator<?>> matches) {
        List<Generator<?>> candidates = this.generatorsForRawClass(typeToken.getRawClass(), allowMixedTypes);
        List typeParameters = typeToken.getTypeParameters();
        if (typeParameters.isEmpty()) {
            matches.addAll(candidates);
        } else {
            for (Generator<?> each : candidates) {
                if (!each.canGenerateForParametersOfTypes(typeParameters)) continue;
                matches.add(each);
            }
        }
    }

    private Generator<?> composite(org.javaruntype.type.Type<?> typeToken, List<Generator<?>> matches) {
        ArrayList forComponents = new ArrayList();
        for (TypeParameter typeParameter : typeToken.getTypeParameters()) {
            forComponents.add(this.generatorForTypeParameter(typeParameter));
        }
        for (Generator generator : matches) {
            this.applyComponentGenerators(generator, forComponents);
        }
        return new CompositeGenerator(matches);
    }

    private void applyComponentGenerators(Generator<?> generator, List<Generator<?>> componentGenerators) {
        if (generator.hasComponents()) {
            if (componentGenerators.isEmpty()) {
                ArrayList substitutes = new ArrayList();
                Generator<?> zilch = this.generatorFor((Type)((Object)Zilch.class));
                for (int i = 0; i < generator.numberOfNeededComponents(); ++i) {
                    substitutes.add(zilch);
                }
                generator.addComponentGenerators(substitutes);
            } else {
                generator.addComponentGenerators(componentGenerators);
            }
        }
    }

    private Generator<?> generatorForTypeParameter(TypeParameter<?> parameter) {
        if (parameter instanceof StandardTypeParameter) {
            return this.generatorForTypeToken(parameter.getType(), true);
        }
        if (parameter instanceof WildcardTypeParameter) {
            return this.generatorFor((Type)((Object)Zilch.class));
        }
        if (parameter instanceof ExtendsTypeParameter) {
            return this.generatorForTypeToken(parameter.getType(), false);
        }
        Set<org.javaruntype.type.Type<?>> supertypes = Reflection.supertypes(parameter.getType());
        org.javaruntype.type.Type<?> chosen = Items.choose(supertypes, this.random);
        return this.generatorForTypeToken(chosen, false);
    }

    private List<Generator<?>> generatorsForRawClass(Class<?> clazz, boolean allowMixedTypes) {
        Set<Generator<?>> matches = this.generators.get(clazz);
        if (!allowMixedTypes) {
            Generator<?> match = Items.choose(matches, this.random);
            matches = new HashSet();
            matches.add(match);
        }
        ArrayList copies = new ArrayList();
        for (Generator<?> each : matches) {
            copies.add(each.hasComponents() ? GeneratorRepository.copyOf(each) : each);
        }
        return copies;
    }

    private boolean hasGeneratorsForRawClass(Class<?> clazz) {
        Set<Generator<?>> matches = this.generators.get(clazz);
        return matches != null;
    }

    private static Generator<?> copyOf(Generator<?> generator) {
        return (Generator)Reflection.instantiate(generator.getClass());
    }
}

