/*
 * Decompiled with CFR 0.152.
 */
package org.junit.contrib.theories.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.junit.contrib.theories.DataPoint;
import org.junit.contrib.theories.DataPoints;
import org.junit.contrib.theories.FromDataPoints;
import org.junit.contrib.theories.ParameterSignature;
import org.junit.contrib.theories.internal.AllMembersSupplier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecificDataPointsSupplier
extends AllMembersSupplier {
    public SpecificDataPointsSupplier(TestClass testClass) {
        super(testClass);
    }

    @Override
    protected Collection<Field> getSingleDataPointFields(ParameterSignature sig) {
        String requestedName = sig.getAnnotation(FromDataPoints.class).value();
        ArrayList<Field> fieldsWithMatchingNames = new ArrayList<Field>();
        for (Field each : super.getSingleDataPointFields(sig)) {
            String[] fieldNames = each.getAnnotation(DataPoint.class).value();
            if (!Arrays.asList(fieldNames).contains(requestedName)) continue;
            fieldsWithMatchingNames.add(each);
        }
        return fieldsWithMatchingNames;
    }

    @Override
    protected Collection<Field> getDataPointsFields(ParameterSignature sig) {
        String requestedName = sig.getAnnotation(FromDataPoints.class).value();
        ArrayList<Field> fieldsWithMatchingNames = new ArrayList<Field>();
        for (Field each : super.getDataPointsFields(sig)) {
            String[] fieldNames = each.getAnnotation(DataPoints.class).value();
            if (!Arrays.asList(fieldNames).contains(requestedName)) continue;
            fieldsWithMatchingNames.add(each);
        }
        return fieldsWithMatchingNames;
    }

    @Override
    protected Collection<FrameworkMethod> getSingleDataPointMethods(ParameterSignature sig) {
        String requestedName = sig.getAnnotation(FromDataPoints.class).value();
        ArrayList<FrameworkMethod> methodsWithMatchingNames = new ArrayList<FrameworkMethod>();
        for (FrameworkMethod each : super.getSingleDataPointMethods(sig)) {
            String[] methodNames = ((DataPoint)each.getAnnotation(DataPoint.class)).value();
            if (!Arrays.asList(methodNames).contains(requestedName)) continue;
            methodsWithMatchingNames.add(each);
        }
        return methodsWithMatchingNames;
    }

    @Override
    protected Collection<FrameworkMethod> getDataPointsMethods(ParameterSignature sig) {
        String requestedName = sig.getAnnotation(FromDataPoints.class).value();
        ArrayList<FrameworkMethod> methodsWithMatchingNames = new ArrayList<FrameworkMethod>();
        for (FrameworkMethod each : super.getDataPointsMethods(sig)) {
            String[] methodNames = ((DataPoints)each.getAnnotation(DataPoints.class)).value();
            if (!Arrays.asList(methodNames).contains(requestedName)) continue;
            methodsWithMatchingNames.add(each);
        }
        return methodsWithMatchingNames;
    }
}

