/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WrapperGenerator {
    private static final Logger log = Logger.getLogger("WrapperGenerator");
    boolean generateLog = true;
    boolean wide;
    private static Charset charset = Charset.forName("ISO-8859-15");
    String package_name = "sun.awt.X11";
    String package_path = "sun/awt/X11";
    String sizerFileName = "sizer.c";
    String defaultBaseClass = "XWrapperBase";
    String compile_options = "-lX11";
    static Hashtable symbolTable = new Hashtable();
    static Hashtable sizeTable32bit = new Hashtable();
    static Hashtable sizeTable64bit = new Hashtable();
    static Hashtable knownSizes32 = new Hashtable();
    static Hashtable knownSizes64 = new Hashtable();

    public String makeComment(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + "//" + stringTokenizer.nextToken() + "\n";
        }
        return string2;
    }

    public String getJavaTypeForSize(int n) {
        switch (n) {
            case 1: {
                return "byte";
            }
            case 2: {
                return "short";
            }
            case 4: {
                return "int";
            }
            case 8: {
                return "long";
            }
        }
        throw new RuntimeException("Unsupported size: " + n);
    }

    public String getOffsets(StructType structType, AtomicType atomicType, boolean bl) {
        String string = structType.getName() + "." + atomicType.getName();
        return bl ? (String)sizeTable64bit.get(string) : (String)sizeTable32bit.get(string);
    }

    public String getStructSize(StructType structType, boolean bl) {
        return bl ? (String)sizeTable64bit.get(structType.getName()) : (String)sizeTable32bit.get(structType.getName());
    }

    public int getLongSize(boolean bl) {
        return Integer.parseInt(bl ? (String)sizeTable64bit.get("long") : (String)sizeTable32bit.get("long"));
    }

    public int getPtrSize(boolean bl) {
        return Integer.parseInt(bl ? (String)sizeTable64bit.get("ptr") : (String)sizeTable32bit.get("ptr"));
    }

    public int getBoolSize(boolean bl) {
        return this.getOrdinalSize("Bool", bl);
    }

    public int getOrdinalSize(String string, boolean bl) {
        return Integer.parseInt(bl ? (String)sizeTable64bit.get(string) : (String)sizeTable32bit.get(string));
    }

    public void writeToString(StructType structType, PrintWriter printWriter) {
        printWriter.println("\n\n\tString getName() {\n\t\treturn \"" + structType.getName() + "\"; \n\t}");
        printWriter.println("\n\n\tString getFieldsAsString() {\n\t\tStringBuilder ret = new StringBuilder(" + structType.getNumFields() * 40 + ");\n");
        Enumeration enumeration = structType.getMembers();
        while (enumeration.hasMoreElements()) {
            AtomicType atomicType = (AtomicType)enumeration.nextElement();
            int n = atomicType.getType();
            String string = atomicType.getName().replace('.', '_');
            if (string == null || string.length() <= 0) continue;
            if (n == 12) {
                printWriter.println("\t\tret.append(\"" + string + " = \" ).append( XAtom.get(get_" + string + "()) ).append(\", \");");
                continue;
            }
            if (string.equals("type")) {
                printWriter.println("\t\tret.append(\"type = \").append( XlibWrapper.eventToString[get_type()] ).append(\", \");");
                continue;
            }
            if (string.equals("window")) {
                printWriter.println("\t\tret.append(\"window = \" ).append( getWindow(get_window()) ).append(\", \");");
                continue;
            }
            if (n == 10) {
                printWriter.print("\t\tret.append(\"{\")");
                for (int i = 0; i < atomicType.getArrayLength(); ++i) {
                    printWriter.print("\n\t\t.append( get_" + string + "(" + i + ") ).append(\" \")");
                }
                printWriter.println(".append( \"}\");");
                continue;
            }
            printWriter.println("\t\tret.append(\"" + string + " = \").append( get_" + string + "() ).append(\", \");");
        }
        printWriter.println("\t\treturn ret.toString();\n\t}\n\n");
    }

    public void writeStubs(StructType structType, PrintWriter printWriter) {
        String string = "";
        string = !structType.getIsInterface() ? "\t\tabstract " : "\t";
        Enumeration enumeration = structType.getMembers();
        while (enumeration.hasMoreElements()) {
            AtomicType atomicType = (AtomicType)enumeration.nextElement();
            int n = atomicType.getType();
            String string2 = atomicType.getName().replace('.', '_');
            if (string2 == null || string2.length() <= 0) continue;
            if (n == 10) {
                printWriter.println(string + "long get_" + string2 + "();");
                printWriter.println(string + atomicType.getJavaType() + " get_" + string2 + "(int index);");
                printWriter.println(string + "void set_" + string2 + "(int index, " + atomicType.getJavaType() + " v);");
                continue;
            }
            printWriter.println(string + atomicType.getJavaType() + " get_" + string2 + "();");
            if (n == 9) continue;
            printWriter.println(string + "void set_" + string2 + "(" + atomicType.getJavaType() + " v);");
        }
    }

    private int padSize(int n, int n2) {
        int n3 = n2 / 8;
        return (n + n3 / 2) / n3 * n3;
    }

    public void writeAccessorImpls(StructType structType, PrintWriter printWriter) {
        int n = 0;
        String string = this.getStructSize(structType, false);
        String string2 = this.getStructSize(structType, true);
        int n2 = 0;
        int n3 = 0;
        String string3 = this.generateLog ? "log.finest(\"\");" : "";
        Enumeration enumeration = structType.getMembers();
        while (enumeration.hasMoreElements()) {
            AtomicType atomicType = (AtomicType)enumeration.nextElement();
            int n4 = atomicType.getType();
            String string4 = atomicType.getName().replace('.', '_');
            String string5 = "\tpublic ";
            if (string4 == null || string4.length() <= 0) continue;
            String string6 = atomicType.getJavaType();
            String string7 = atomicType.getJavaAccess(false);
            String string8 = atomicType.getJavaAccess(true);
            String string9 = string7;
            int n5 = AtomicType.getNativeSizeForAccess(string7);
            int n6 = AtomicType.getNativeSizeForAccess(string8);
            String string10 = atomicType.getItemSize();
            if (n4 == 10) {
                n2 += n5 * atomicType.getArrayLength();
                n3 += n6 * atomicType.getArrayLength();
                printWriter.println(string5 + atomicType.getJavaType() + " get_" + string4 + "(int index) { " + string3 + "return " + atomicType.getJavaResult(structType.getOffset(atomicType) + "+index*" + string10, null) + "; }");
                if (atomicType.getReferencedType() instanceof AtomicType) {
                    printWriter.println(MessageFormat.format(string5 + "void set_{0}(int index, {1} v) '{' {3} {2}; '}'", string4, string6, atomicType.getJavaConversion("pData+" + structType.getOffset(atomicType) + " + index*" + string10, "v"), string3));
                }
                printWriter.println(string5 + "long get_" + string4 + "() { " + string3 + "return pData+" + structType.getOffset(atomicType) + "; }");
            } else if (n4 == 6) {
                printWriter.println(MessageFormat.format(string5 + "{0} get_{1}(int index) '{' {3} return {2}; '}'", string6, string4, atomicType.getJavaResult("index*" + string10, "Native.getLong(pData+" + structType.getOffset(atomicType) + ")"), string3));
                printWriter.println(string5 + "long get_" + string4 + "() { " + string3 + "return Native.getLong(pData+" + structType.getOffset(atomicType) + "); }");
                printWriter.println(MessageFormat.format(string5 + "void set_{0}({1} v) '{' {3} {2}; '}'", string4, "long", "Native.putLong(pData + " + structType.getOffset(atomicType) + ", v)", string3));
                n2 += n5;
                n3 += n6;
            } else {
                n2 += n5;
                n3 += n6;
                printWriter.println(string5 + atomicType.getJavaType() + " get_" + string4 + "() { " + string3 + "return " + atomicType.getJavaResult(structType.getOffset(atomicType), null) + "; }");
                if (n4 != 9) {
                    printWriter.println(MessageFormat.format(string5 + "void set_{0}({1} v) '{' {3} {2}; '}'", string4, string6, atomicType.getJavaConversion("pData+" + structType.getOffset(atomicType), "v"), string3));
                }
            }
            ++n;
        }
        if (string != null && !string.equals(Integer.toString(n2))) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("32 bits: The size of the structure " + structType.getName() + " " + string + " is not equal to the accumulated size " + n2 + " of the fields");
            }
        } else if (string2 != null && !string2.equals(Integer.toString(n3)) && log.isLoggable(Level.FINE)) {
            log.fine("64 bits: The size of the structure " + structType.getName() + " " + string2 + " is not equal to the accumulated size " + n3 + " of the fields");
        }
    }

    public void writeWrapperSubclass(StructType structType, PrintWriter printWriter, boolean bl) {
        printWriter.println("class " + structType.getJavaClassName() + "AccessorImpl" + " extends " + structType.getJavaClassName() + "Accessor  {");
        printWriter.println("/*\nThis class serves as a Wrapper for the following X Struct \nsThe offsets here are calculated based on actual compiler.\n\n" + structType.getDescription() + "\n\n */");
        this.writeAccessorImpls(structType, printWriter);
        printWriter.println("\n\n } \n\n");
    }

    public void writeWrapper(String string, StructType structType) {
        if (structType.getNumFields() > 0) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string + "/" + structType.getJavaClassName() + ".java");
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                printWriter.println("// This file is an automatically generated file, please do not edit this file, modify the WrapperGenerator.java file instead !\n");
                printWriter.println("package " + this.package_name + ";\n");
                printWriter.println("import sun.misc.*;\n");
                printWriter.println("import sun.util.logging.PlatformLogger;");
                String string2 = structType.getBaseClass();
                if (string2 == null) {
                    string2 = this.defaultBaseClass;
                }
                if (structType.getIsInterface()) {
                    printWriter.print("public interface ");
                    printWriter.print(structType.getJavaClassName());
                } else {
                    printWriter.print("public class ");
                    printWriter.print(structType.getJavaClassName() + " extends " + string2);
                }
                if (structType.getInterfaces() != null) {
                    printWriter.print(" implements " + structType.getInterfaces());
                }
                printWriter.println(" { ");
                if (!structType.getIsInterface()) {
                    printWriter.println("\tprivate Unsafe unsafe = XlibWrapper.unsafe; ");
                    printWriter.println("\tprivate final boolean should_free_memory;");
                    printWriter.println("\tpublic static int getSize() { return " + structType.getSize() + "; }");
                    printWriter.println("\tpublic int getDataSize() { return getSize(); }");
                    printWriter.println("\n\tlong pData;");
                    printWriter.println("\n\tpublic long getPData() { return pData; }");
                    printWriter.println("\n\n\tpublic " + structType.getJavaClassName() + "(long addr) {");
                    if (this.generateLog) {
                        printWriter.println("\t\tlog.finest(\"Creating\");");
                    }
                    printWriter.println("\t\tpData=addr;");
                    printWriter.println("\t\tshould_free_memory = false;");
                    printWriter.println("\t}");
                    printWriter.println("\n\n\tpublic " + structType.getJavaClassName() + "() {");
                    if (this.generateLog) {
                        printWriter.println("\t\tlog.finest(\"Creating\");");
                    }
                    printWriter.println("\t\tpData = unsafe.allocateMemory(getSize());");
                    printWriter.println("\t\tshould_free_memory = true;");
                    printWriter.println("\t}");
                    printWriter.println("\n\n\tpublic void dispose() {");
                    if (this.generateLog) {
                        printWriter.println("\t\tlog.finest(\"Disposing\");");
                    }
                    printWriter.println("\t\tif (should_free_memory) {");
                    if (this.generateLog) {
                        printWriter.println("\t\t\tlog.finest(\"freeing memory\");");
                    }
                    printWriter.println("\t\t\tunsafe.freeMemory(pData); \n\t}");
                    printWriter.println("\t\t}");
                    this.writeAccessorImpls(structType, printWriter);
                    this.writeToString(structType, printWriter);
                } else {
                    printWriter.println("\n\n\tvoid dispose();");
                    printWriter.println("\n\tlong getPData();");
                    this.writeStubs(structType, printWriter);
                }
                printWriter.println("}\n\n\n");
                printWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private boolean readSizeInfo(InputStream inputStream, boolean bl) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split("\\p{Space}");
                if (stringArray.length != 2) continue;
                if (bl) {
                    sizeTable64bit.put(stringArray[0], stringArray[1]);
                    continue;
                }
                sizeTable32bit.put(stringArray[0], stringArray[1]);
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void writeFunctionCallWrapper(String string, FunctionType functionType) {
        try {
            AtomicType atomicType3;
            FileOutputStream fileOutputStream = new FileOutputStream(string + "/" + functionType.getName() + ".java");
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            printWriter.println("// This file is an automatically generated file, please do not edit this file, modify the WrapperGenerator.java file instead !\n");
            printWriter.println("package " + this.package_name + ";\n");
            printWriter.println("import sun.misc.Unsafe;\n");
            printWriter.println("class " + functionType.getName() + " {");
            printWriter.println("\tprivate static Unsafe unsafe = XlibWrapper.unsafe;");
            printWriter.println("\tprivate boolean __executed = false;");
            printWriter.println("\tprivate boolean __disposed = false;");
            for (AtomicType atomicType2 : functionType.getArguments()) {
                if (atomicType2.isIn()) {
                    printWriter.println("\t" + atomicType2.getJavaType() + " _" + atomicType2.getName() + ";");
                    continue;
                }
                printWriter.println("\tlong " + atomicType2.getName() + "_ptr = unsafe.allocateMemory(Native.get" + atomicType2.getTypeUpperCase() + "Size());");
            }
            printWriter.println("\tpublic " + functionType.getName() + "(");
            Iterator iterator = functionType.getArguments().iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                atomicType3 = (AtomicType)iterator.next();
                if (!atomicType3.isIn() && !atomicType3.isInOut()) continue;
                if (!bl) {
                    printWriter.println(",");
                }
                bl = false;
                printWriter.print("\t\t" + atomicType3.getJavaType() + " " + atomicType3.getName());
            }
            printWriter.println("\t)");
            printWriter.println("\t{");
            for (AtomicType atomicType3 : functionType.getArguments()) {
                if (!atomicType3.isIn() && !atomicType3.isInOut()) continue;
                printWriter.println("\t\tset_" + atomicType3.getName() + "(" + atomicType3.getName() + ");");
            }
            printWriter.println("\t}");
            printWriter.println("\tpublic " + functionType.getReturnType() + " execute() {");
            if (functionType.isVoid()) {
                printWriter.println("\t\texecute(null);");
            } else {
                printWriter.println("\t\treturn execute(null);");
            }
            printWriter.println("\t}");
            printWriter.println("\tpublic " + functionType.getReturnType() + " execute(XToolkit.XErrorHandler errorHandler) {");
            printWriter.println("\t\tif (__disposed) {");
            printWriter.println("\t\t    throw new IllegalStateException(\"Disposed\");");
            printWriter.println("\t\t}");
            printWriter.println("\t\tXToolkit.awtLock();");
            printWriter.println("\t\ttry {");
            printWriter.println("\t\t\tif (__executed) {");
            printWriter.println("\t\t\t    throw new IllegalStateException(\"Already executed\");");
            printWriter.println("\t\t\t}");
            printWriter.println("\t\t\t__executed = true;");
            printWriter.println("\t\t\tif (errorHandler != null) {");
            printWriter.println("\t\t\t    XErrorHandlerUtil.WITH_XERROR_HANDLER(errorHandler);");
            printWriter.println("\t\t\t}");
            for (AtomicType atomicType3 : functionType.getArguments()) {
                if (atomicType3.isIn() || !atomicType3.isAutoFree()) continue;
                printWriter.println("\t\t\tNative.put" + atomicType3.getTypeUpperCase() + "(" + atomicType3.getName() + "_ptr, 0);");
            }
            if (!functionType.isVoid()) {
                printWriter.println("\t\t\t" + functionType.getReturnType() + " status = ");
            }
            printWriter.println("\t\t\tXlibWrapper." + functionType.getName() + "(XToolkit.getDisplay(), ");
            iterator = functionType.getArguments().iterator();
            bl = true;
            while (iterator.hasNext()) {
                atomicType3 = (AtomicType)iterator.next();
                if (!bl) {
                    printWriter.println(",");
                }
                bl = false;
                if (atomicType3.isIn()) {
                    printWriter.print("\t\t\t\tget_" + atomicType3.getName() + "()");
                    continue;
                }
                printWriter.print("\t\t\t\t" + atomicType3.getName() + "_ptr");
            }
            printWriter.println("\t\t\t);");
            printWriter.println("\t\t\tif (errorHandler != null) {");
            printWriter.println("\t\t\t    XErrorHandlerUtil.RESTORE_XERROR_HANDLER();");
            printWriter.println("\t\t\t}");
            if (!functionType.isVoid()) {
                printWriter.println("\t\t\treturn status;");
            }
            printWriter.println("\t\t} finally {");
            printWriter.println("\t\t    XToolkit.awtUnlock();");
            printWriter.println("\t\t}");
            printWriter.println("\t}");
            printWriter.println("\tpublic boolean isExecuted() {");
            printWriter.println("\t    return __executed;");
            printWriter.println("\t}");
            printWriter.println("\t");
            printWriter.println("\tpublic boolean isDisposed() {");
            printWriter.println("\t    return __disposed;");
            printWriter.println("\t}");
            printWriter.println("\tpublic void finalize() {");
            printWriter.println("\t    dispose();");
            printWriter.println("\t}");
            printWriter.println("\tpublic void dispose() {");
            printWriter.println("\t\tXToolkit.awtLock();");
            printWriter.println("\t\ttry {");
            printWriter.println("\t\tif (__disposed || !__executed) {");
            printWriter.println("\t\t    return;");
            printWriter.println("\t\t} finally {");
            printWriter.println("\t\t    XToolkit.awtUnlock();");
            printWriter.println("\t\t}");
            printWriter.println("\t\t}");
            for (AtomicType atomicType3 : functionType.getArguments()) {
                if (atomicType3.isIn()) continue;
                if (atomicType3.isAutoFree()) {
                    printWriter.println("\t\tif (__executed && get_" + atomicType3.getName() + "()!= 0) {");
                    printWriter.println("\t\t\tXlibWrapper.XFree(get_" + atomicType3.getName() + "());");
                    printWriter.println("\t\t}");
                }
                printWriter.println("\t\tunsafe.freeMemory(" + atomicType3.getName() + "_ptr);");
            }
            printWriter.println("\t\t__disposed = true;");
            printWriter.println("\t\t}");
            printWriter.println("\t}");
            for (AtomicType atomicType3 : functionType.getArguments()) {
                printWriter.println("\tpublic " + atomicType3.getJavaType() + " get_" + atomicType3.getName() + "() {");
                printWriter.println("\t\tif (__disposed) {");
                printWriter.println("\t\t    throw new IllegalStateException(\"Disposed\");");
                printWriter.println("\t\t}");
                printWriter.println("\t\tif (!__executed) {");
                printWriter.println("\t\t    throw new IllegalStateException(\"Not executed\");");
                printWriter.println("\t\t}");
                if (atomicType3.isIn()) {
                    printWriter.println("\t\treturn _" + atomicType3.getName() + ";");
                } else {
                    printWriter.println("\t\treturn Native.get" + atomicType3.getTypeUpperCase() + "(" + atomicType3.getName() + "_ptr);");
                }
                printWriter.println("\t}");
                printWriter.println("\tpublic void set_" + atomicType3.getName() + "(" + atomicType3.getJavaType() + " data) {");
                if (atomicType3.isIn()) {
                    printWriter.println("\t\t_" + atomicType3.getName() + " = data;");
                } else {
                    printWriter.println("\t\tNative.put" + atomicType3.getTypeUpperCase() + "(" + atomicType3.getName() + "_ptr, data);");
                }
                printWriter.println("\t}");
            }
            printWriter.println("}");
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void writeJavaWrapperClass(String string) {
        try {
            Enumeration enumeration = symbolTable.elements();
            while (enumeration.hasMoreElements()) {
                BaseType baseType = (BaseType)enumeration.nextElement();
                if (baseType instanceof StructType) {
                    StructType structType = (StructType)baseType;
                    this.writeWrapper(string, structType);
                    continue;
                }
                if (!(baseType instanceof FunctionType)) continue;
                this.writeFunctionCallWrapper(string, (FunctionType)baseType);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void writeNativeSizer(String string) {
        int n = 0;
        int n2 = 0;
        try {
            StructType structType;
            BaseType baseType;
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            printWriter.println("/* This file is an automatically generated file, please do not edit this file, modify the XlibParser.java file instead !*/\n");
            printWriter.println("#include <X11/Xlib.h>\n#include <X11/Xutil.h>\n#include <X11/Xos.h>\n#include <X11/Xatom.h>\n#include <stdio.h>\n");
            printWriter.println("#include <X11/extensions/Xdbe.h>");
            printWriter.println("#include <X11/XKBlib.h>");
            printWriter.println("#include \"awt_p.h\"");
            printWriter.println("#include \"color.h\"");
            printWriter.println("#include \"colordata.h\"");
            printWriter.println("\ntypedef struct\n");
            printWriter.println("{\n");
            printWriter.println("    unsigned long flags;\n");
            printWriter.println("    unsigned long functions;\n");
            printWriter.println("    unsigned long decorations;\n");
            printWriter.println("    long inputMode;\n");
            printWriter.println("    unsigned long status;\n");
            printWriter.println("} PropMwmHints;\n");
            printWriter.println("\n\nint main(){");
            n2 = 0;
            Enumeration enumeration = symbolTable.elements();
            while (enumeration.hasMoreElements()) {
                baseType = (BaseType)enumeration.nextElement();
                if (!(baseType instanceof StructType) || (structType = (StructType)baseType).getIsInterface()) continue;
                printWriter.println(structType.getName() + "  temp" + n2 + ";\n");
                ++n2;
            }
            n2 = 0;
            printWriter.println("printf(\"long\t%d\\n\",(int)sizeof(long));");
            printWriter.println("printf(\"int\t%d\\n\",(int)sizeof(int));");
            printWriter.println("printf(\"short\t%d\\n\",(int)sizeof(short));");
            printWriter.println("printf(\"ptr\t%d\\n\",(int)sizeof(void *));");
            printWriter.println("printf(\"Bool\t%d\\n\",(int)sizeof(Bool));");
            printWriter.println("printf(\"Atom\t%d\\n\",(int)sizeof(Atom));");
            printWriter.println("printf(\"Window\t%d\\n\",(int)sizeof(Window));");
            enumeration = symbolTable.elements();
            while (enumeration.hasMoreElements()) {
                baseType = (BaseType)enumeration.nextElement();
                if (!(baseType instanceof StructType) || (structType = (StructType)baseType).getIsInterface()) continue;
                Enumeration enumeration2 = structType.getMembers();
                while (enumeration2.hasMoreElements()) {
                    AtomicType atomicType = (AtomicType)enumeration2.nextElement();
                    if (atomicType.isAlias()) continue;
                    printWriter.println("printf(\"" + structType.getName() + "." + atomicType.getName() + "\t%d\\n\"" + ",(int)((unsigned long ) &temp" + n2 + "." + atomicType.getName() + "- (unsigned long ) &temp" + n2 + ")  );");
                    ++n;
                }
                printWriter.println("printf(\"" + structType.getName() + "\t%d\\n\"" + ",(int)sizeof(temp" + n2 + "));");
                ++n2;
            }
            printWriter.println("return 0;");
            printWriter.println("}");
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initTypes() {
        symbolTable.put("int", new AtomicType(0, "", "int"));
        symbolTable.put("short", new AtomicType(7, "", "short"));
        symbolTable.put("long", new AtomicType(2, "", "long"));
        symbolTable.put("float", new AtomicType(5, "", "float"));
        symbolTable.put("double", new AtomicType(4, "", "double"));
        symbolTable.put("Bool", new AtomicType(8, "", "Bool"));
        symbolTable.put("char", new AtomicType(1, "", "char"));
        symbolTable.put("byte", new AtomicType(11, "", "byte"));
        symbolTable.put("pointer", new AtomicType(6, "", "pointer"));
        symbolTable.put("longlong", new AtomicType(3, "", "longlong"));
        symbolTable.put("Atom", new AtomicType(12, "", "Atom"));
        symbolTable.put("ulong", new AtomicType(13, "", "ulong"));
    }

    public WrapperGenerator(String string, String string2) {
        this.initTypes();
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
            Object object = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                Object object2;
                Object object3;
                int n = string3.indexOf("//");
                if (n >= 0) {
                    string3 = string3.substring(0, n);
                }
                if ("".equals(string3)) continue;
                String[] stringArray = string3.split("\\p{Space}+");
                if (stringArray.length >= 2) {
                    object3 = ((BaseType)object).getName();
                    object2 = stringArray[1];
                    String string4 = stringArray[2];
                    BaseType baseType = object;
                    int n2 = AtomicType.getTypeForString(string4);
                    AtomicType atomicType = null;
                    if (baseType != null && n2 != -1) {
                        atomicType = new AtomicType(n2, (String)object2, string4);
                        if (stringArray.length > 3) {
                            atomicType.setAttributes(stringArray);
                        }
                        if (baseType instanceof StructType) {
                            StructType structType = (StructType)baseType;
                            structType.addMember(atomicType);
                            continue;
                        }
                        if (!(baseType instanceof FunctionType)) continue;
                        ((FunctionType)baseType).addArgument(atomicType);
                        continue;
                    }
                    if (baseType != null) continue;
                    System.out.println("Cannot find " + (String)object3);
                    continue;
                }
                if (string3 == null || (object3 = (BaseType)symbolTable.get(string3)) != null) continue;
                if (string3.startsWith("!")) {
                    object2 = new FunctionType(string3);
                    ((FunctionType)object2).setName(string3);
                    symbolTable.put(((BaseType)object2).getName(), object2);
                    object = object2;
                    continue;
                }
                object2 = new StructType(string3);
                ((StructType)object2).setName(string3);
                object = object2;
                symbolTable.put(((BaseType)object2).getName(), object2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void makeSizer(String string) {
        this.sizerFileName = this.wide ? "sizer.64.c" : "sizer.32.c";
        File file = new File(string, this.sizerFileName);
        this.writeNativeSizer(file.getAbsolutePath());
    }

    private boolean readSizeInfo(String string) {
        try {
            File file = new File(string + ".32");
            boolean bl = true;
            FileInputStream fileInputStream = null;
            if (file.exists()) {
                fileInputStream = new FileInputStream(file);
                bl = this.readSizeInfo(fileInputStream, false);
                fileInputStream.close();
            }
            if ((file = new File(string + ".64")).exists()) {
                fileInputStream = new FileInputStream(file);
                bl &= this.readSizeInfo(fileInputStream, true);
                fileInputStream.close();
            }
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private void startGeneration(String string, String string2) {
        if (this.readSizeInfo(string2)) {
            this.writeJavaWrapperClass(string);
        } else {
            System.out.println("Error calculating offsets");
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 4) {
            System.out.println("Usage:\nWrapperGenerator <output_dir> <xlibtypes.txt> <action> [<platform> | <sizes info file>]");
            System.out.println("Where <action>: gen, sizer");
            System.out.println("      <platform>: 32, 64");
            System.exit(1);
        }
        WrapperGenerator wrapperGenerator = new WrapperGenerator(stringArray[0], stringArray[1]);
        if (stringArray[2].equals("sizer")) {
            wrapperGenerator.wide = stringArray[3].equals("64");
            wrapperGenerator.makeSizer(stringArray[0]);
        } else if (stringArray[2].equals("gen")) {
            wrapperGenerator.startGeneration(stringArray[0], stringArray[3]);
        }
    }

    static {
        knownSizes64.put("XComposeStatus", 16);
        knownSizes64.put("XTimeCoord", 16);
        knownSizes64.put("XExtData", 32);
        knownSizes64.put("XWindowChanges", 40);
        knownSizes64.put("XOMCharSetList", 16);
        knownSizes64.put("XModifierKeymap", 16);
        knownSizes32.put("XIMValuesList", 8);
        knownSizes32.put("XGCValues", 92);
    }

    private static class FunctionType
    extends BaseType {
        Vector args = new Vector();
        String description;
        boolean packed;
        String returnType;
        int alignment;

        public FunctionType(String string) {
            this.description = string;
            this.setName(string);
        }

        boolean isVoid() {
            return this.returnType == null;
        }

        String getReturnType() {
            if (this.returnType == null) {
                return "void";
            }
            return this.returnType;
        }

        public int getNumArgs() {
            return this.args.size();
        }

        public void setName(String string) {
            if (string.startsWith("!")) {
                string = string.substring(1, string.length());
            }
            if (string.indexOf("|") != -1) {
                this.returnType = string.substring(string.indexOf("|") + 1, string.length());
                string = string.substring(0, string.indexOf("|"));
            }
            this.name = string.replaceAll("[* \t]", "");
        }

        public String getDescription() {
            return this.description;
        }

        public Collection getArguments() {
            return this.args;
        }

        public void addArgument(BaseType baseType) {
            this.args.add(baseType);
        }
    }

    private static class StructType
    extends BaseType {
        Vector members = new Vector();
        String description;
        boolean packed;
        int size;
        String baseClass;
        String interfaces;
        boolean isInterface;
        String javaClassName;

        public StructType(String string) {
            this.parseDescription(string);
        }

        public int getNumFields() {
            return this.members.size();
        }

        public void setName(String string) {
            string = string.replaceAll("[* \t]", "");
            this.parseDescription(string);
        }

        public void setSize(int n) {
            this.size = n;
        }

        public String getDescription() {
            return this.description;
        }

        public Enumeration getMembers() {
            return this.members.elements();
        }

        public void addMember(BaseType baseType) {
            this.members.add(baseType);
        }

        public String getBaseClass() {
            return this.baseClass;
        }

        public String getInterfaces() {
            return this.interfaces;
        }

        public boolean getIsInterface() {
            return this.isInterface;
        }

        public String getJavaClassName() {
            return this.javaClassName;
        }

        void parseDescription(String string) {
            if (string.indexOf(91) != -1) {
                this.baseClass = string.substring(string.indexOf(91) + 1, string.indexOf(93));
                string = string.substring(0, string.indexOf(91)) + string.substring(string.indexOf(93) + 1);
            }
            if (string.indexOf(123) != -1) {
                this.interfaces = string.substring(string.indexOf(123) + 1, string.indexOf(125));
                string = string.substring(0, string.indexOf(123)) + string.substring(string.indexOf(125) + 1);
            }
            if (string.startsWith("-")) {
                this.isInterface = true;
                string = string.substring(1, string.length());
            }
            if (string.indexOf("|") != -1) {
                this.javaClassName = string.substring(string.indexOf(124) + 1, string.length());
                string = string.substring(0, string.indexOf(124));
            }
            this.name = string;
            if (this.javaClassName == null) {
                this.javaClassName = this.name;
            }
            this.description = string;
        }

        public String getSize() {
            String string = (String)sizeTable32bit.get(this.getName());
            String string2 = (String)sizeTable64bit.get(this.getName());
            if (string == null || string2 == null) {
                return string == null ? string2 : string;
            }
            if (string.equals(string2)) {
                return string;
            }
            return MessageFormat.format("((XlibWrapper.dataModel == 32)?({0}):({1}))", string, string2);
        }

        public String getOffset(AtomicType atomicType) {
            String string = this.getName() + "." + (atomicType.isAlias() ? atomicType.getAliasName() : atomicType.getName());
            String string2 = (String)sizeTable64bit.get(string);
            String string3 = (String)sizeTable32bit.get(string);
            if (string3 == null || string2 == null) {
                return string3 == null ? string2 : string3;
            }
            if (string3.equals(string2)) {
                return string3;
            }
            return MessageFormat.format("((XlibWrapper.dataModel == 32)?({0}):({1}))", string3, string2);
        }
    }

    private static class AtomicType
    extends BaseType {
        private boolean alias;
        private String aliasName;
        static final int TYPE_INT = 0;
        static final int TYPE_CHAR = 1;
        static final int TYPE_LONG = 2;
        static final int TYPE_LONG_LONG = 3;
        static final int TYPE_DOUBLE = 4;
        static final int TYPE_FLOAT = 5;
        static final int TYPE_PTR = 6;
        static final int TYPE_SHORT = 7;
        static final int TYPE_BOOL = 8;
        static final int TYPE_STRUCT = 9;
        static final int TYPE_ARRAY = 10;
        static final int TYPE_BYTE = 11;
        static final int TYPE_ATOM = 12;
        static final int TYPE_ULONG = 13;
        int type;
        int offset;
        int direction;
        BaseType referencedType;
        int arrayLength = -1;
        boolean autoFree = false;

        static int getTypeForString(String string) {
            int n = -1;
            if (string.equals("int")) {
                n = 0;
            } else if (string.equals("long")) {
                n = 2;
            } else if (string.equals("byte")) {
                n = 11;
            } else if (string.equals("char")) {
                n = 1;
            } else if (string.equals("long long")) {
                n = 3;
            } else if (string.equals("double")) {
                n = 4;
            } else if (string.equals("float")) {
                n = 5;
            } else if (string.equals("pointer")) {
                n = 6;
            } else if (string.equals("short")) {
                n = 7;
            } else if (string.equals("Bool")) {
                n = 8;
            } else if (string.equals("struct")) {
                n = 9;
            } else if (string.equals("Atom")) {
                n = 12;
            } else if (string.equals("array")) {
                n = 10;
            } else if (string.equals("ulong")) {
                n = 13;
            } else {
                throw new IllegalArgumentException("Uknown type string: " + string);
            }
            return n;
        }

        String getJavaType() {
            if (this.referencedType != null) {
                if (this.referencedType instanceof AtomicType) {
                    return ((AtomicType)this.referencedType).getJavaType();
                }
                return this.referencedType.getName();
            }
            return AtomicType.getJavaTypeForType(this.type);
        }

        static String getJavaTypeForType(int n) {
            switch (n) {
                case 0: {
                    return "int";
                }
                case 1: {
                    return "char";
                }
                case 11: {
                    return "byte";
                }
                case 2: 
                case 3: 
                case 6: 
                case 13: {
                    return "long";
                }
                case 4: {
                    return "double";
                }
                case 5: {
                    return "float";
                }
                case 7: {
                    return "short";
                }
                case 8: {
                    return "boolean";
                }
                case 12: {
                    return "long";
                }
            }
            throw new IllegalArgumentException("Unknown type: " + n);
        }

        String getItemSize() {
            int n;
            if (this.referencedType != null) {
                if (this.referencedType instanceof StructType) {
                    return ((StructType)this.referencedType).getSize();
                }
                return ((AtomicType)this.referencedType).getItemSize();
            }
            int n2 = AtomicType.getNativeSizeForAccess(this.getJavaAccess(false));
            if (n2 != (n = AtomicType.getNativeSizeForAccess(this.getJavaAccess(true)))) {
                return "Native.get" + this.getNativeAccess() + "Size()";
            }
            return Integer.toString(n2);
        }

        String getJavaResult(String string, String string2) {
            String string3 = null;
            switch (this.type) {
                case 9: {
                    string3 = "pData + " + string;
                    break;
                }
                case 6: {
                    if (this.referencedType == null || this.referencedType instanceof StructType) {
                        string3 = string2 + "+" + string;
                        break;
                    }
                    if (!(this.referencedType instanceof AtomicType)) break;
                    string3 = MessageFormat.format("Native.get{0}({1})", AtomicType.getNativeAccessForType(((AtomicType)this.referencedType).type), string2 + "+" + string);
                    break;
                }
                case 10: {
                    if (this.referencedType instanceof StructType) {
                        string3 = "pData + " + string;
                        break;
                    }
                    if (!(this.referencedType instanceof AtomicType)) break;
                    string3 = MessageFormat.format("Native.get{0}(pData + {1})", AtomicType.getNativeAccessForType(((AtomicType)this.referencedType).type), string);
                    break;
                }
                default: {
                    string3 = MessageFormat.format("(Native.get{0}(pData+{1}))", this.getNativeAccess(), string);
                }
            }
            return this.getJavaResultConversion(string3, string2);
        }

        String getJavaResultConversion(String string, String string2) {
            if (this.referencedType != null) {
                if (this.referencedType instanceof StructType) {
                    if (this.type == 6) {
                        return MessageFormat.format("({2} != 0)?(new {0}({1})):(null)", this.referencedType.getName(), string, string2);
                    }
                    return MessageFormat.format("new {0}({1})", this.referencedType.getName(), string);
                }
                return string;
            }
            return AtomicType.getJavaResultConversionForType(this.type, string);
        }

        static String getJavaResultConversionForType(int n, String string) {
            return string;
        }

        String getNativeAccess() {
            return AtomicType.getNativeAccessForType(this.type);
        }

        String getJavaAccess(boolean bl) {
            return AtomicType.getJavaAccessForType(this.type, bl);
        }

        static String getJavaAccessForType(int n, boolean bl) {
            switch (n) {
                case 0: {
                    return "Int";
                }
                case 1: {
                    return "Char";
                }
                case 11: {
                    return "Byte";
                }
                case 2: 
                case 6: 
                case 9: 
                case 10: 
                case 12: {
                    return bl ? "Long" : "Int";
                }
                case 3: {
                    return "Long";
                }
                case 13: {
                    return bl ? "ULong" : "UInt";
                }
                case 4: {
                    return "Double";
                }
                case 5: {
                    return "Float";
                }
                case 7: {
                    return "Short";
                }
                case 8: {
                    return "Int";
                }
            }
            throw new IllegalArgumentException("Unknown type: " + n);
        }

        static String getNativeAccessForType(int n) {
            switch (n) {
                case 0: {
                    return "Int";
                }
                case 1: {
                    return "Char";
                }
                case 11: {
                    return "Byte";
                }
                case 2: 
                case 6: 
                case 9: 
                case 10: {
                    return "Long";
                }
                case 3: {
                    return "Long";
                }
                case 13: {
                    return "ULong";
                }
                case 4: {
                    return "Double";
                }
                case 5: {
                    return "Float";
                }
                case 7: {
                    return "Short";
                }
                case 8: {
                    return "Bool";
                }
                case 12: {
                    return "Long";
                }
            }
            throw new IllegalArgumentException("Unknown type: " + n);
        }

        static int getNativeSizeForAccess(String string) {
            if (string.equals("Int")) {
                return 4;
            }
            if (string.equals("Byte")) {
                return 1;
            }
            if (string.equals("Long")) {
                return 8;
            }
            if (string.equals("Double")) {
                return 8;
            }
            if (string.equals("Float")) {
                return 4;
            }
            if (string.equals("Char")) {
                return 2;
            }
            if (string.equals("Short")) {
                return 2;
            }
            if (string.equals("ULong")) {
                return 8;
            }
            if (string.equals("UInt")) {
                return 4;
            }
            throw new IllegalArgumentException("Unknow access type: " + string);
        }

        String getJavaConversion(String string, String string2) {
            if (this.referencedType != null) {
                if (this.referencedType instanceof StructType) {
                    return AtomicType.getJavaConversionForType(6, string, string2 + ".pData");
                }
                if (this.type == 10) {
                    return AtomicType.getJavaConversionForType(((AtomicType)this.referencedType).type, string, string2);
                }
                return AtomicType.getJavaConversionForType(6, string, string2);
            }
            return AtomicType.getJavaConversionForType(this.type, string, string2);
        }

        static String getJavaConversionForType(int n, String string, String string2) {
            return MessageFormat.format("Native.put{0}({2}, {1})", AtomicType.getNativeAccessForType(n), string2, string);
        }

        public AtomicType(int n, String string, String string2) {
            this.name = string.replaceAll("[* \t]", "");
            if (this.name.indexOf("[") != -1 || this.name.indexOf("]") != -1) {
                this.name = this.name.replaceAll("\\[.*\\]", "");
            }
            this.type = n;
            this.real_type = string2;
            if (this.real_type == null) {
                System.out.println(" real type is null");
            }
        }

        public boolean isIn() {
            return this.direction == 0;
        }

        public boolean isOut() {
            return this.direction == 1;
        }

        public boolean isInOut() {
            return this.direction == 2;
        }

        public boolean isAutoFree() {
            return this.autoFree;
        }

        public void setAttributes(String[] stringArray) {
            String string = stringArray[3];
            if ("in".equals(string)) {
                this.direction = 0;
            } else if ("out".equals(string)) {
                this.direction = 1;
                if (stringArray.length > 4 && "free".equals(stringArray[4])) {
                    this.autoFree = true;
                }
            } else if ("inout".equals(string)) {
                this.direction = 2;
            } else if ("alias".equals(string)) {
                this.alias = true;
                this.aliasName = stringArray[4];
            } else if (this.type == 10 || this.type == 6 || this.type == 9) {
                this.referencedType = (BaseType)symbolTable.get(string);
                if (this.referencedType == null) {
                    log.warning("Can't find type for name " + string);
                }
                if (stringArray.length > 4) {
                    try {
                        this.arrayLength = Integer.parseInt(stringArray[4]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public BaseType getReferencedType() {
            return this.referencedType;
        }

        public int getArrayLength() {
            return this.arrayLength;
        }

        public void setOffset(int n) {
            this.offset = n;
        }

        public int getType() {
            return this.type;
        }

        public String getTypeUpperCase() {
            switch (this.type) {
                case 0: {
                    return "Int";
                }
                case 1: {
                    return "Char";
                }
                case 11: {
                    return "Byte";
                }
                case 2: 
                case 3: 
                case 6: {
                    return "Long";
                }
                case 4: {
                    return "Double";
                }
                case 5: {
                    return "Float";
                }
                case 7: {
                    return "Short";
                }
                case 8: {
                    return "Int";
                }
                case 12: {
                    return "Long";
                }
                case 13: {
                    return "ULong";
                }
            }
            throw new IllegalArgumentException("Uknown type");
        }

        public int getOffset() {
            return this.offset;
        }

        public boolean isAlias() {
            return this.alias;
        }

        public String getAliasName() {
            return this.aliasName;
        }
    }

    private static abstract class BaseType {
        String real_type;
        String name;

        private BaseType() {
        }

        public String getName() {
            return this.name;
        }

        public String getRealType() {
            return this.real_type;
        }

        public String toString() {
            return this.name;
        }
    }
}

