/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import sun.awt.image.MultiResolutionImage;

public class MultiResolutionBufferedImage
extends BufferedImage
implements MultiResolutionImage {
    Image[] resolutionVariants;
    int baseIndex;

    public MultiResolutionBufferedImage(int n, int n2, Image ... imageArray) {
        super(imageArray[n2].getWidth(null), imageArray[n2].getHeight(null), n);
        this.baseIndex = n2;
        this.resolutionVariants = imageArray;
        Graphics graphics = this.getGraphics();
        graphics.drawImage(imageArray[n2], 0, 0, null);
        graphics.dispose();
        imageArray[n2] = this;
    }

    @Override
    public Image getResolutionVariant(int n, int n2) {
        for (Image image : this.resolutionVariants) {
            if (n > image.getWidth(null) || n2 > image.getHeight(null)) continue;
            return image;
        }
        return this;
    }

    @Override
    public List<Image> getResolutionVariants() {
        return Arrays.asList(this.resolutionVariants);
    }

    public MultiResolutionBufferedImage map(ImageMapper imageMapper) {
        Image[] imageArray = new Image[this.resolutionVariants.length];
        for (int i = 0; i < this.resolutionVariants.length; ++i) {
            imageArray[i] = imageMapper.mapImage(this.resolutionVariants[i]);
        }
        return new MultiResolutionBufferedImage(this.getType(), this.baseIndex, imageArray);
    }

    public static interface ImageMapper {
        public Image mapImage(Image var1);
    }
}

