/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ListIterator;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.BasicChecker;
import sun.security.provider.certpath.ConstraintsChecker;
import sun.security.provider.certpath.PKIX;
import sun.security.provider.certpath.PolicyChecker;
import sun.security.provider.certpath.PolicyNodeImpl;
import sun.security.provider.certpath.RevocationChecker;
import sun.security.provider.certpath.State;
import sun.security.provider.certpath.UntrustedChecker;
import sun.security.util.Debug;
import sun.security.x509.NameConstraintsExtension;
import sun.security.x509.SubjectKeyIdentifierExtension;
import sun.security.x509.X509CertImpl;

class ReverseState
implements State {
    private static final Debug debug = Debug.getInstance("certpath");
    X500Principal subjectDN;
    PublicKey pubKey;
    SubjectKeyIdentifierExtension subjKeyId;
    NameConstraintsExtension nc;
    int explicitPolicy;
    int policyMapping;
    int inhibitAnyPolicy;
    int certIndex;
    PolicyNodeImpl rootNode;
    int remainingCACerts;
    ArrayList<PKIXCertPathChecker> userCheckers;
    private boolean init = true;
    RevocationChecker revChecker;
    AlgorithmChecker algorithmChecker;
    UntrustedChecker untrustedChecker;
    TrustAnchor trustAnchor;
    boolean crlSign = true;

    ReverseState() {
    }

    @Override
    public boolean isInitial() {
        return this.init;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("State [");
        stringBuilder.append("\n  subjectDN of last cert: ").append(this.subjectDN);
        stringBuilder.append("\n  subjectKeyIdentifier: ").append(String.valueOf(this.subjKeyId));
        stringBuilder.append("\n  nameConstraints: ").append(String.valueOf(this.nc));
        stringBuilder.append("\n  certIndex: ").append(this.certIndex);
        stringBuilder.append("\n  explicitPolicy: ").append(this.explicitPolicy);
        stringBuilder.append("\n  policyMapping:  ").append(this.policyMapping);
        stringBuilder.append("\n  inhibitAnyPolicy:  ").append(this.inhibitAnyPolicy);
        stringBuilder.append("\n  rootNode: ").append(this.rootNode);
        stringBuilder.append("\n  remainingCACerts: ").append(this.remainingCACerts);
        stringBuilder.append("\n  crlSign: ").append(this.crlSign);
        stringBuilder.append("\n  init: ").append(this.init);
        stringBuilder.append("\n]\n");
        return stringBuilder.toString();
    }

    public void initState(PKIX.BuilderParams builderParams) throws CertPathValidatorException {
        int n = builderParams.maxPathLength();
        int n2 = this.remainingCACerts = n == -1 ? Integer.MAX_VALUE : n;
        if (builderParams.explicitPolicyRequired()) {
            this.explicitPolicy = 0;
        } else {
            int n3 = this.explicitPolicy = n == -1 ? n : n + 2;
        }
        if (builderParams.policyMappingInhibited()) {
            this.policyMapping = 0;
        } else {
            int n4 = this.policyMapping = n == -1 ? n : n + 2;
        }
        this.inhibitAnyPolicy = builderParams.anyPolicyInhibited() ? 0 : (n == -1 ? n : n + 2);
        this.certIndex = 1;
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add("2.5.29.32.0");
        this.rootNode = new PolicyNodeImpl(null, "2.5.29.32.0", null, false, hashSet, false);
        this.userCheckers = new ArrayList<PKIXCertPathChecker>(builderParams.certPathCheckers());
        for (PKIXCertPathChecker pKIXCertPathChecker : this.userCheckers) {
            pKIXCertPathChecker.init(false);
        }
        this.crlSign = true;
        this.init = true;
    }

    public void updateState(TrustAnchor trustAnchor, PKIX.BuilderParams builderParams) throws CertificateException, IOException, CertPathValidatorException {
        this.trustAnchor = trustAnchor;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        if (x509Certificate != null) {
            this.updateState(x509Certificate);
        } else {
            X500Principal x500Principal = trustAnchor.getCA();
            this.updateState(trustAnchor.getCAPublicKey(), x500Principal);
        }
        for (PKIXCertPathChecker pKIXCertPathChecker : this.userCheckers) {
            if (!(pKIXCertPathChecker instanceof AlgorithmChecker)) continue;
            ((AlgorithmChecker)pKIXCertPathChecker).trySetTrustAnchor(trustAnchor);
        }
        if (builderParams.revocationEnabled()) {
            this.revChecker = new RevocationChecker(trustAnchor, builderParams);
            this.revChecker.init(false);
        }
        this.init = false;
    }

    private void updateState(PublicKey publicKey, X500Principal x500Principal) {
        this.subjectDN = x500Principal;
        this.pubKey = publicKey;
    }

    @Override
    public void updateState(X509Certificate x509Certificate) throws CertificateException, IOException, CertPathValidatorException {
        if (x509Certificate == null) {
            return;
        }
        this.subjectDN = x509Certificate.getSubjectX500Principal();
        X509CertImpl x509CertImpl = X509CertImpl.toImpl(x509Certificate);
        PublicKey publicKey = x509Certificate.getPublicKey();
        if (PKIX.isDSAPublicKeyWithoutParams(publicKey)) {
            publicKey = BasicChecker.makeInheritedParamsKey(publicKey, this.pubKey);
        }
        this.pubKey = publicKey;
        if (this.init) {
            this.init = false;
            return;
        }
        this.subjKeyId = x509CertImpl.getSubjectKeyIdentifierExtension();
        this.crlSign = RevocationChecker.certCanSignCrl(x509Certificate);
        if (this.nc != null) {
            this.nc.merge(x509CertImpl.getNameConstraintsExtension());
        } else {
            this.nc = x509CertImpl.getNameConstraintsExtension();
            if (this.nc != null) {
                this.nc = (NameConstraintsExtension)this.nc.clone();
            }
        }
        this.explicitPolicy = PolicyChecker.mergeExplicitPolicy(this.explicitPolicy, x509CertImpl, false);
        this.policyMapping = PolicyChecker.mergePolicyMapping(this.policyMapping, x509CertImpl);
        this.inhibitAnyPolicy = PolicyChecker.mergeInhibitAnyPolicy(this.inhibitAnyPolicy, x509CertImpl);
        ++this.certIndex;
        this.remainingCACerts = ConstraintsChecker.mergeBasicConstraints(x509Certificate, this.remainingCACerts);
        this.init = false;
    }

    @Override
    public boolean keyParamsNeeded() {
        return false;
    }

    @Override
    public Object clone() {
        try {
            ReverseState reverseState = (ReverseState)super.clone();
            reverseState.userCheckers = (ArrayList)this.userCheckers.clone();
            ListIterator<PKIXCertPathChecker> listIterator = reverseState.userCheckers.listIterator();
            while (listIterator.hasNext()) {
                PKIXCertPathChecker pKIXCertPathChecker = listIterator.next();
                if (!(pKIXCertPathChecker instanceof Cloneable)) continue;
                listIterator.set((PKIXCertPathChecker)pKIXCertPathChecker.clone());
            }
            if (this.nc != null) {
                reverseState.nc = (NameConstraintsExtension)this.nc.clone();
            }
            if (this.rootNode != null) {
                reverseState.rootNode = this.rootNode.copyTree();
            }
            return reverseState;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }
}

