/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.x86;

import sun.jvm.hotspot.asm.Address;
import sun.jvm.hotspot.asm.Immediate;
import sun.jvm.hotspot.asm.ImmediateOrRegister;
import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.Operand;
import sun.jvm.hotspot.asm.x86.SSEInstructionDecoder;
import sun.jvm.hotspot.asm.x86.X86InstructionFactory;
import sun.jvm.hotspot.asm.x86.X86Register;

public class SSEMoveDecoder
extends SSEInstructionDecoder {
    public SSEMoveDecoder(String name, int addrMode1, int operandType1, int addrMode2, int operandType2) {
        super(name, addrMode1, operandType1, addrMode2, operandType2);
    }

    @Override
    protected Instruction decodeInstruction(byte[] bytesArray, boolean operandSize, boolean addrSize, X86InstructionFactory factory) {
        Operand op1 = this.getOperand1(bytesArray, operandSize, addrSize);
        Operand op2 = this.getOperand2(bytesArray, operandSize, addrSize);
        int size = this.byteIndex - this.instrStartIndex;
        if (op1 instanceof X86Register && op2 instanceof ImmediateOrRegister) {
            return factory.newMoveInstruction(this.name, (X86Register)op1, (ImmediateOrRegister)op2, size, 0);
        }
        if (op1 instanceof Address && op2 instanceof Immediate) {
            return factory.newGeneralInstruction(this.name, op1, op2, size, 0);
        }
        if (op1 instanceof Address && op2 instanceof X86Register) {
            return factory.newMoveStoreInstruction(this.name, (Address)op1, (X86Register)op2, 0, size, 0);
        }
        if (op1 instanceof X86Register && op2 instanceof Address) {
            return factory.newMoveLoadInstruction(this.name, (X86Register)op1, (Address)op2, 0, size, 0);
        }
        return null;
    }
}

