/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_kn extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "\u0cae\u0ca7\u0ccd\u0caf \u0c86\u0cab\u0ccd\u0cb0\u0cbf\u0c95\u0cbe \u0cb8\u0cae\u0caf",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "\u0cae\u0cbe\u0cb8\u0ccd\u0c95\u0ccb \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "MSK",
               "\u0cae\u0cbe\u0cb8\u0ccd\u0c95\u0ccb \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "MSD",
               "\u0cae\u0cbe\u0cb8\u0ccd\u0c95\u0ccb \u0cb8\u0cae\u0caf",
               "MT",
            };
        final String[] Japan = new String[] {
               "\u0c9c\u0caa\u0cbe\u0ca8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "JST",
               "\u0c9c\u0caa\u0cbe\u0ca8\u0ccd \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "JDT",
               "\u0c9c\u0caa\u0cbe\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "\u0caa\u0cbe\u0c95\u0cbf\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "PKT",
               "\u0caa\u0cbe\u0c95\u0cbf\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8 \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "PKST",
               "\u0caa\u0cbe\u0c95\u0cbf\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8 \u0cb8\u0cae\u0caf",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "\u0ca4\u0cc8\u0caa\u0cc6 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "CST",
               "\u0ca4\u0cc8\u0caa\u0cc6 \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "CDT",
               "\u0ca4\u0cc8\u0caa\u0cc6 \u0cb8\u0cae\u0caf",
               "CT",
            };
        final String[] Hovd = new String[] {
               "\u0cb9\u0cb5\u0ccd\u0ca1\u0ccd \u0cb8\u0ccd\u0c9f\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0cb0\u0ccd\u0ca1\u0ccd \u0cb8\u0cae\u0caf",
               "HOVT",
               "\u0cb9\u0cb5\u0ccd\u0ca1\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "HOVST",
               "\u0cb9\u0cb5\u0ccd\u0ca1\u0ccd \u0cb8\u0cae\u0caf",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "\u0cae\u0c97\u0ca1\u0cbe\u0ca8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "MAGT",
               "\u0cae\u0c97\u0ca1\u0cbe\u0ca8\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "MAGST",
               "\u0cae\u0c97\u0ca1\u0cbe\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "ACWST",
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "ACWDT",
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0cb8\u0cae\u0caf",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "\u0cae\u0ca7\u0ccd\u0caf \u0caf\u0cc1\u0cb0\u0ccb\u0caa\u0cbf\u0caf\u0ca8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "CET",
               "\u0cae\u0ca7\u0ccd\u0caf \u0caf\u0cc1\u0cb0\u0ccb\u0caa\u0cbf\u0caf\u0ca8\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "CEST",
               "\u0cae\u0ca7\u0ccd\u0caf \u0caf\u0cc1\u0cb0\u0ccb\u0caa\u0cbf\u0caf\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "\u0cb8\u0ccd\u0caf\u0cbe\u0c95\u0ccd\u200c\u0cb9\u0cb2\u0cbf\u0ca8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "SAKT",
               "\u0cb8\u0ccd\u0caf\u0cbe\u0c95\u0ccd\u200c\u0cb9\u0cb2\u0cbf\u0ca8\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "SAKST",
               "\u0cb8\u0ccd\u0caf\u0cbe\u0c95\u0ccd\u200c\u0cb9\u0cb2\u0cbf\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "\u0caa\u0cb0\u0cbe\u0c97\u0ccd\u0cb5\u0cc7 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "PYT",
               "\u0caa\u0cb0\u0cbe\u0c97\u0ccd\u0cb5\u0cc7 \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "PYST",
               "\u0caa\u0cb0\u0cbe\u0c97\u0ccd\u0cb5\u0cc7 \u0cb8\u0cae\u0caf",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "\u0cae\u0cb2\u0cc7\u0cb7\u0cbf\u0caf\u0cbe \u0cb8\u0cae\u0caf",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "\u0c89\u0ca4\u0ccd\u0ca4\u0cb0 \u0c85\u0cae\u0cc6\u0cb0\u0cbf\u0c95\u0ca6 \u0caa\u0cc2\u0cb0\u0ccd\u0cb5\u0ca6 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "EST",
               "\u0c89\u0ca4\u0ccd\u0ca4\u0cb0 \u0c85\u0cae\u0cc6\u0cb0\u0cbf\u0c95\u0ca6 \u0caa\u0cc2\u0cb0\u0ccd\u0cb5\u0ca6 \u0ca6\u0cbf\u0ca8\u0ca6 \u0cb8\u0cae\u0caf",
               "EDT",
               "\u0c89\u0ca4\u0ccd\u0ca4\u0cb0 \u0c85\u0cae\u0cc6\u0cb0\u0cbf\u0c95\u0ca6 \u0caa\u0cc2\u0cb0\u0ccd\u0cb5\u0ca6 \u0cb8\u0cae\u0caf",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "\u0cb2\u0cbe\u0cb0\u0ccd\u0ca1\u0ccd \u0cb9\u0ccb\u0cb5\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "LHST",
               "\u0cb2\u0cbe\u0cb0\u0ccd\u0ca1\u0ccd \u0cb9\u0ccb\u0cb5\u0ccd \u0cac\u0cc6\u0cb3\u0c97\u0cbf\u0ca8 \u0cb8\u0cae\u0caf",
               "LHDT",
               "\u0cb2\u0cbe\u0cb0\u0ccd\u0ca1\u0ccd \u0cb9\u0ccb\u0cb5\u0ccd \u0cb8\u0cae\u0caf",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "\u0ca8\u0ccd\u0caf\u0cc2\u0c9c\u0cbf\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "NZST",
               "\u0ca8\u0ccd\u0caf\u0cc2\u0c9c\u0cbf\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "NZDT",
               "\u0ca8\u0ccd\u0caf\u0cc2\u0c9c\u0cbf\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd \u0cb8\u0cae\u0caf",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "\u0cb9\u0cbf\u0c82\u0ca6\u0cc2 \u0cae\u0cb9\u0cbe\u0cb8\u0cbe\u0c97\u0cb0 \u0cb8\u0cae\u0caf",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "\u0caf\u0cbe\u0c95\u0cc1\u0c9f\u0ccd\u0cb8\u0c95\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "YAKT",
               "\u0caf\u0cbe\u0c95\u0cc1\u0c9f\u0ccd\u0cb8\u0c95\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "YAKST",
               "\u0caf\u0cbe\u0c95\u0cc1\u0c9f\u0ccd\u0cb8\u0c95\u0ccd \u0cb8\u0cae\u0caf",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "\u0cae\u0cbe\u0cb0\u0cbf\u0cb7\u0cb8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "MUT",
               "\u0cae\u0cbe\u0cb0\u0cbf\u0cb7\u0cb8\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "MUST",
               "\u0cae\u0cbe\u0cb0\u0cbf\u0cb7\u0cb8\u0ccd \u0cb8\u0cae\u0caf",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0c86\u0cab\u0ccd\u0cb0\u0cbf\u0c95\u0cbe \u0cb8\u0cae\u0caf",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0c9f\u0cbf\u0cae\u0ccb\u0cb0\u0ccd \u0cb8\u0cae\u0caf",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "\u0cb8\u0cbe\u0cb2\u0cae\u0ca8\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3 \u0cb8\u0cae\u0caf",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "\u0c95\u0cca\u0cb8\u0cb0\u0cc6 \u0cb8\u0cae\u0caf",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "\u0cae\u0cbe\u0cb0\u0ccd\u0cb7\u0cb2\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3 \u0cb8\u0cae\u0caf",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0caf\u0cc1\u0cb0\u0ccb\u0caa\u0cbf\u0caf\u0ca8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "EET",
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0caf\u0cc1\u0cb0\u0ccb\u0caa\u0cbf\u0caf\u0ca8\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "EEST",
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0caf\u0cc1\u0cb0\u0ccb\u0caa\u0cbf\u0caf\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "\u0ca8\u0ccd\u0caf\u0cc2\u0cab\u0ccc\u0c82\u0ca1\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "NST",
               "\u0ca8\u0ccd\u0caf\u0cc2\u0cab\u0ccc\u0c82\u0ca1\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd \u0ca6\u0cbf\u0ca8\u0ca6 \u0cb8\u0cae\u0caf",
               "NDT",
               "\u0ca8\u0ccd\u0caf\u0cc2\u0cab\u0ccc\u0c82\u0ca1\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd \u0cb8\u0cae\u0caf",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "\u0c85\u0cab\u0c98\u0cbe\u0ca8\u0cbf\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8 \u0cb8\u0cae\u0caf",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "\u0cb9\u0cbe\u0c82\u0c97\u0ccd \u0c95\u0cbe\u0c82\u0c97\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "HKT",
               "\u0cb9\u0cbe\u0c82\u0c97\u0ccd \u0c95\u0cbe\u0c82\u0c97\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "HKST",
               "\u0cb9\u0cbe\u0c82\u0c97\u0ccd \u0c95\u0cbe\u0c82\u0c97\u0ccd \u0cb8\u0cae\u0caf",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0c85\u0cb0\u0ccd\u0c9c\u0cc6\u0c82\u0c9f\u0cc0\u0ca8\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "ART",
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0c85\u0cb0\u0ccd\u0c9c\u0cc6\u0c82\u0c9f\u0cc0\u0ca8\u0cbe \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "ARST",
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0c85\u0cb0\u0ccd\u0c9c\u0cc6\u0c82\u0c9f\u0cc0\u0ca8\u0cbe \u0cb8\u0cae\u0caf",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "\u0c85\u0c9f\u0ccd\u0cb2\u0cbe\u0c82\u0c9f\u0cbf\u0c95\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "AST",
               "\u0c85\u0c9f\u0ccd\u0cb2\u0cbe\u0c82\u0c9f\u0cbf\u0c95\u0ccd \u0ca6\u0cbf\u0ca8\u0ca6 \u0cb8\u0cae\u0caf",
               "ADT",
               "\u0c85\u0c9f\u0ccd\u0cb2\u0cbe\u0c82\u0c9f\u0cbf\u0c95\u0ccd \u0cb8\u0cae\u0caf",
               "AT",
            };
        final String[] Ponape = new String[] {
               "\u0caa\u0cca\u0ca8\u0cbe\u0caa\u0cc6 \u0cb8\u0cae\u0caf",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "\u0cac\u0cca\u0cb2\u0cbf\u0cb5\u0cbf\u0caf\u0cbe \u0cb8\u0cae\u0caf",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "\u0cb8\u0cc7\u0c82\u0c9f\u0ccd \u0caa\u0cbf\u0caf\u0cb0\u0ccd \u0cae\u0ca4\u0ccd\u0ca4\u0cc1 \u0cae\u0cbf\u0c95\u0ccd\u0cb5\u0cc6\u0cb2\u0ca8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "PMST",
               "\u0cb8\u0cc7\u0c82\u0c9f\u0ccd \u0caa\u0cbf\u0caf\u0cb0\u0ccd \u0cae\u0ca4\u0ccd\u0ca4\u0cc1 \u0cae\u0cbf\u0c95\u0ccd\u0cb5\u0cc6\u0cb2\u0ca8\u0ccd \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "PMDT",
               "\u0cb8\u0cc7\u0c82\u0c9f\u0ccd \u0caa\u0cbf\u0caf\u0cb0\u0ccd \u0cae\u0ca4\u0ccd\u0ca4\u0cc1 \u0cae\u0cbf\u0c95\u0ccd\u0cb5\u0cc6\u0cb2\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "\u0c87\u0c82\u0ca1\u0cca\u0c9a\u0cc8\u0ca8\u0cbe \u0cb8\u0cae\u0caf",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u0caf\u0cc7\u0c95\u0c9f\u0cb0\u0cbf\u0ca8\u0ccd\u200c\u0cac\u0cb0\u0ccd\u0c97\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "YEKT",
               "\u0caf\u0cc7\u0c95\u0cc7\u0c9f\u0cb0\u0cbf\u0ca8\u0ccd\u200d\u0cac\u0cb0\u0ccd\u0c97\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "YEKST",
               "\u0caf\u0cc7\u0c95\u0c9f\u0cb0\u0cbf\u0ca8\u0ccd\u200c\u0cac\u0cb0\u0ccd\u0c97\u0ccd \u0cb8\u0cae\u0caf",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "\u0cae\u0cbe\u0cb2\u0ccd\u0ca1\u0cc0\u0cb5\u0ccd\u0cb8\u0ccd \u0cb8\u0cae\u0caf",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "\u0ca4\u0cbe\u0cb9\u0cbf\u0ca4\u0cbf \u0cb8\u0cae\u0caf",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "\u0c87\u0cb8\u0ccd\u0cb0\u0cc7\u0cb2\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "IST",
               "\u0c87\u0cb8\u0ccd\u0cb0\u0cc7\u0cb2\u0ccd \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "IDT",
               "\u0c87\u0cb8\u0ccd\u0cb0\u0cc7\u0cb2\u0ccd \u0cb8\u0cae\u0caf",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u0cae\u0ca7\u0ccd\u0caf \u0c87\u0c82\u0ca1\u0ccb\u0ca8\u0cc7\u0cb7\u0cbf\u0caf\u0cbe \u0cb8\u0cae\u0caf",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "\u0cb5\u0ccd\u0caf\u0cbe\u0cb2\u0cc0\u0cb8\u0ccd \u0cae\u0ca4\u0ccd\u0ca4\u0cc1 \u0cab\u0ccd\u0caf\u0cc1\u0c9f\u0cc1\u0ca8\u0cbe \u0cb8\u0cae\u0caf",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "\u0ca6\u0c95\u0ccd\u0cb7\u0cbf\u0ca3 \u0c86\u0cab\u0ccd\u0cb0\u0cbf\u0c95\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "\u0cb8\u0ccd\u0caf\u0cca\u0cb5\u0cbe \u0cb8\u0cae\u0caf",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "\u0cb2\u0cc8\u0ca8\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3 \u0cb8\u0cae\u0caf",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "\u0c89\u0c9c\u0ccd\u0cac\u0cc7\u0c95\u0cbf\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "UZT",
               "\u0c89\u0c9c\u0ccd\u0cac\u0cc7\u0c95\u0cbf\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "UZST",
               "\u0c89\u0c9c\u0ccd\u0cac\u0cc7\u0c95\u0cbf\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "\u0c92\u0cae\u0cbe\u0cb8\u0ccd\u0c95\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "OMST",
               "\u0c92\u0cae\u0cbe\u0cb8\u0ccd\u0c95\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "OMSST",
               "\u0c92\u0cae\u0cbe\u0cb8\u0ccd\u0c95\u0ccd \u0cb8\u0cae\u0caf",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "\u0cb8\u0cc0\u0cb7\u0cc6\u0cb2\u0ccd\u0cb8\u0ccd \u0cb8\u0cae\u0caf",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "\u0c89\u0cb0\u0cc1\u0c97\u0ccd\u0cb5\u0cc7 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "UYT",
               "\u0c89\u0cb0\u0cc1\u0c97\u0ccd\u0cb5\u0cc7 \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "UYST",
               "\u0c89\u0cb0\u0cc1\u0c97\u0ccd\u0cb5\u0cc7 \u0cb8\u0cae\u0caf",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "\u0ca8\u0cc7\u0caa\u0cbe\u0cb3 \u0cb8\u0cae\u0caf",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "\u0c89\u0cb2\u0ca8\u0ccd \u0cac\u0ccd\u0caf\u0cbe\u0c9f\u0cb0\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "ULAT",
               "\u0c89\u0cb2\u0ca8\u0ccd \u0cac\u0ccd\u0caf\u0cbe\u0c9f\u0cb0\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "ULAST",
               "\u0c89\u0cb2\u0ca8\u0ccd \u0cac\u0ccd\u0caf\u0cbe\u0c9f\u0cb0\u0ccd \u0cb8\u0cae\u0caf",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "\u0c89\u0ca4\u0ccd\u0ca4\u0cb0 \u0c85\u0cae\u0cc6\u0cb0\u0cbf\u0c95\u0ca6 \u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "CST",
               "\u0c89\u0ca4\u0ccd\u0ca4\u0cb0 \u0c85\u0cae\u0cc6\u0cb0\u0cbf\u0c95\u0ca6 \u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0\u0cc0\u0caf \u0ca6\u0cbf\u0ca8\u0ca6 \u0cb8\u0cae\u0caf",
               "CDT",
               "\u0c89\u0ca4\u0ccd\u0ca4\u0cb0 \u0c85\u0cae\u0cc6\u0cb0\u0cbf\u0c95\u0ca6 \u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0cb8\u0cae\u0caf",
               "CT",
            };
        final String[] Truk = new String[] {
               "\u0c9a\u0cc1\u0c95\u0ccd \u0cb8\u0cae\u0caf",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "\u0ca8\u0cbf\u0caf\u0cc1 \u0cb8\u0cae\u0caf",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "\u0cb5\u0cc7\u0c95\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa \u0cb8\u0cae\u0caf",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "\u0cab\u0cbe\u0cb2\u0ccd\u0c95\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "FKT",
               "\u0cab\u0cbe\u0cb2\u0ccd\u0c95\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3 \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "FKST",
               "\u0cab\u0cbe\u0cb2\u0ccd\u0c95\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3 \u0cb8\u0cae\u0caf",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "\u0cb5\u0ca8\u0ccc\u0ca4\u0cc1 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "VUT",
               "\u0cb5\u0ca8\u0ccc\u0ca4\u0cc1 \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "VUST",
               "\u0cb5\u0ca8\u0ccc\u0ca4\u0cc1 \u0cb8\u0cae\u0caf",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "\u0ca8\u0cca\u0cb5\u0cca\u0cb8\u0cbf\u0cac\u0cbf\u0cb8\u0ccd\u0c95\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "NOVT",
               "\u0ca8\u0cca\u0cb5\u0cca\u0cb8\u0cbf\u0cac\u0cbf\u0cb0\u0ccd\u200c\u0cb8\u0ccd\u0c95\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "NOVST",
               "\u0ca8\u0cca\u0cb5\u0cca\u0cb8\u0cbf\u0cac\u0cbf\u0cb0\u0ccd\u200c\u0cb8\u0ccd\u0c95\u0ccd \u0cb8\u0cae\u0caf",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "\u0cb8\u0cbf\u0c82\u0c97\u0cbe\u0caa\u0cc1\u0cb0\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "\u0c85\u0c9c\u0ccb\u0cb0\u0cb8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "AZOT",
               "\u0c85\u0c9c\u0ccb\u0cb0\u0cb8\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "AZOST",
               "\u0c85\u0c9c\u0ccb\u0cb0\u0cb8\u0ccd \u0cb8\u0cae\u0caf",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "\u0c85\u0caa\u0cbf\u0caf\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "WSST",
               "\u0c85\u0caa\u0cbf\u0caf\u0cbe \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "WSDT",
               "\u0c85\u0caa\u0cbf\u0caf\u0cbe \u0cb8\u0cae\u0caf",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "\u0cad\u0cc2\u0ca4\u0cbe\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "\u0cb8\u0cc1\u0cb0\u0cbf\u0ca8\u0cc7\u0cae\u0ccd \u0cb8\u0cae\u0caf",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "\u0ca8\u0ccc\u0cb0\u0cc1 \u0cb8\u0cae\u0caf",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u0c95\u0ccd\u0cb0\u0cbe\u0cb8\u0ccd\u200c\u0ca8\u0cca\u0caf\u0cbe\u0cb0\u0ccd\u0cb8\u0ccd\u0c95\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "KRAT",
               "\u0c95\u0ccd\u0cb0\u0cbe\u0cb8\u0ccd\u200c\u0ca8\u0cca\u0caf\u0cbe\u0cb0\u0ccd\u0cb8\u0ccd\u0c95\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "KRAST",
               "\u0c95\u0ccd\u0cb0\u0cbe\u0cb8\u0ccd\u200c\u0ca8\u0cca\u0caf\u0cbe\u0cb0\u0ccd\u0cb8\u0ccd\u0c95\u0ccd \u0cb8\u0cae\u0caf",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0c95\u0c9c\u0c95\u0cbf\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "\u0cae\u0ccd\u0caf\u0cbe\u0ca8\u0ccd\u0cae\u0cbe\u0cb0\u0ccd \u0cb8\u0cae\u0caf",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "\u0c95\u0ccd\u0cb0\u0cbf\u0cb8\u0ccd\u0cae\u0cb8\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa \u0cb8\u0cae\u0caf",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "\u0c85\u0cae\u0cc6\u0c9c\u0cbe\u0ca8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "AMT",
               "\u0c85\u0cae\u0cc6\u0c9c\u0cbe\u0ca8\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "AMST",
               "\u0c85\u0cae\u0cc6\u0c9c\u0cbe\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0c95\u0c9c\u0c95\u0cbf\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "\u0cab\u0cbf\u0c9c\u0cbf \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "FJT",
               "\u0cab\u0cbf\u0c9c\u0cbf \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "FJST",
               "\u0cab\u0cbf\u0c9c\u0cbf \u0cb8\u0cae\u0caf",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "\u0cb0\u0cbf\u0caf\u0cc2\u0ca8\u0cbf\u0caf\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "\u0c95\u0ccb\u0c95\u0ccb\u0cb8\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3 \u0cb8\u0cae\u0caf",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "\u0c9a\u0ca5\u0cbe\u0cae\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "CHAST",
               "\u0c9a\u0ca5\u0cbe\u0cae\u0ccd \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "CHADT",
               "\u0c9a\u0ca5\u0cbe\u0cae\u0ccd \u0cb8\u0cae\u0caf",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "\u0cb5\u0ccb\u0cb8\u0ccd\u0c9f\u0cca\u0c95\u0ccd \u0cb8\u0cae\u0caf",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "\u0c85\u0cb0\u0ccd\u0c9c\u0cc6\u0c82\u0c9f\u0cc0\u0ca8\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "ART",
               "\u0c85\u0cb0\u0ccd\u0c9c\u0cc6\u0c82\u0c9f\u0cbf\u0ca8\u0cbe \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "ARST",
               "\u0c85\u0cb0\u0ccd\u0c9c\u0cc6\u0c82\u0c9f\u0cbf\u0ca8\u0cbe \u0cb8\u0cae\u0caf",
               "ART",
            };
        final String[] Gambier = new String[] {
               "\u0c97\u0ccd\u0caf\u0cbe\u0c82\u0cac\u0cbf\u0caf\u0cb0\u0ccd \u0cb8\u0cae\u0caf",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "\u0caa\u0cc6\u0ca4\u0ccd\u0cb0\u0ccb\u0caa\u0cbe\u0cb5\u0ccd\u0cb2\u0ccb\u0cb8\u0ccd\u0c95\u0ccd\u200c\u200c-\u0c95\u0cae\u0ccd\u0c9a\u0ca4\u0ccd\u0cb8\u0ccd\u200c\u0c95\u0cc0 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "PETT",
               "\u0caa\u0cc6\u0ca4\u0ccd\u0cb0\u0ccb\u0caa\u0cbe\u0cb5\u0ccd\u0cb2\u0ccb\u0cb8\u0ccd\u0c95\u0ccd\u200c\u200c-\u0c95\u0cae\u0ccd\u0c9a\u0ca4\u0ccd\u0cb8\u0ccd\u200c\u0c95\u0cc0 \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "PETST",
               "\u0caa\u0cc6\u0ca4\u0ccd\u0cb0\u0ccb\u0caa\u0cbe\u0cb5\u0ccd\u0cb2\u0ccb\u0cb8\u0ccd\u0c95\u0ccd\u200c\u200c-\u0c95\u0cae\u0ccd\u0c9a\u0ca4\u0ccd\u0cb8\u0ccd\u200c\u0c95\u0cc0 \u0cb8\u0cae\u0caf",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "\u0ca4\u0cc1\u0cb5\u0cbe\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "\u0c97\u0cbe\u0cb2\u0cbe\u0caa\u0cbe\u0c97\u0ccb\u0cb8\u0ccd \u0cb8\u0cae\u0caf",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "\u0cae\u0ccd\u0caf\u0cbe\u0c95\u0ccd\u200c\u0c95\u0ccd\u0caf\u0cc1\u0cb0\u0cc8 \u0ca6\u0ccd\u0cb5\u0cc0\u0caa \u0cb8\u0cae\u0caf",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "\u0cb5\u0cc6\u0ca8\u0cbf\u0c9c\u0cc1\u0cb5\u0cc6\u0cb2\u0cbe \u0cb8\u0cae\u0caf",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u0cb9\u0cb5\u0cbe\u0caf\u0cbf-\u0c85\u0cb2\u0ccd\u0caf\u0cc1\u0c9f\u0cbf\u0caf\u0ca8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "HAST",
               "\u0cb9\u0cb5\u0cbe\u0caf\u0cbf-\u0c85\u0cb2\u0ccd\u0caf\u0cc1\u0c9f\u0cbf\u0caf\u0ca8\u0ccd \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "HADT",
               "\u0cb9\u0cb5\u0cbe\u0caf\u0cbf-\u0c85\u0cb2\u0ccd\u0caf\u0cc1\u0c9f\u0cbf\u0caf\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "ACST",
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "ACDT",
               "\u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe \u0cb8\u0cae\u0caf",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "\u0c89\u0ca4\u0ccd\u0ca4\u0cb0 \u0c85\u0cae\u0cc6\u0cb0\u0cbf\u0c95\u0ca6 \u0caa\u0cc6\u0cb8\u0cbf\u0cab\u0cbf\u0c95\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "PST",
               "\u0c89\u0ca4\u0ccd\u0ca4\u0cb0 \u0c85\u0cae\u0cc6\u0cb0\u0cbf\u0c95\u0ca6 \u0caa\u0cc6\u0cb8\u0cbf\u0cab\u0cbf\u0c95\u0ccd \u0ca6\u0cbf\u0ca8\u0ca6 \u0cb8\u0cae\u0caf",
               "PDT",
               "\u0c89\u0ca4\u0ccd\u0ca4\u0cb0 \u0c85\u0cae\u0cc6\u0cb0\u0cbf\u0c95\u0ca6 \u0caa\u0cc6\u0cb8\u0cbf\u0cab\u0cbf\u0c95\u0ccd \u0cb8\u0cae\u0caf",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u0cab\u0cbf\u0ca8\u0cbf\u0c95\u0ccd\u0cb8\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3 \u0cb8\u0cae\u0caf",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "\u0ca4\u0cc1\u0cb0\u0ccd\u0c95\u0ccd\u200c\u0cae\u0cc7\u0ca8\u0cbf\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "TMT",
               "\u0ca4\u0cc1\u0cb0\u0ccd\u0c95\u0ccd\u200c\u0cae\u0cc7\u0ca8\u0cbf\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "TMST",
               "\u0ca4\u0cc1\u0cb0\u0ccd\u0c95\u0ccd\u200c\u0cae\u0cc7\u0ca8\u0cbf\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0caf\u0cc1\u0cb0\u0ccb\u0caa\u0cbf\u0caf\u0ca8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "WET",
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0caf\u0cc1\u0cb0\u0ccb\u0caa\u0cbf\u0caf\u0ca8\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "WEST",
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0caf\u0cc1\u0cb0\u0ccb\u0caa\u0cbf\u0caf\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "\u0c95\u0cc7\u0caa\u0ccd \u0cb5\u0cb0\u0ccd\u0ca1\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "CVT",
               "\u0c95\u0cc7\u0caa\u0ccd \u0cb5\u0cb0\u0ccd\u0ca1\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "CVST",
               "\u0c95\u0cc7\u0caa\u0ccd \u0cb5\u0cb0\u0ccd\u0ca1\u0ccd \u0cb8\u0cae\u0caf",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "\u0ca8\u0cbe\u0cb0\u0ccd\u0cab\u0ccb\u0c95\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa \u0cb8\u0cae\u0caf",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "\u0c97\u0caf\u0cbe\u0ca8\u0cbe \u0cb8\u0cae\u0caf",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "\u0caa\u0cbf\u0c9f\u0ccd\u200c\u0c95\u0cc8\u0cb0\u0ccd\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "\u0cb0\u0cca\u0ca4\u0cc7\u0cb0\u0cbe \u0cb8\u0cae\u0caf",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "\u0cb8\u0cae\u0ccb\u0cb5\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "SST",
               "\u0cb8\u0cae\u0ccb\u0cb5\u0cbe \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "SDT",
               "\u0cb8\u0cae\u0ccb\u0cb5\u0cbe \u0cb8\u0cae\u0caf",
               "ST",
            };
        final String[] Palau = new String[] {
               "\u0caa\u0cbe\u0cb2\u0cbe\u0cb5\u0ccd \u0cb8\u0cae\u0caf",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "\u0cae\u0ca4\u0ccd\u0ca4\u0cb7\u0ccd\u0c9f\u0cc1-\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0caf\u0cc1\u0cb0\u0ccb\u0caa\u0cbf\u0caf\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "\u0c85\u0c9c\u0cb0\u0ccd\u0cac\u0cc8\u0c9c\u0cbe\u0ca8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "AZT",
               "\u0c85\u0c9c\u0cb0\u0ccd\u0cac\u0cc8\u0c9c\u0cbe\u0ca8\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "AZST",
               "\u0c85\u0c9c\u0cb0\u0ccd\u0cac\u0cc8\u0c9c\u0cbe\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "\u0cae\u0cbe\u0cb5\u0ccd\u200c\u0cb8\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "\u0cae\u0cc6\u0c95\u0ccd\u0cb8\u0cbf\u0c95\u0ca8\u0ccd \u0caa\u0cc6\u0cb8\u0cbf\u0cab\u0cbf\u0c95\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "MST",
               "\u0cae\u0cc6\u0c95\u0ccd\u0cb8\u0cbf\u0c95\u0ca8\u0ccd \u0caa\u0cc6\u0cb8\u0cbf\u0cab\u0cbf\u0c95\u0ccd \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "MDT",
               "\u0cae\u0cc6\u0c95\u0ccd\u0cb8\u0cbf\u0c95\u0ca8\u0ccd \u0caa\u0cc6\u0cb8\u0cbf\u0cab\u0cbf\u0c95\u0ccd \u0cb8\u0cae\u0caf",
               "MT",
            };
        final String[] Davis = new String[] {
               "\u0ca1\u0cc7\u0cb5\u0cbf\u0cb8\u0ccd \u0cb8\u0cae\u0caf",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "\u0c95\u0ccd\u0caf\u0cc2\u0cac\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "CST",
               "\u0c95\u0ccd\u0caf\u0cc2\u0cac\u0cbe \u0ca6\u0cbf\u0ca8\u0ca6 \u0cb8\u0cae\u0caf",
               "CDT",
               "\u0c95\u0ccd\u0caf\u0cc2\u0cac\u0cbe \u0cb8\u0cae\u0caf",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0c86\u0cab\u0ccd\u0cb0\u0cbf\u0c95\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "CAT",
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0c86\u0cab\u0ccd\u0cb0\u0cbf\u0c95\u0cbe \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "CAST",
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0c86\u0cab\u0ccd\u0cb0\u0cbf\u0c95\u0cbe \u0cb8\u0cae\u0caf",
               "CAT",
            };
        final String[] GMT = new String[] {
               "\u0c97\u0ccd\u0cb0\u0cc0\u0ca8\u0ccd\u200c\u0cb5\u0cbf\u0c9a\u0ccd \u0cb8\u0cb0\u0cbe\u0cb8\u0cb0\u0cbf \u0c95\u0cbe\u0cb2\u0cae\u0cbe\u0ca8",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "\u0cab\u0cbf\u0cb2\u0cbf\u0cab\u0cc8\u0ca8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "PHT",
               "\u0cab\u0cbf\u0cb2\u0cbf\u0cab\u0cc8\u0ca8\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "PHST",
               "\u0cab\u0cbf\u0cb2\u0cbf\u0cab\u0cc8\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "\u0ca6\u0c95\u0ccd\u0cb7\u0cbf\u0ca3 \u0cab\u0ccd\u0cb0\u0cc6\u0c82\u0c9a\u0ccd \u0cae\u0ca4\u0ccd\u0ca4\u0cc1 \u0c85\u0c82\u0c9f\u0cbe\u0cb0\u0ccd\u0c9f\u0cbf\u0c95\u0cbe \u0cb8\u0cae\u0caf",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "\u0ca6\u0c95\u0ccd\u0cb7\u0cbf\u0ca3 \u0c9c\u0cbe\u0cb0\u0ccd\u0c9c\u0cbf\u0caf\u0cbe \u0cb8\u0cae\u0caf",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "\u0cb9\u0cca\u0cb8 \u0c95\u0ccd\u0caf\u0cbe\u0cb2\u0cc6\u0ca1\u0ccb\u0ca8\u0cbf\u0caf\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "NCT",
               "\u0cb9\u0cca\u0cb8 \u0c95\u0ccd\u0caf\u0cbe\u0cb2\u0cc6\u0ca1\u0ccb\u0ca8\u0cbf\u0caf\u0cbe \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6\u0caf \u0cb8\u0cae\u0caf",
               "NCST",
               "\u0cb9\u0cca\u0cb8 \u0c95\u0ccd\u0caf\u0cbe\u0cb2\u0cc6\u0ca1\u0ccb\u0ca8\u0cbf\u0caf\u0cbe \u0cb8\u0cae\u0caf",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "\u0cac\u0ccd\u0cb0\u0cc2\u0ca8\u0cbf \u0ca6\u0cbe\u0cb0\u0cc1\u0cb8\u0cb2\u0cc6\u0cae\u0ccd \u0cb8\u0cae\u0caf",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "\u0c87\u0cb0\u0cbe\u0ca8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "IRST",
               "\u0c87\u0cb0\u0cbe\u0ca8\u0ccd \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "IRDT",
               "\u0c87\u0cb0\u0cbe\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "IRT",
            };
        final String[] Easter = new String[] {
               "\u0c88\u0cb8\u0ccd\u0c9f\u0cb0\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "EAST",
               "\u0c88\u0cb8\u0ccd\u0c9f\u0cb0\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "EASST",
               "\u0c88\u0cb8\u0ccd\u0c9f\u0cb0\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa \u0cb8\u0cae\u0caf",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "\u0cb5\u0cbe\u0caf\u0cb5\u0ccd\u0caf \u0cae\u0cc6\u0c95\u0ccd\u0cb8\u0cbf\u0c95\u0cca \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "PST",
               "\u0cb5\u0cbe\u0caf\u0cb5\u0ccd\u0caf \u0cae\u0cc6\u0c95\u0ccd\u0cb8\u0cbf\u0c95\u0cca \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "PDT",
               "\u0cb5\u0cbe\u0caf\u0cb5\u0ccd\u0caf \u0cae\u0cc6\u0c95\u0ccd\u0cb8\u0cbf\u0c95\u0cca \u0cb8\u0cae\u0caf",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "\u0ca1\u0cc1\u0cae\u0c82\u0c9f\u0ccd-\u0ca1\u0cbf \u0c89\u0cb0\u0ccd\u0cb5\u0cbf\u0cb2\u0cc6 \u0cb8\u0cae\u0caf",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "\u0ca4\u0c9d\u0c95\u0cbf\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "\u0c9f\u0cca\u0c82\u0c97\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "TOT",
               "\u0c9f\u0cca\u0c82\u0c97\u0cbe \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "TOST",
               "\u0c9f\u0cca\u0c82\u0c97\u0cbe \u0cb8\u0cae\u0caf",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "\u0cac\u0cbe\u0c82\u0c97\u0ccd\u0cb2\u0cbe\u0ca6\u0cc7\u0cb6 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "BDT",
               "\u0cac\u0cbe\u0c82\u0c97\u0ccd\u0cb2\u0cbe\u0ca6\u0cc7\u0cb6 \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "BDST",
               "\u0cac\u0cbe\u0c82\u0c97\u0ccd\u0cb2\u0cbe\u0ca6\u0cc7\u0cb6 \u0cb8\u0cae\u0caf",
               "BDT",
            };
        final String[] Peru = new String[] {
               "\u0caa\u0cc6\u0cb0\u0cc1 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "PET",
               "\u0caa\u0cc6\u0cb0\u0cc1 \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "PEST",
               "\u0caa\u0cc6\u0cb0\u0cc1 \u0cb8\u0cae\u0caf",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0c97\u0ccd\u0cb0\u0cc0\u0ca8\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "WGT",
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0c97\u0ccd\u0cb0\u0cc0\u0ca8\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "WGST",
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0c97\u0ccd\u0cb0\u0cc0\u0ca8\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd \u0cb8\u0cae\u0caf",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "\u0c88\u0c95\u0ccd\u0cb5\u0cc6\u0ca1\u0cbe\u0cb0\u0ccd \u0cb8\u0cae\u0caf",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0c97\u0ccd\u0cb0\u0cc0\u0ca8\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "EGT",
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0c97\u0ccd\u0cb0\u0cc0\u0ca8\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "EGST",
               "*\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0c97\u0ccd\u0cb0\u0cc0\u0ca8\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd \u0cb8\u0cae\u0caf",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "\u0c97\u0cb2\u0ccd\u0cab\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0c87\u0c82\u0ca1\u0ccb\u0ca8\u0cc7\u0cb7\u0cbf\u0caf\u0cbe \u0cb8\u0cae\u0caf",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "\u0c95\u0cca\u0cb0\u0cbf\u0caf\u0ca8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "KST",
               "\u0c95\u0cca\u0cb0\u0cbf\u0caf\u0ca8\u0ccd \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "KDT",
               "\u0c95\u0cca\u0cb0\u0cbf\u0caf\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "AWST",
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "AWDT",
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe \u0cb8\u0cae\u0caf",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "\u0c95\u0cbf\u0cb0\u0ccd\u0c97\u0cbf\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0c87\u0c82\u0ca1\u0ccb\u0ca8\u0cc7\u0cb7\u0cbf\u0caf \u0cb8\u0cae\u0caf",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "AEST",
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "AEDT",
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe \u0cb8\u0cae\u0caf",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "\u0cab\u0ccd\u0cb0\u0cc6\u0c82\u0c9a\u0ccd \u0c97\u0caf\u0cbe\u0ca8\u0cbe \u0cb8\u0cae\u0caf",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "\u0c95\u0cca\u0cb2\u0c82\u0cac\u0cbf\u0caf\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "COT",
               "\u0c95\u0cca\u0cb2\u0c82\u0cac\u0cbf\u0caf\u0cbe \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "COST",
               "\u0c95\u0cca\u0cb2\u0c82\u0cac\u0cbf\u0caf\u0cbe \u0cb8\u0cae\u0caf",
               "COT",
            };
        final String[] Chile = new String[] {
               "\u0c9a\u0cbf\u0cb2\u0cbf \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "CLT",
               "\u0c9a\u0cbf\u0cb2\u0cbf \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "CLST",
               "\u0c9a\u0cbf\u0cb2\u0cbf \u0cb8\u0cae\u0caf",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u0c97\u0cbf\u0cb2\u0ccd\u0cac\u0cb0\u0ccd\u0c9f\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3 \u0cb8\u0cae\u0caf",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "\u0c89\u0ca4\u0ccd\u0ca4\u0cb0 \u0c85\u0cae\u0cc6\u0cb0\u0cbf\u0c95\u0ca6 \u0caa\u0cb0\u0ccd\u0cb5\u0ca4 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "MST",
               "\u0c89\u0ca4\u0ccd\u0ca4\u0cb0 \u0c85\u0cae\u0cc6\u0cb0\u0cbf\u0c95\u0ca6 \u0caa\u0cb0\u0ccd\u0cb5\u0ca4 \u0ca6\u0cbf\u0ca8\u0ca6 \u0cb8\u0cae\u0caf",
               "MDT",
               "\u0c89\u0ca4\u0ccd\u0ca4\u0cb0 \u0c85\u0cae\u0cc6\u0cb0\u0cbf\u0c95\u0ca6 \u0caa\u0cb0\u0ccd\u0cb5\u0ca4 \u0cb8\u0cae\u0caf",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "\u0cae\u0cbe\u0cb0\u0ccd\u0c95\u0ccd\u0caf\u0cc1\u0cb8\u0cb8\u0ccd \u0cb8\u0cae\u0caf",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "\u0c85\u0cb0\u0cc7\u0cac\u0cbf\u0caf\u0ca8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "AST",
               "\u0c85\u0cb0\u0cc7\u0cac\u0cbf\u0caf\u0ca8\u0ccd \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "ADT",
               "\u0c85\u0cb0\u0cc7\u0cac\u0cbf\u0caf\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "AT",
            };
        final String[] Alaska = new String[] {
               "\u0c85\u0cb2\u0cb8\u0ccd\u0c95\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "AKST",
               "\u200c\u0c85\u0cb2\u0cbe\u0cb8\u0ccd\u0c95\u0cbe \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "AKDT",
               "\u0c85\u0cb2\u0cbe\u0cb8\u0ccd\u0c95\u0cbe \u0cb8\u0cae\u0caf",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "\u0cb5\u0ccd\u0cb2\u0cbe\u0ca1\u0cbf\u0cb5\u0ccb\u0cb8\u0ccd\u0c9f\u0ccb\u0c95\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "VLAT",
               "\u0cb5\u0ccd\u0cb2\u0cbe\u0ca1\u0cbf\u0cb5\u0ccb\u0cb8\u0ccd\u0c9f\u0ccb\u0c95\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "VLAST",
               "\u0cb5\u0ccd\u0cb2\u0cbe\u0ca1\u0cbf\u0cb5\u0ccb\u0cb8\u0ccd\u0c9f\u0ccb\u0c95\u0ccd \u0cb8\u0cae\u0caf",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "\u0c9a\u0cae\u0ccb\u0cb0\u0ccb \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "\u0c87\u0cb0\u0ccd\u200c\u0c95\u0cc1\u0c9f\u0cb8\u0ccd\u0c95\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "IRKT",
               "\u0c87\u0cb0\u0ccd\u200c\u0c95\u0cc1\u0c9f\u0cb8\u0ccd\u0c95\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "IRKST",
               "\u0c87\u0cb0\u0ccd\u200c\u0c95\u0cc1\u0c9f\u0cb8\u0ccd\u0c95\u0ccd \u0cb8\u0cae\u0caf",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "\u0c9c\u0cbe\u0cb0\u0ccd\u0c9c\u0cbf\u0caf\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "GET",
               "\u0c9c\u0cbe\u0cb0\u0ccd\u0c9c\u0cbf\u0caf\u0cbe \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "GEST",
               "\u0c9c\u0cbe\u0cb0\u0ccd\u0c9c\u0cbf\u0caf\u0cbe \u0cb8\u0cae\u0caf",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "\u0c9f\u0cca\u0c95\u0cc6\u0cb2\u0cbe\u0cb5\u0ccd \u0cb8\u0cae\u0caf",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u0caa\u0caa\u0cc1\u0cb5\u0cbe \u0ca8\u0ccd\u0caf\u0cc2 \u0c97\u0cbf\u0ca8\u0cbf\u0caf\u0cbe \u0cb8\u0cae\u0caf",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "\u0cab\u0cc6\u0cb0\u0ccd\u0ca8\u0cbe\u0c82\u0ca1\u0ccb \u0ca1\u0cc6 \u0ca8\u0cca\u0cb0\u0cca\u0ca8\u0ccd\u0cb9\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "FNT",
               "\u0cab\u0cb0\u0ccd\u0ca8\u0cbe\u0c82\u0ca1\u0ccb \u0ca6\u0cc6 \u0ca8\u0cca\u0cb0\u0cca\u0ca8\u0ccd\u0cb9\u0cbe \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "FNST",
               "\u0cab\u0cc6\u0cb0\u0ccd\u0ca8\u0cbe\u0c82\u0ca1\u0ccb \u0ca1\u0cc6 \u0ca8\u0cca\u0cb0\u0cca\u0ca8\u0ccd\u0cb9\u0cbe \u0cb8\u0cae\u0caf",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u0c9a\u0cca\u0caf\u0ccd\u200c\u200c\u0cac\u0cb2\u0ccd\u0cb8\u0cbe\u0ca8\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "CHOT",
               "\u0c9a\u0cca\u0caf\u0ccd\u200c\u0cac\u0cb2\u0ccd\u0cb8\u0cbe\u0ca8\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "CHOST",
               "\u0c9a\u0cca\u0caf\u0ccd\u200c\u0cac\u0cb2\u0ccd\u0cb8\u0cbe\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "\u0cac\u0ccd\u0cb0\u0cc6\u0cb8\u0cbf\u0cb2\u0cbf\u0caf\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "BRT",
               "\u0cac\u0ccd\u0cb0\u0cc6\u0cb8\u0cbf\u0cb2\u0cbf\u0caf\u0cbe \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "BRST",
               "\u0cac\u0ccd\u0cb0\u0cc6\u0cb8\u0cbf\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0cb8\u0cae\u0caf",
               "BRT",
            };
        final String[] China = new String[] {
               "\u0c9a\u0cc0\u0ca8\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "CST",
               "\u0c9a\u0cc0\u0ca8\u0cbe \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "CDT",
               "\u0c9a\u0cc0\u0ca8\u0cbe \u0cb8\u0cae\u0caf",
               "CT",
            };
        final String[] Armenia = new String[] {
               "\u0c85\u0cb0\u0ccd\u0cae\u0cc7\u0ca8\u0cbf\u0caf \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "AMT",
               "\u0c85\u0cb0\u0ccd\u0cae\u0cc7\u0ca8\u0cbf\u0caf \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "AMST",
               "\u0c85\u0cb0\u0ccd\u0cae\u0cc7\u0ca8\u0cbf\u0caf \u0cb8\u0cae\u0caf",
               "AMT",
            };
        final String[] Samara = new String[] {
               "\u0cb8\u0cae\u0cb0 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "SAMT",
               "\u0cb8\u0cae\u0cb0 \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "SAMST",
               "\u0cb8\u0cae\u0cb0 \u0cb8\u0cae\u0caf",
               "SAMT",
            };
        final String[] India = new String[] {
               "\u0cad\u0cbe\u0cb0\u0ca4\u0cc0\u0caf \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "\u0c95\u0cc1\u0c95\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "CKT",
               "\u0c95\u0cc1\u0c95\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3 \u0cae\u0ca7\u0ccd\u0caf\u0c95\u0cbe\u0cb2\u0cc0\u0ca8 \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "CKHST",
               "\u0c95\u0cc1\u0c95\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3 \u0cb8\u0cae\u0caf",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "\u0c97\u0ccd\u0cb0\u0cc0\u0ca8\u0ccd\u200c\u0cb5\u0cbf\u0c9a\u0ccd \u0cb8\u0cb0\u0cbe\u0cb8\u0cb0\u0cbf \u0c95\u0cbe\u0cb2\u0cae\u0cbe\u0ca8",
                    "GMT",
                    "\u0cac\u0ccd\u0cb0\u0cbf\u0c9f\u0cbf\u0cb7\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "\u0c97\u0ccd\u0cb0\u0cc0\u0ca8\u0ccd\u200c\u0cb5\u0cbf\u0c9a\u0ccd \u0cb8\u0cb0\u0cbe\u0cb8\u0cb0\u0cbf \u0c95\u0cbe\u0cb2\u0cae\u0cbe\u0ca8",
                    "GMT",
                    "\u0c90\u0cb0\u0cbf\u0cb7\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
