/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.FinallyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.processor.TryProcessor;
import org.apache.camel.reifier.ProcessorReifier;

public class TryReifier
extends ProcessorReifier<TryDefinition> {
    public TryReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (TryDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Processor tryProcessor = this.createOutputsProcessor(((TryDefinition)this.definition).getOutputsWithoutCatches());
        if (tryProcessor == null) {
            throw new IllegalArgumentException("Definition has no children on " + String.valueOf(this));
        }
        ArrayList<Processor> catchProcessors = new ArrayList<Processor>();
        if (((TryDefinition)this.definition).getCatchClauses() != null) {
            for (CatchDefinition catchClause : ((TryDefinition)this.definition).getCatchClauses()) {
                catchProcessors.add(this.createProcessor((ProcessorDefinition<?>)catchClause));
            }
        }
        if (((TryDefinition)this.definition).getFinallyClause() == null && ((TryDefinition)this.definition).getCatchClauses() == null) {
            throw new IllegalArgumentException("doTry must have one or more catch or finally blocks on " + String.valueOf(this));
        }
        FinallyDefinition finallyDefinition = ((TryDefinition)this.definition).getFinallyClause();
        if (finallyDefinition == null) {
            finallyDefinition = new FinallyDefinition();
            finallyDefinition.setParent(this.definition);
        }
        Processor finallyProcessor = this.createProcessor((ProcessorDefinition<?>)finallyDefinition);
        TryProcessor answer = new TryProcessor(this.camelContext, tryProcessor, catchProcessors, finallyProcessor);
        answer.setDisabled(TryReifier.isDisabled(this.camelContext, (NamedNode)this.definition));
        return answer;
    }
}

