/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.util.Map;
import org.apache.activemq.transport.SocketConnectorFactory;
import org.apache.activemq.transport.TransportServerSupport;
import org.apache.activemq.util.InetAddressUtil;
import org.apache.activemq.util.IntrospectionSupport;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebTransportServerSupport
extends TransportServerSupport {
    private static final Logger LOG = LoggerFactory.getLogger(WebTransportServerSupport.class);
    protected URI bindAddress;
    protected Server server;
    protected Connector connector;
    protected SocketConnectorFactory socketConnectorFactory;
    protected String host;
    protected final HttpOptions httpOptions = new HttpOptions();
    protected final JettyOptions jettyOptions = new JettyOptions();

    public WebTransportServerSupport(URI location) {
        super(location);
    }

    private <T> void setConnectorProperty(String name, Class<T> type, T value) throws Exception {
        this.connector.getClass().getMethod("set" + name, type).invoke((Object)this.connector, value);
    }

    protected void createServer() {
        LOG.info("Starting Jetty server");
        if (this.jettyOptions.getConfig() != null) {
            try {
                LOG.info("Configuring Jetty server using {}", (Object)this.jettyOptions.getConfig());
                File file = new File(this.jettyOptions.getConfig());
                if (!file.exists()) {
                    throw new IllegalArgumentException("Jetty XML not found: " + file.getAbsolutePath());
                }
                XmlConfiguration xmlConfiguration = new XmlConfiguration(Resource.newResource((File)file));
                this.server = (Server)xmlConfiguration.configure();
            }
            catch (Throwable t) {
                throw new IllegalStateException("Jetty configuration can't be loaded", t);
            }
        } else {
            this.server = new Server();
        }
        try {
            this.server.getClass().getMethod("setStopTimeout", Long.TYPE).invoke((Object)this.server, 30000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public URI bind() throws Exception {
        URI bind = this.getBindLocation();
        String bindHost = bind.getHost();
        bindHost = bindHost == null || bindHost.length() == 0 ? "localhost" : bindHost;
        InetAddress addr = InetAddress.getByName(bindHost);
        this.host = addr.getCanonicalHostName();
        if (this.server.getConnectors().length == 0) {
            LOG.info("Creating Jetty connector");
            this.setConnectorProperty("Host", String.class, this.host);
            this.setConnectorProperty("Port", Integer.TYPE, this.bindAddress.getPort());
            this.server.addConnector(this.connector);
        } else {
            LOG.info("Using Jetty configured connector");
            this.connector = this.server.getConnectors()[0];
            for (Connector c : this.server.getConnectors()) {
                if (c.getName() == null || !c.getName().equalsIgnoreCase("activemq")) continue;
                this.connector = c;
            }
            this.setConnectorProperty("Host", String.class, this.host);
            this.setConnectorProperty("Port", Integer.TYPE, this.bindAddress.getPort());
            this.server.addConnector(this.connector);
        }
        if (addr.isAnyLocalAddress()) {
            this.host = InetAddressUtil.getLocalHostName();
        }
        URI boundUri = new URI(bind.getScheme(), bind.getUserInfo(), this.host, this.bindAddress.getPort(), bind.getPath(), bind.getQuery(), bind.getFragment());
        this.setConnectURI(boundUri);
        return boundUri;
    }

    protected void configureTraceMethod(ConstraintSecurityHandler securityHandler, boolean enableTrace) {
        Constraint constraint = new Constraint();
        constraint.setName("trace-security");
        constraint.setAuthenticate(!enableTrace);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setMethod("TRACE");
        mapping.setPathSpec("/");
        securityHandler.addConstraintMapping(mapping);
        constraint = new Constraint();
        constraint.setName("allow");
        mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setMethodOmissions(new String[]{"TRACE"});
        mapping.setPathSpec("/");
        securityHandler.addConstraintMapping(mapping);
    }

    public void setHttpOptions(Map<String, Object> options) {
        if (options != null) {
            IntrospectionSupport.setProperties(this.httpOptions, options);
        }
    }

    public void setJettyOptions(Map<String, Object> options) {
        if (options != null) {
            IntrospectionSupport.setProperties(this.jettyOptions, options);
        }
    }

    protected static class HttpOptions {
        private boolean enableTrace = false;

        protected HttpOptions() {
        }

        public boolean isEnableTrace() {
            return this.enableTrace;
        }

        public void setEnableTrace(boolean enableTrace) {
            this.enableTrace = enableTrace;
        }
    }

    protected static class JettyOptions {
        private String config;

        protected JettyOptions() {
        }

        public String getConfig() {
            return this.config;
        }

        public void setConfig(String config) {
            this.config = config;
        }
    }
}

