/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.console;

import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.CamelContext;
import org.apache.camel.model.BeanFactoryDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

@DevConsole(name="bean-model", description="Displays beans from the DSL model")
public class BeanModelDevConsole
extends AbstractDevConsole {
    public static final String FILTER = "filter";
    public static final String PROPERTIES = "properties";
    public static final String NULLS = "nulls";

    public BeanModelDevConsole() {
        super("camel", "bean-model", "Bean Model", "Displays beans from the DSL model");
    }

    protected String doCallText(Map<String, Object> options) {
        String filter = (String)options.get(FILTER);
        boolean properties = "true".equals(options.getOrDefault(PROPERTIES, "true"));
        boolean nulls = "true".equals(options.getOrDefault(NULLS, "true"));
        StringBuilder sb = new StringBuilder(256);
        BeanIntrospection bi = PluginHelper.getBeanIntrospection((CamelContext)this.getCamelContext());
        Model model = (Model)this.getCamelContext().getCamelContextExtension().getContextPlugin(Model.class);
        if (model != null) {
            for (BeanFactoryDefinition<?> b : model.getCustomBeans()) {
                String name = b.getName();
                if (!BeanModelDevConsole.accept(name, filter)) continue;
                TreeMap values = new TreeMap();
                Object target = this.getCamelContext().getRegistry().lookupByName(name);
                if (target != null && properties) {
                    try {
                        bi.getProperties(target, values, null);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                sb.append(String.format("    %s (%s)%n", b.getName(), b.getType()));
                if (properties && b.getProperties() != null) {
                    b.getProperties().forEach((k, v) -> {
                        Object rv = values.get(k);
                        if (rv == null) {
                            if (nulls) {
                                sb.append(String.format("        %s = null%n", k));
                            }
                        } else {
                            String type = rv.getClass().getName();
                            sb.append(String.format("        %s = %s (type:%s)%n", k, rv, type));
                        }
                    });
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        String filter = (String)options.get(FILTER);
        boolean properties = "true".equals(options.getOrDefault(PROPERTIES, "true"));
        boolean nulls = "true".equals(options.getOrDefault(NULLS, "true"));
        JsonObject root = new JsonObject();
        JsonObject jo = new JsonObject();
        root.put((Object)"beans", (Object)jo);
        BeanIntrospection bi = PluginHelper.getBeanIntrospection((CamelContext)this.getCamelContext());
        Model model = (Model)this.getCamelContext().getCamelContextExtension().getContextPlugin(Model.class);
        if (model != null) {
            for (BeanFactoryDefinition<?> b : model.getCustomBeans()) {
                String name = b.getName();
                if (!BeanModelDevConsole.accept(name, filter)) continue;
                TreeMap values = new TreeMap();
                Object target = this.getCamelContext().getRegistry().lookupByName(name);
                if (target != null && properties) {
                    try {
                        bi.getProperties(target, values, null);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                JsonObject jb = new JsonObject();
                jo.put((Object)b.getName(), (Object)jb);
                jb.put((Object)"name", (Object)b.getName());
                jb.put((Object)"type", (Object)b.getType());
                if (b.getInitMethod() != null) {
                    jb.put((Object)"initMethod", (Object)b.getInitMethod());
                }
                if (b.getDestroyMethod() != null) {
                    jb.put((Object)"destroyMethod", (Object)b.getDestroyMethod());
                }
                if (b.getBuilderClass() != null) {
                    jb.put((Object)"builderClass", (Object)b.getBuilderClass());
                }
                if (b.getBuilderMethod() != null) {
                    jb.put((Object)"builderMethod", (Object)b.getBuilderMethod());
                }
                if (b.getFactoryBean() != null) {
                    jb.put((Object)"factoryBean", (Object)b.getFactoryBean());
                }
                if (b.getFactoryMethod() != null) {
                    jb.put((Object)"factoryMethod", (Object)b.getFactoryMethod());
                }
                if (b.getProperties() == null) continue;
                JsonArray arr = new JsonArray();
                b.getProperties().forEach((k, v) -> {
                    boolean accept;
                    Object rv = values.get(k);
                    String type = rv != null ? rv.getClass().getName() : null;
                    JsonObject jp = new JsonObject();
                    jp.put((Object)"name", k);
                    if (type != null) {
                        jp.put((Object)"type", (Object)type);
                    }
                    jp.put((Object)"value", v);
                    boolean bl = accept = v != null || nulls;
                    if (accept) {
                        arr.add((Object)jp);
                    }
                });
                if (!arr.isEmpty()) {
                    jb.put((Object)"modelProperties", (Object)arr);
                }
                JsonArray arr2 = new JsonArray();
                b.getProperties().forEach((k, v) -> {
                    boolean accept;
                    String type;
                    Object rv;
                    Object value = rv = values.get(k);
                    String string = type = rv != null ? rv.getClass().getName() : null;
                    if (type != null) {
                        value = Jsoner.trySerialize(rv);
                        value = value == null ? Jsoner.escape((String)rv.toString()) : rv;
                    }
                    JsonObject jp = new JsonObject();
                    jp.put((Object)"name", k);
                    if (type != null) {
                        jp.put((Object)"type", (Object)type);
                    }
                    jp.put((Object)"value", value);
                    boolean bl = accept = value != null || nulls;
                    if (accept) {
                        arr2.add((Object)jp);
                    }
                });
                if (arr2.isEmpty()) continue;
                jb.put((Object)PROPERTIES, (Object)arr2);
            }
        }
        return root;
    }

    private static boolean accept(String name, String filter) {
        if (filter == null || filter.isBlank()) {
            return true;
        }
        return PatternHelper.matchPattern((String)name, (String)filter);
    }
}

