/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.locking;

public class TypeUtil {

    public static class Global {
        public static long build(int arenaId, int allocId, int localId) {
            long result = arenaId;
            result <<= 48;
            result |= (long)allocId << 32;
            return result |= (long)localId;
        }

        public static int arenaId(long l) {
            return (int)(l >>> 48 & 0xFFFFL);
        }

        public static int allocId(long l) {
            return (int)(l >>> 32 & 0xFFFFL);
        }

        public static int localId(long l) {
            return (int)(l & 0xFFFFFFFFL);
        }

        public static StringBuilder append(StringBuilder sb, long l) {
            sb.append(String.format("%1$x", Global.arenaId(l)));
            sb.append(':');
            sb.append(String.format("%1$x", Global.allocId(l)));
            sb.append(':');
            sb.append(String.format("%1$x", Global.localId(l)));
            return sb;
        }

        public static StringBuilder appendFixed(StringBuilder sb, long l) {
            sb.append(String.format("%1$4x", Global.arenaId(l)));
            sb.append(':');
            sb.append(String.format("%1$4x", Global.allocId(l)));
            sb.append(':');
            sb.append(String.format("%1$8x", Global.localId(l)));
            return sb;
        }

        public static String toString(long l) {
            return Global.append(new StringBuilder(), l).toString();
        }
    }

    public static class Int {
        public static StringBuilder append(StringBuilder sb, int i) {
            return sb.append(String.format("%1$x", i));
        }

        public static StringBuilder appendFixed(StringBuilder sb, int i) {
            return sb.append(String.format("%1$18x", i));
        }
    }

    public static class Short {
        public static StringBuilder append(StringBuilder sb, short s) {
            return sb.append(String.format("%1$x", s));
        }

        public static StringBuilder appendFixed(StringBuilder sb, short s) {
            return sb.append(String.format("%1$18x", s));
        }
    }

    public static class Byte {
        public static StringBuilder append(StringBuilder sb, byte b) {
            return sb.append(String.format("%1$x", b));
        }

        public static StringBuilder appendFixed(StringBuilder sb, byte b) {
            return sb.append(String.format("%1$18x", b));
        }
    }
}

