/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyCursorInitialState;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IIndexCursorStats;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.util.IndexCursorUtils;

public class LSMBuddyBTreeMergeCursor
extends LSMIndexSearchCursor {
    public LSMBuddyBTreeMergeCursor(ILSMIndexOperationContext opCtx, IIndexCursorStats stats) {
        super(opCtx, true, stats);
    }

    protected boolean isDeleted(LSMIndexSearchCursor.PriorityQueueElement checkElement) throws HyracksDataException {
        return false;
    }

    public void doOpen(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        LSMBTreeWithBuddyCursorInitialState lsmInitialState = (LSMBTreeWithBuddyCursorInitialState)initialState;
        this.cmp = lsmInitialState.getBuddyBTreeCmp();
        this.operationalComponents = lsmInitialState.getOperationalComponents();
        this.lsmHarness = null;
        int numBTrees = this.operationalComponents.size();
        this.rangeCursors = new IIndexCursor[numBTrees];
        RangePredicate btreePredicate = new RangePredicate(null, null, true, true, this.cmp, this.cmp);
        ITreeIndexAccessor[] btreeAccessors = new ITreeIndexAccessor[numBTrees];
        for (int i = 0; i < numBTrees; ++i) {
            ILSMComponent component = (ILSMComponent)this.operationalComponents.get(i);
            BTree buddyBtree = ((LSMBTreeWithBuddyDiskComponent)component).getBuddyIndex();
            btreeAccessors[i] = buddyBtree.createAccessor(this.iap);
            this.rangeCursors[i] = btreeAccessors[i].createSearchCursor(false);
        }
        IndexCursorUtils.open((IIndexAccessor[])btreeAccessors, (IIndexCursor[])this.rangeCursors, (ISearchPredicate)btreePredicate);
        try {
            this.setPriorityQueueComparator();
            this.initPriorityQueue();
        }
        catch (Throwable th) {
            IndexCursorUtils.close((IIndexCursor[])this.rangeCursors, (Throwable)th);
            throw HyracksDataException.create((Throwable)th);
        }
    }
}

