/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.ipc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.ipc.ExternalFunctionResultRouter;
import org.apache.asterix.external.ipc.MessageType;
import org.apache.asterix.external.ipc.PythonMessageBuilder;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.core.buffer.ArrayBufferInput;
import org.msgpack.core.buffer.MessageBufferInput;

public class PythonIPCProto {
    private PythonMessageBuilder messageBuilder;
    private OutputStream sockOut;
    private ByteBuffer headerBuffer = ByteBuffer.allocate(21);
    private ByteBuffer recvBuffer = ByteBuffer.allocate(32768);
    private ExternalFunctionResultRouter router;
    private long routeId;
    private Pair<ByteBuffer, Exception> bufferBox;
    private Process pythonProc;
    private long maxFunctionId;
    private ArrayBufferInput unpackerInput;
    private MessageUnpacker unpacker;

    public PythonIPCProto(OutputStream sockOut, ExternalFunctionResultRouter router, Process pythonProc) {
        this.sockOut = sockOut;
        this.messageBuilder = new PythonMessageBuilder();
        this.router = router;
        this.pythonProc = pythonProc;
        this.maxFunctionId = 0L;
        this.unpackerInput = new ArrayBufferInput(new byte[0]);
        this.unpacker = MessagePack.newDefaultUnpacker((MessageBufferInput)this.unpackerInput);
    }

    public void start() {
        Pair keyAndBufferBox = this.router.insertRoute(this.recvBuffer);
        this.routeId = (Long)keyAndBufferBox.getFirst();
        this.bufferBox = (Pair)keyAndBufferBox.getSecond();
    }

    public void helo() throws IOException, AsterixException {
        this.recvBuffer.clear();
        this.recvBuffer.position(0);
        this.recvBuffer.limit(0);
        this.messageBuilder.buf.clear();
        this.messageBuilder.buf.position(0);
        this.messageBuilder.hello();
        this.sendMsg(this.routeId);
        this.receiveMsg();
        if (this.getResponseType() != MessageType.HELO) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{"Expected HELO, recieved " + this.getResponseType().name()});
        }
    }

    public long init(String module, String clazz, String fn) throws IOException, AsterixException {
        long functionId = this.maxFunctionId++;
        this.recvBuffer.clear();
        this.recvBuffer.position(0);
        this.recvBuffer.limit(0);
        this.messageBuilder.buf.clear();
        this.messageBuilder.buf.position(0);
        this.messageBuilder.init(module, clazz, fn);
        this.sendMsg(functionId);
        this.receiveMsg();
        if (this.getResponseType() != MessageType.INIT_RSP) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{"Expected INIT_RSP, recieved " + this.getResponseType().name()});
        }
        return functionId;
    }

    public ByteBuffer call(long functionId, ByteBuffer args, int numArgs) throws IOException, AsterixException {
        this.recvBuffer.clear();
        this.recvBuffer.position(0);
        this.recvBuffer.limit(0);
        this.messageBuilder.buf.clear();
        this.messageBuilder.buf.position(0);
        this.messageBuilder.call(args.array(), args.position(), numArgs);
        this.sendMsg(functionId);
        this.receiveMsg();
        if (this.getResponseType() != MessageType.CALL_RSP) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{"Expected CALL_RSP, recieved " + this.getResponseType().name()});
        }
        return this.recvBuffer;
    }

    public ByteBuffer callMulti(long key, ByteBuffer args, int numTuples) throws IOException, AsterixException {
        this.recvBuffer.clear();
        this.recvBuffer.position(0);
        this.recvBuffer.limit(0);
        this.messageBuilder.buf.clear();
        this.messageBuilder.buf.position(0);
        this.messageBuilder.callMulti(args.array(), args.position(), numTuples);
        this.sendMsg(key);
        this.receiveMsg();
        if (this.getResponseType() != MessageType.CALL_RSP) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{"Expected CALL_RSP, recieved " + this.getResponseType().name()});
        }
        return this.recvBuffer;
    }

    public void quit() throws HyracksDataException {
        this.messageBuilder.quit();
        this.router.removeRoute(Long.valueOf(this.routeId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMsg() throws IOException, AsterixException {
        Exception except = null;
        try {
            Pair<ByteBuffer, Exception> pair = this.bufferBox;
            synchronized (pair) {
                while ((((ByteBuffer)this.bufferBox.getFirst()).limit() == 0 || this.bufferBox.getSecond() != null) && this.pythonProc.isAlive()) {
                    this.bufferBox.wait(100L);
                }
            }
            except = this.router.getAndRemoveException(Long.valueOf(this.routeId));
            if (!this.pythonProc.isAlive()) {
                except = new IOException("Python process exited with code: " + this.pythonProc.exitValue());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.EXTERNAL_UDF_EXCEPTION, (Throwable)e, new Serializable[0]);
        }
        if (except != null) {
            throw new AsterixException((Throwable)except);
        }
        if (this.bufferBox.getFirst() != this.recvBuffer) {
            this.recvBuffer = (ByteBuffer)this.bufferBox.getFirst();
        }
        this.messageBuilder.readHead(this.recvBuffer);
        if (this.messageBuilder.type == MessageType.ERROR) {
            this.unpackerInput.reset(this.recvBuffer.array(), this.recvBuffer.position() + this.recvBuffer.arrayOffset(), this.recvBuffer.remaining());
            this.unpacker.reset((MessageBufferInput)this.unpackerInput);
            throw new AsterixException(this.unpacker.unpackString());
        }
    }

    public void sendMsg(long key) throws IOException {
        this.headerBuffer.clear();
        this.headerBuffer.position(0);
        this.headerBuffer.putInt(21 + this.messageBuilder.buf.position());
        this.headerBuffer.putLong(key);
        this.headerBuffer.putLong(this.routeId);
        this.headerBuffer.put((byte)0);
        this.sockOut.write(this.headerBuffer.array(), 0, 21);
        this.sockOut.write(this.messageBuilder.buf.array(), 0, this.messageBuilder.buf.position());
        this.sockOut.flush();
    }

    public MessageType getResponseType() {
        return this.messageBuilder.type;
    }

    public long getRouteId() {
        return this.routeId;
    }
}

