/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class FrameStack
implements Closeable {
    private static final AtomicInteger stackIdGenerator = new AtomicInteger(0);
    private static final String STACK_FILE_NAME = "stack";
    private final int stackId = stackIdGenerator.getAndIncrement();
    private final int frameSize;
    private final int numOfMemoryFrames;
    private final ArrayDeque<ByteBuffer> fullBuffers;
    private final ArrayDeque<ByteBuffer> emptyBuffers;
    private int totalWriteCount = 0;
    private int totalReadCount = 0;
    private final File file;
    private final RandomAccessFile iostream;
    private final byte[] frame;

    public FrameStack(String dir, int frameSize, int numOfMemoryFrames) throws HyracksDataException, FileNotFoundException {
        this.frameSize = frameSize;
        this.numOfMemoryFrames = numOfMemoryFrames;
        this.fullBuffers = numOfMemoryFrames <= 0 ? null : new ArrayDeque();
        ArrayDeque arrayDeque = this.emptyBuffers = numOfMemoryFrames <= 0 ? null : new ArrayDeque();
        this.file = StoragePathUtil.createFile((String)(dir == null ? "" : (dir.endsWith(File.separator) ? dir : dir + File.separator)) + STACK_FILE_NAME, this.stackId);
        this.iostream = new RandomAccessFile(this.file, "rw");
        this.frame = new byte[frameSize];
    }

    public int remaining() {
        return this.totalWriteCount - this.totalReadCount;
    }

    public synchronized void push(ByteBuffer buffer) throws IOException {
        int diff = this.totalWriteCount - this.totalReadCount;
        if (diff < this.numOfMemoryFrames) {
            ByteBuffer aBuffer = this.allocate();
            aBuffer.put(buffer.array());
            aBuffer.flip();
            this.fullBuffers.push(aBuffer);
        } else {
            long position = (long)(diff - this.numOfMemoryFrames) * (long)this.frameSize;
            if (position != this.iostream.getFilePointer()) {
                this.iostream.seek(position);
            }
            this.iostream.write(buffer.array());
        }
        ++this.totalWriteCount;
    }

    private ByteBuffer allocate() {
        ByteBuffer aBuffer = this.emptyBuffers.poll();
        if (aBuffer == null) {
            aBuffer = ByteBuffer.allocate(this.frameSize);
        }
        aBuffer.clear();
        return aBuffer;
    }

    public synchronized void pop(ByteBuffer dest) throws IOException {
        dest.clear();
        int diff = this.totalWriteCount - this.totalReadCount - 1;
        if (diff >= 0) {
            if (diff < this.numOfMemoryFrames) {
                ++this.totalReadCount;
                ByteBuffer aBuffer = this.fullBuffers.pop();
                this.emptyBuffers.push(aBuffer);
                dest.put(aBuffer.array());
            } else {
                long position = (long)(diff - this.numOfMemoryFrames) * (long)this.frameSize;
                this.iostream.seek(position);
                this.iostream.readFully(this.frame);
                dest.put(this.frame);
            }
        }
        dest.flip();
    }

    @Override
    public void close() throws IOException {
        this.iostream.close();
        Files.delete(this.file.toPath());
    }
}

