/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.utils;

import java.io.DataOutput;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public final class RandomHelper {
    private final SecureRandom random;
    private double seed;
    private boolean isFirst;
    private final AMutableDouble aDouble = new AMutableDouble(0.0);
    private final ISerializerDeserializer doubleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput dataOutput = this.resultStorage.getDataOutput();

    public RandomHelper(boolean withSeed) throws HyracksDataException {
        if (withSeed) {
            try {
                this.random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeDataException(ErrorCode.ILLEGAL_STATE, new Serializable[]{"random()"});
            }
        } else {
            this.random = new SecureRandom();
        }
        this.isFirst = true;
    }

    public void setSeed(double seedVal) throws HyracksDataException {
        if (this.isFirst || seedVal != this.seed) {
            this.seed = seedVal;
            this.isFirst = false;
            this.random.setSeed(Double.doubleToLongBits(seedVal));
        }
    }

    public void nextDouble(IPointable resultPointable) throws HyracksDataException {
        this.aDouble.setValue(this.random.nextDouble());
        this.resultStorage.reset();
        this.doubleSerde.serialize((Object)this.aDouble, this.dataOutput);
        resultPointable.set((IValueReference)this.resultStorage);
    }
}

