/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.sas;

import java.util.Locale;

public final class BlobSasPermission {
    private boolean readPermission;
    private boolean addPermission;
    private boolean createPermission;
    private boolean writePermission;
    private boolean deletePermission;
    private boolean deleteVersionPermission;
    private boolean tagsPermission;
    private boolean listPermission;
    private boolean movePermission;
    private boolean executePermission;
    private boolean immutabilityPolicyPermission;

    public static BlobSasPermission parse(String permissionString) {
        BlobSasPermission permissions = new BlobSasPermission();
        block13: for (int i = 0; i < permissionString.length(); ++i) {
            char c = permissionString.charAt(i);
            switch (c) {
                case 'r': {
                    permissions.readPermission = true;
                    continue block13;
                }
                case 'a': {
                    permissions.addPermission = true;
                    continue block13;
                }
                case 'c': {
                    permissions.createPermission = true;
                    continue block13;
                }
                case 'w': {
                    permissions.writePermission = true;
                    continue block13;
                }
                case 'd': {
                    permissions.deletePermission = true;
                    continue block13;
                }
                case 'x': {
                    permissions.deleteVersionPermission = true;
                    continue block13;
                }
                case 't': {
                    permissions.tagsPermission = true;
                    continue block13;
                }
                case 'l': {
                    permissions.listPermission = true;
                    continue block13;
                }
                case 'm': {
                    permissions.movePermission = true;
                    continue block13;
                }
                case 'e': {
                    permissions.executePermission = true;
                    continue block13;
                }
                case 'i': {
                    permissions.immutabilityPolicyPermission = true;
                    continue block13;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "%s could not be parsed from '%s' due to invalid value %s.", "Permissions", permissionString, Character.valueOf(c)));
                }
            }
        }
        return permissions;
    }

    public boolean hasReadPermission() {
        return this.readPermission;
    }

    public BlobSasPermission setReadPermission(boolean hasReadPermission) {
        this.readPermission = hasReadPermission;
        return this;
    }

    public boolean hasAddPermission() {
        return this.addPermission;
    }

    public BlobSasPermission setAddPermission(boolean hasAddPermission) {
        this.addPermission = hasAddPermission;
        return this;
    }

    public boolean hasCreatePermission() {
        return this.createPermission;
    }

    public BlobSasPermission setCreatePermission(boolean hasCreatePermission) {
        this.createPermission = hasCreatePermission;
        return this;
    }

    public boolean hasWritePermission() {
        return this.writePermission;
    }

    public BlobSasPermission setWritePermission(boolean hasWritePermission) {
        this.writePermission = hasWritePermission;
        return this;
    }

    public boolean hasDeletePermission() {
        return this.deletePermission;
    }

    public BlobSasPermission setDeletePermission(boolean hasDeletePermission) {
        this.deletePermission = hasDeletePermission;
        return this;
    }

    public boolean hasDeleteVersionPermission() {
        return this.deleteVersionPermission;
    }

    public BlobSasPermission setDeleteVersionPermission(boolean hasDeleteVersionPermission) {
        this.deleteVersionPermission = hasDeleteVersionPermission;
        return this;
    }

    public boolean hasTagsPermission() {
        return this.tagsPermission;
    }

    public BlobSasPermission setTagsPermission(boolean tagsPermission) {
        this.tagsPermission = tagsPermission;
        return this;
    }

    public boolean hasListPermission() {
        return this.listPermission;
    }

    public BlobSasPermission setListPermission(boolean hasListPermission) {
        this.listPermission = hasListPermission;
        return this;
    }

    public boolean hasMovePermission() {
        return this.movePermission;
    }

    public BlobSasPermission setMovePermission(boolean hasMovePermission) {
        this.movePermission = hasMovePermission;
        return this;
    }

    public boolean hasExecutePermission() {
        return this.executePermission;
    }

    public BlobSasPermission setExecutePermission(boolean hasExecutePermission) {
        this.executePermission = hasExecutePermission;
        return this;
    }

    public boolean hasImmutabilityPolicyPermission() {
        return this.immutabilityPolicyPermission;
    }

    public BlobSasPermission setImmutabilityPolicyPermission(boolean immutabilityPolicyPermission) {
        this.immutabilityPolicyPermission = immutabilityPolicyPermission;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.readPermission) {
            builder.append('r');
        }
        if (this.addPermission) {
            builder.append('a');
        }
        if (this.createPermission) {
            builder.append('c');
        }
        if (this.writePermission) {
            builder.append('w');
        }
        if (this.deletePermission) {
            builder.append('d');
        }
        if (this.deleteVersionPermission) {
            builder.append('x');
        }
        if (this.listPermission) {
            builder.append('l');
        }
        if (this.tagsPermission) {
            builder.append('t');
        }
        if (this.movePermission) {
            builder.append('m');
        }
        if (this.executePermission) {
            builder.append('e');
        }
        if (this.immutabilityPolicyPermission) {
            builder.append('i');
        }
        return builder.toString();
    }
}

