/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.jdbc.core;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.asterix.jdbc.core.ADBProductVersion;

public interface ADBDriverProperty {
    public String getPropertyName();

    public Function<String, ?> getValueParser();

    public Object getDefaultValue();

    public boolean isHidden();

    public static enum CatalogDataverseMode {
        CATALOG,
        CATALOG_SCHEMA;


        static CatalogDataverseMode valueOf(int n) {
            switch (n) {
                case 1: {
                    return CATALOG;
                }
                case 2: {
                    return CATALOG_SCHEMA;
                }
            }
            throw new IllegalArgumentException(String.valueOf(n));
        }
    }

    public static enum Common implements ADBDriverProperty
    {
        USER("user", Function.identity(), null, false),
        PASSWORD("password", Function.identity(), null, false),
        CONNECT_TIMEOUT("connectTimeout", Integer::parseInt, null, false),
        SOCKET_TIMEOUT("socketTimeout", Integer::parseInt, null, false),
        MAX_WARNINGS("maxWarnings", Integer::parseInt, 10, false),
        CATALOG_DATAVERSE_MODE("catalogDataverseMode", Integer::parseInt, 1, false),
        CATALOG_INCLUDES_SCHEMALESS("catalogIncludesSchemaless", Boolean::parseBoolean, false, false),
        SQL_COMPAT_MODE("sqlCompatMode", Boolean::parseBoolean, true, false),
        SSL("ssl", Boolean::parseBoolean, false, false),
        MIN_DRIVER_VERSION("minDriverVersion", Common::parseMinVersion, null, true),
        MIN_DATABASE_VERSION("minDatabaseVersion", Common::parseMinVersion, null, true),
        ACTIVE_REQUESTS_PATH("activeRequestsPath", Function.identity(), null, true);

        private final String propertyName;
        private final Function<String, ?> valueParser;
        private final Object defaultValue;
        private final boolean isHidden;

        private Common(String propertyName, Function<String, ?> valueParser, Object defaultValue, boolean isHidden) {
            this.propertyName = Objects.requireNonNull(propertyName);
            this.valueParser = Objects.requireNonNull(valueParser);
            this.defaultValue = defaultValue;
            this.isHidden = isHidden;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public Function<String, ?> getValueParser() {
            return this.valueParser;
        }

        @Override
        public Object getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public boolean isHidden() {
            return this.isHidden;
        }

        public String toString() {
            return this.getPropertyName();
        }

        public Object fetchPropertyValue(Map<ADBDriverProperty, Object> properties) {
            return properties.getOrDefault(this, this.defaultValue);
        }

        public static ADBProductVersion parseMinVersion(String text) {
            int major;
            String[] parts = text.split("\\.");
            int minor = 0;
            switch (parts.length) {
                case 2: {
                    minor = Integer.parseInt(parts[1]);
                }
                case 1: {
                    major = Integer.parseInt(parts[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(text);
                }
            }
            return new ADBProductVersion(null, text, major, minor);
        }
    }
}

