/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationKey;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.InterpolationTestHelper;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationKey;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.configuration.tree.DefaultExpressionEngine;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHierarchicalConfiguration {
    private static String[] tables = new String[]{"users", "documents"};
    private static String[][] fields = new String[][]{{"uid", "uname", "firstName", "lastName", "email"}, {"docid", "name", "creationDate", "authorID", "version"}};
    private HierarchicalConfiguration config;

    @Before
    public void setUp() throws Exception {
        this.config = new HierarchicalConfiguration();
        HierarchicalConfiguration.Node nodeTables = TestHierarchicalConfiguration.createNode("tables", null);
        for (int i = 0; i < tables.length; ++i) {
            HierarchicalConfiguration.Node nodeTable = TestHierarchicalConfiguration.createNode("table", null);
            nodeTables.addChild(nodeTable);
            HierarchicalConfiguration.Node nodeName = TestHierarchicalConfiguration.createNode("name", tables[i]);
            nodeTable.addChild(nodeName);
            HierarchicalConfiguration.Node nodeFields = TestHierarchicalConfiguration.createNode("fields", null);
            nodeTable.addChild(nodeFields);
            for (int j = 0; j < fields[i].length; ++j) {
                nodeFields.addChild(TestHierarchicalConfiguration.createFieldNode(fields[i][j]));
            }
        }
        this.config.getRoot().addChild(nodeTables);
    }

    @Test
    public void testSetRoot() {
        this.config.setRoot(new HierarchicalConfiguration.Node("test"));
        Assert.assertTrue((boolean)this.config.isEmpty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetRootNull() {
        this.config.setRoot(null);
    }

    @Test
    public void testSetRootNode() {
        this.config.setRootNode((ConfigurationNode)new DefaultConfigurationNode("testNode"));
        Assert.assertNotSame((String)"Same root node", (Object)this.config.getRootNode(), (Object)this.config.getRoot());
        Assert.assertEquals((String)"Wrong name of root node", (Object)"testNode", (Object)this.config.getRoot().getName());
        this.config.setRootNode((ConfigurationNode)new HierarchicalConfiguration.Node("test"));
        Assert.assertSame((String)"Wrong root node", (Object)this.config.getRootNode(), (Object)this.config.getRoot());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetRootNodeNull() {
        this.config.setRootNode(null);
    }

    @Test
    public void testIsEmpty() {
        Assert.assertFalse((boolean)this.config.isEmpty());
        HierarchicalConfiguration conf2 = new HierarchicalConfiguration();
        Assert.assertTrue((boolean)conf2.isEmpty());
        HierarchicalConfiguration.Node child1 = new HierarchicalConfiguration.Node("child1");
        HierarchicalConfiguration.Node child2 = new HierarchicalConfiguration.Node("child2");
        child1.addChild(child2);
        conf2.getRoot().addChild(child1);
        Assert.assertTrue((boolean)conf2.isEmpty());
    }

    @Test
    public void testGetProperty() {
        Assert.assertNull((Object)this.config.getProperty("tables.table.resultset"));
        Assert.assertNull((Object)this.config.getProperty("tables.table.fields.field"));
        Object prop = this.config.getProperty("tables.table(0).fields.field.name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)5L, (long)((Collection)prop).size());
        prop = this.config.getProperty("tables.table.fields.field.name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)10L, (long)((Collection)prop).size());
        prop = this.config.getProperty("tables.table.fields.field(3).name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)2L, (long)((Collection)prop).size());
        prop = this.config.getProperty("tables.table(1).fields.field(2).name");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)"creationDate", (Object)prop.toString());
    }

    @Test
    public void testSetProperty() {
        this.config.setProperty("tables.table(0).name", (Object)"resources");
        Assert.assertEquals((Object)"resources", (Object)this.config.getString("tables.table(0).name"));
        this.config.setProperty("tables.table.name", (Object)"tab1,tab2");
        Assert.assertEquals((Object)"tab1", (Object)this.config.getString("tables.table(0).name"));
        Assert.assertEquals((Object)"tab2", (Object)this.config.getString("tables.table(1).name"));
        this.config.setProperty("test.items.item", (Object)new int[]{2, 4, 8, 16});
        Assert.assertEquals((long)3L, (long)this.config.getMaxIndex("test.items.item"));
        Assert.assertEquals((long)8L, (long)this.config.getInt("test.items.item(2)"));
        this.config.setProperty("test.items.item(2)", (Object)new Integer(6));
        Assert.assertEquals((long)6L, (long)this.config.getInt("test.items.item(2)"));
        this.config.setProperty("test.items.item(2)", (Object)new int[]{7, 9, 11});
        Assert.assertEquals((long)5L, (long)this.config.getMaxIndex("test.items.item"));
        this.config.setProperty("test", (Object)Boolean.TRUE);
        this.config.setProperty("test.items", (Object)"01/01/05");
        Assert.assertEquals((long)5L, (long)this.config.getMaxIndex("test.items.item"));
        Assert.assertTrue((boolean)this.config.getBoolean("test"));
        Assert.assertEquals((Object)"01/01/05", (Object)this.config.getProperty("test.items"));
        this.config.setProperty("test.items.item", (Object)new Integer(42));
        Assert.assertEquals((long)0L, (long)this.config.getMaxIndex("test.items.item"));
        Assert.assertEquals((long)42L, (long)this.config.getInt("test.items.item"));
    }

    @Test
    public void testClear() {
        this.config.setProperty(null, (Object)"value");
        this.config.addProperty("[@attr]", (Object)"defined");
        this.config.clear();
        Assert.assertTrue((String)"Configuration not empty", (boolean)this.config.isEmpty());
    }

    @Test
    public void testClearProperty() {
        this.config.clearProperty("tables.table(0).fields.field(0).name");
        Assert.assertEquals((Object)"uname", (Object)this.config.getProperty("tables.table(0).fields.field(0).name"));
        this.config.clearProperty("tables.table(0).name");
        Assert.assertFalse((boolean)this.config.containsKey("tables.table(0).name"));
        Assert.assertEquals((Object)"firstName", (Object)this.config.getProperty("tables.table(0).fields.field(1).name"));
        Assert.assertEquals((Object)"documents", (Object)this.config.getProperty("tables.table.name"));
        this.config.clearProperty("tables.table");
        Assert.assertEquals((Object)"documents", (Object)this.config.getProperty("tables.table.name"));
        this.config.addProperty("test", (Object)"first");
        this.config.addProperty("test.level", (Object)"second");
        this.config.clearProperty("test");
        Assert.assertEquals((Object)"second", (Object)this.config.getString("test.level"));
        Assert.assertFalse((boolean)this.config.containsKey("test"));
    }

    @Test
    public void testClearTree() {
        Object prop = this.config.getProperty("tables.table(0).fields.field.name");
        Assert.assertNotNull((Object)prop);
        this.config.clearTree("tables.table(0).fields.field(3)");
        prop = this.config.getProperty("tables.table(0).fields.field.name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)4L, (long)((Collection)prop).size());
        this.config.clearTree("tables.table(0).fields");
        Assert.assertNull((Object)this.config.getProperty("tables.table(0).fields.field.name"));
        prop = this.config.getProperty("tables.table.fields.field.name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)5L, (long)((Collection)prop).size());
        this.config.clearTree("tables.table(1)");
        Assert.assertNull((Object)this.config.getProperty("tables.table.fields.field.name"));
    }

    @Test
    public void testClearTreeComplex() {
        String name;
        int count = 5;
        for (int idx = 0; idx < 5; ++idx) {
            this.config.addProperty("indexList.index(-1)[@default]", (Object)Boolean.FALSE);
            this.config.addProperty("indexList.index[@name]", (Object)("test" + idx));
            this.config.addProperty("indexList.index.dir", (Object)("testDir" + idx));
        }
        Assert.assertEquals((String)"Wrong number of nodes", (long)4L, (long)this.config.getMaxIndex("indexList.index[@name]"));
        boolean found = false;
        int idx = 0;
        while ((name = this.config.getString("indexList.index(" + idx + ")[@name]")) != null) {
            if ("test3".equals(name)) {
                Assert.assertEquals((String)"Wrong dir", (Object)"testDir3", (Object)this.config.getString("indexList.index(" + idx + ").dir"));
                this.config.clearTree("indexList.index(" + idx + ")");
                found = true;
            }
            ++idx;
        }
        Assert.assertTrue((String)"Key to remove not found", (boolean)found);
        Assert.assertEquals((String)"Wrong number of nodes after remove", (long)3L, (long)this.config.getMaxIndex("indexList.index[@name]"));
        Assert.assertEquals((String)"Wrong number of dir nodes after remove", (long)3L, (long)this.config.getMaxIndex("indexList.index.dir"));
        idx = 0;
        while ((name = this.config.getString("indexList.index(" + idx + ")[@name]")) != null) {
            if ("test3".equals(name)) {
                Assert.fail((String)"Key was not removed!");
            }
            ++idx;
        }
    }

    @Test
    public void testClearTreeHierarchy() {
        this.config.addProperty("a.b.c", (Object)"c");
        this.config.addProperty("a.b.c.d", (Object)"d");
        this.config.addProperty("a.b.c.d.e", (Object)"e");
        this.config.clearTree("a.b.c");
        Assert.assertFalse((String)"Property not removed", (boolean)this.config.containsKey("a.b.c"));
        Assert.assertFalse((String)"Sub property not removed", (boolean)this.config.containsKey("a.b.c.d"));
    }

    @Test
    public void testContainsKey() {
        Assert.assertTrue((boolean)this.config.containsKey("tables.table(0).name"));
        Assert.assertTrue((boolean)this.config.containsKey("tables.table(1).name"));
        Assert.assertFalse((boolean)this.config.containsKey("tables.table(2).name"));
        Assert.assertTrue((boolean)this.config.containsKey("tables.table(0).fields.field.name"));
        Assert.assertFalse((boolean)this.config.containsKey("tables.table(0).fields.field"));
        this.config.clearTree("tables.table(0).fields");
        Assert.assertFalse((boolean)this.config.containsKey("tables.table(0).fields.field.name"));
        Assert.assertTrue((boolean)this.config.containsKey("tables.table.fields.field.name"));
    }

    @Test
    public void testGetKeys() {
        ArrayList keys = new ArrayList();
        Iterator it = this.config.getKeys();
        while (it.hasNext()) {
            keys.add(it.next());
        }
        Assert.assertEquals((long)2L, (long)keys.size());
        Assert.assertTrue((boolean)keys.contains("tables.table.name"));
        Assert.assertTrue((boolean)keys.contains("tables.table.fields.field.name"));
        this.config.addProperty("order.key1", (Object)"value1");
        this.config.addProperty("order.key2", (Object)"value2");
        this.config.addProperty("order.key3", (Object)"value3");
        it = this.config.getKeys("order");
        Assert.assertEquals((String)"1st key", (Object)"order.key1", it.next());
        Assert.assertEquals((String)"2nd key", (Object)"order.key2", it.next());
        Assert.assertEquals((String)"3rd key", (Object)"order.key3", it.next());
    }

    @Test
    public void testGetKeysString() {
        this.config.addProperty("tables.table(0).fields.field(1).type", (Object)"VARCHAR");
        this.config.addProperty("tables.table(0)[@type]", (Object)"system");
        this.config.addProperty("tables.table(0).size", (Object)"42");
        this.config.addProperty("tables.table(0).fields.field(0).size", (Object)"128");
        this.config.addProperty("connections.connection.param.url", (Object)"url1");
        this.config.addProperty("connections.connection.param.user", (Object)"me");
        this.config.addProperty("connections.connection.param.pwd", (Object)"secret");
        this.config.addProperty("connections.connection(-1).param.url", (Object)"url2");
        this.config.addProperty("connections.connection(1).param.user", (Object)"guest");
        this.checkKeys("tables.table(1)", new String[]{"name", "fields.field.name"});
        this.checkKeys("tables.table(0)", new String[]{"name", "fields.field.name", "tables.table(0)[@type]", "size", "fields.field.type", "fields.field.size"});
        this.checkKeys("connections.connection(0).param", new String[]{"url", "user", "pwd"});
        this.checkKeys("connections.connection(1).param", new String[]{"url", "user"});
    }

    @Test
    public void testGetKeysWithKeyAsPrefix() {
        this.config.addProperty("order.key1", (Object)"value1");
        this.config.addProperty("order.key2", (Object)"value2");
        Iterator it = this.config.getKeys("order.key1");
        Assert.assertTrue((String)"no key found", (boolean)it.hasNext());
        Assert.assertEquals((String)"1st key", (Object)"order.key1", it.next());
        Assert.assertFalse((String)"more keys than expected", (boolean)it.hasNext());
    }

    @Test
    public void testGetKeysWithKeyAsPrefixMultiple() {
        this.config.addProperty("order.key1", (Object)"value1");
        this.config.addProperty("order.key1.test", (Object)"value2");
        this.config.addProperty("order.key1.test.complex", (Object)"value2");
        Iterator it = this.config.getKeys("order.key1");
        Assert.assertEquals((String)"Wrong key 1", (Object)"order.key1", it.next());
        Assert.assertEquals((String)"Wrong key 2", (Object)"order.key1.test", it.next());
        Assert.assertEquals((String)"Wrong key 3", (Object)"order.key1.test.complex", it.next());
        Assert.assertFalse((String)"More keys than expected", (boolean)it.hasNext());
    }

    @Test
    public void testAddProperty() {
        this.config.addProperty("tables.table(0).fields.field(-1).name", (Object)"phone");
        Object prop = this.config.getProperty("tables.table(0).fields.field.name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)6L, (long)((Collection)prop).size());
        this.config.addProperty("tables.table(0).fields.field.name", (Object)"fax");
        prop = this.config.getProperty("tables.table.fields.field(5).name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof List));
        List list = (List)prop;
        Assert.assertEquals((Object)"phone", list.get(0));
        Assert.assertEquals((Object)"fax", list.get(1));
        this.config.addProperty("tables.table(-1).name", (Object)"config");
        prop = this.config.getProperty("tables.table.name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)3L, (long)((Collection)prop).size());
        this.config.addProperty("tables.table(2).fields.field(0).name", (Object)"cid");
        this.config.addProperty("tables.table(2).fields.field(-1).name", (Object)"confName");
        prop = this.config.getProperty("tables.table(2).fields.field.name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)2L, (long)((Collection)prop).size());
        Assert.assertEquals((Object)"confName", (Object)this.config.getProperty("tables.table(2).fields.field(1).name"));
        this.config.addProperty("connection.user", (Object)"scott");
        this.config.addProperty("connection.passwd", (Object)"tiger");
        Assert.assertEquals((Object)"tiger", (Object)this.config.getProperty("connection.passwd"));
        DefaultConfigurationKey key = TestHierarchicalConfiguration.createConfigurationKey();
        key.append("tables").append("table").appendIndex(0);
        key.appendAttribute("tableType");
        this.config.addProperty(key.toString(), (Object)"system");
        Assert.assertEquals((Object)"system", (Object)this.config.getProperty(key.toString()));
    }

    private static DefaultConfigurationKey createConfigurationKey() {
        return new DefaultConfigurationKey(new DefaultExpressionEngine());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddPropertyInvalidKey() {
        this.config.addProperty(".", (Object)"InvalidKey");
    }

    @Test
    public void testGetMaxIndex() {
        Assert.assertEquals((long)4L, (long)this.config.getMaxIndex("tables.table(0).fields.field"));
        Assert.assertEquals((long)4L, (long)this.config.getMaxIndex("tables.table(1).fields.field"));
        Assert.assertEquals((long)1L, (long)this.config.getMaxIndex("tables.table"));
        Assert.assertEquals((long)1L, (long)this.config.getMaxIndex("tables.table.name"));
        Assert.assertEquals((long)0L, (long)this.config.getMaxIndex("tables.table(0).name"));
        Assert.assertEquals((long)0L, (long)this.config.getMaxIndex("tables.table(1).fields.field(1)"));
        Assert.assertEquals((long)-1L, (long)this.config.getMaxIndex("tables.table(2).fields"));
        int maxIdx = this.config.getMaxIndex("tables.table(0).fields.field.name");
        for (int i = 0; i <= maxIdx; ++i) {
            DefaultConfigurationKey key = new DefaultConfigurationKey(new DefaultExpressionEngine(), "tables.table(0).fields");
            key.append("field").appendIndex(i).append("name");
            Assert.assertNotNull((Object)this.config.getProperty(key.toString()));
        }
    }

    @Test
    public void testSubset() {
        Configuration subset = this.config.subset("tables.table(0)");
        Assert.assertEquals((Object)tables[0], (Object)subset.getProperty("name"));
        Object prop = subset.getProperty("fields.field.name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)5L, (long)((Collection)prop).size());
        for (int i = 0; i < fields[0].length; ++i) {
            DefaultConfigurationKey key = TestHierarchicalConfiguration.createConfigurationKey();
            key.append("fields").append("field").appendIndex(i);
            key.append("name");
            Assert.assertEquals((Object)fields[0][i], (Object)subset.getProperty(key.toString()));
        }
        Assert.assertTrue((String)"subset is not empty", (boolean)this.config.subset("tables.table(2)").isEmpty());
        subset = this.config.subset("tables.table.fields.field");
        prop = subset.getProperty("name");
        Assert.assertTrue((String)"prop is not a collection", (boolean)(prop instanceof Collection));
        Assert.assertEquals((long)10L, (long)((Collection)prop).size());
        Assert.assertEquals((Object)fields[0][0], (Object)subset.getProperty("name(0)"));
        subset = this.config.subset("tables.table.fields.field.name");
        Assert.assertTrue((String)"subset is not empty", (boolean)subset.isEmpty());
    }

    @Test
    public void testSubsetNodeWithValue() {
        this.config.setProperty("tables.table(0).fields", (Object)"My fields");
        Configuration subset = this.config.subset("tables.table(0).fields");
        Assert.assertEquals((String)"Wrong field name", (Object)fields[0][0], (Object)subset.getString("field(0).name"));
        Assert.assertEquals((String)"Wrong value of root", (Object)"My fields", (Object)subset.getString(""));
    }

    @Test
    public void testSubsetMultipleNodesWithValues() {
        this.config.setProperty("tables.table(0).fields", (Object)"My fields");
        Configuration subset = this.config.subset("tables.table.fields");
        Assert.assertEquals((String)"Wrong value of root", (Object)"My fields", (Object)subset.getString(""));
        this.config.setProperty("tables.table(1).fields", (Object)"My other fields");
        subset = this.config.subset("tables.table.fields");
        Assert.assertNull((String)"Root value is not null though there are multiple values", (Object)subset.getString(""));
    }

    @Test
    public void testConfigurationAt() {
        SubnodeConfiguration subConfig = this.config.configurationAt("tables.table(1)");
        Assert.assertEquals((String)"Wrong table name", (Object)tables[1], (Object)subConfig.getString("name"));
        List lstFlds = subConfig.getList("fields.field.name");
        Assert.assertEquals((String)"Wrong number of fields", (long)fields[1].length, (long)lstFlds.size());
        for (int i = 0; i < fields[1].length; ++i) {
            Assert.assertEquals((String)("Wrong field at position " + i), (Object)fields[1][i], lstFlds.get(i));
        }
        subConfig.setProperty("name", (Object)"testTable");
        Assert.assertEquals((String)"Change not visible in parent", (Object)"testTable", (Object)this.config.getString("tables.table(1).name"));
        this.config.setProperty("tables.table(1).fields.field(2).name", (Object)"testField");
        Assert.assertEquals((String)"Change not visible in sub config", (Object)"testField", (Object)subConfig.getString("fields.field(2).name"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConfigurationAtUnknownSubTree() {
        this.config.configurationAt("non.existing.key");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConfigurationAtMultipleNodes() {
        this.config.configurationAt("tables.table.name");
    }

    @Test
    public void testConfigurationAtClear() {
        this.config.addProperty("test.sub.test", (Object)"fail");
        Assert.assertEquals((String)"Wrong index (1)", (long)0L, (long)this.config.getMaxIndex("test"));
        SubnodeConfiguration sub = this.config.configurationAt("test.sub");
        Assert.assertEquals((String)"Wrong value", (Object)"fail", (Object)sub.getString("test"));
        sub.clear();
        Assert.assertNull((String)"Key still found", (Object)this.config.getString("test.sub.key"));
        sub.setProperty("test", (Object)"success");
        Assert.assertEquals((String)"Property not set", (Object)"success", (Object)this.config.getString("test.sub.test"));
        Assert.assertEquals((String)"Wrong index (2)", (long)0L, (long)this.config.getMaxIndex("test"));
    }

    @Test
    public void testConfigurationsAt() {
        List lstFlds = this.config.configurationsAt("tables.table(1).fields.field");
        Assert.assertEquals((String)"Wrong size of fields", (long)fields[1].length, (long)lstFlds.size());
        for (int i = 0; i < fields[1].length; ++i) {
            HierarchicalConfiguration sub = (HierarchicalConfiguration)lstFlds.get(i);
            Assert.assertEquals((String)("Wrong field at position " + i), (Object)fields[1][i], (Object)sub.getString("name"));
        }
    }

    @Test
    public void testConfigurationsAtEmpty() {
        Assert.assertTrue((String)"List is not empty", (boolean)this.config.configurationsAt("unknown.key").isEmpty());
    }

    @Test
    public void testClone() {
        Configuration copy = (Configuration)this.config.clone();
        Assert.assertTrue((boolean)(copy instanceof HierarchicalConfiguration));
        this.checkContent(copy);
    }

    @Test
    public void testCloneWithEventListeners() {
        this.config.addConfigurationListener(new ConfigurationListener(){

            public void configurationChanged(ConfigurationEvent event) {
            }
        });
        HierarchicalConfiguration copy = (HierarchicalConfiguration)this.config.clone();
        Assert.assertTrue((String)"Event listener registered at clone", (boolean)copy.getConfigurationListeners().isEmpty());
    }

    @Test
    public void testAddNodes() {
        ArrayList<HierarchicalConfiguration.Node> nodes = new ArrayList<HierarchicalConfiguration.Node>();
        nodes.add(TestHierarchicalConfiguration.createFieldNode("birthDate"));
        nodes.add(TestHierarchicalConfiguration.createFieldNode("lastLogin"));
        nodes.add(TestHierarchicalConfiguration.createFieldNode("language"));
        this.config.addNodes("tables.table(0).fields", nodes);
        Assert.assertEquals((long)7L, (long)this.config.getMaxIndex("tables.table(0).fields.field"));
        Assert.assertEquals((Object)"birthDate", (Object)this.config.getString("tables.table(0).fields.field(5).name"));
        Assert.assertEquals((Object)"lastLogin", (Object)this.config.getString("tables.table(0).fields.field(6).name"));
        Assert.assertEquals((Object)"language", (Object)this.config.getString("tables.table(0).fields.field(7).name"));
    }

    @Test
    public void testAddNodesForNonExistingKey() {
        ArrayList<HierarchicalConfiguration.Node> nodes = new ArrayList<HierarchicalConfiguration.Node>();
        nodes.add(TestHierarchicalConfiguration.createNode("usr", "scott"));
        HierarchicalConfiguration.Node nd = TestHierarchicalConfiguration.createNode("pwd", "tiger");
        nd.setAttribute(true);
        nodes.add(nd);
        this.config.addNodes("database.connection.settings", nodes);
        Assert.assertEquals((String)"Usr node not found", (Object)"scott", (Object)this.config.getString("database.connection.settings.usr"));
        Assert.assertEquals((String)"Pwd node not found", (Object)"tiger", (Object)this.config.getString("database.connection.settings[@pwd]"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddNodesWithAttributeKey() {
        ArrayList<HierarchicalConfiguration.Node> nodes = new ArrayList<HierarchicalConfiguration.Node>();
        nodes.add(TestHierarchicalConfiguration.createNode("testNode", "yes"));
        this.config.addNodes("database.connection[@settings]", nodes);
    }

    @Test
    public void testAddNodesCopy() {
        HierarchicalConfiguration configDest = new HierarchicalConfiguration();
        configDest.addProperty("test", (Object)"TEST");
        List nodes = this.config.getRootNode().getChildren();
        Assert.assertEquals((String)"Wrong number of children", (long)1L, (long)nodes.size());
        configDest.addNodes("newNodes", (Collection)nodes);
        for (int i = 0; i < tables.length; ++i) {
            String keyTab = "newNodes.tables.table(" + i + ").";
            Assert.assertEquals((String)("Table " + i + " not found"), (Object)tables[i], (Object)configDest.getString(keyTab + "name"));
            for (int j = 0; j < fields[i].length; ++j) {
                Assert.assertEquals((String)("Invalid field " + j + " in table " + i), (Object)fields[i][j], (Object)configDest.getString(keyTab + "fields.field(" + j + ").name"));
            }
        }
    }

    @Test
    public void testAddNodesAttributeNode() {
        ArrayList<HierarchicalConfiguration.Node> nodes = new ArrayList<HierarchicalConfiguration.Node>();
        HierarchicalConfiguration.Node nd = TestHierarchicalConfiguration.createNode("length", "10");
        nd.setAttribute(true);
        nodes.add(nd);
        this.config.addNodes("tables.table(0).fields.field(1)", nodes);
        Assert.assertEquals((String)"Attribute was not added", (Object)"10", (Object)this.config.getString("tables.table(0).fields.field(1)[@length]"));
    }

    @Test
    public void testNodeRemove() {
        HierarchicalConfiguration.Node node = new HierarchicalConfiguration.Node("parent", (Object)"test");
        Assert.assertFalse((boolean)node.hasChildren());
        node.removeChildren();
        Assert.assertFalse((boolean)node.remove("child"));
        node.addChild(TestHierarchicalConfiguration.createNode("test", "test"));
        Assert.assertTrue((boolean)node.hasChildren());
        Assert.assertTrue((boolean)node.remove("test"));
        Assert.assertFalse((boolean)node.hasChildren());
        for (int i = 0; i < 10; ++i) {
            node.addChild(TestHierarchicalConfiguration.createNode("child" + i, "test" + i));
        }
        Assert.assertTrue((boolean)node.hasChildren());
        Assert.assertFalse((boolean)node.remove("child"));
        Assert.assertTrue((boolean)node.remove("child2"));
        Assert.assertTrue((boolean)node.getChildren("child2").isEmpty());
        HierarchicalConfiguration.Node child = TestHierarchicalConfiguration.createNode("child0", "testChild");
        Assert.assertFalse((boolean)node.remove(child));
        node.addChild(child);
        Assert.assertTrue((boolean)node.remove(child));
        Assert.assertEquals((long)1L, (long)node.getChildren("child0").size());
        Assert.assertEquals((Object)"test0", (Object)((HierarchicalConfiguration.Node)node.getChildren("child0").get(0)).getValue());
        Assert.assertTrue((boolean)node.remove("child0"));
        Assert.assertFalse((boolean)node.remove(child));
        node.removeChildren();
        Assert.assertTrue((boolean)node.getChildren().isEmpty());
        Assert.assertFalse((boolean)node.remove(child));
    }

    @Test
    public void testNodeVisitor() {
        CountVisitor v = new CountVisitor();
        this.config.getRoot().visit((HierarchicalConfiguration.NodeVisitor)v, null);
        Assert.assertEquals((String)"Wrong number of visits", (long)28L, (long)v.beforeCount);
        Assert.assertEquals((String)"Different number of before and after visits", (long)v.beforeCount, (long)v.afterCount);
    }

    @Test
    public void testNodeVisitorKeys() {
        CountVisitor v = new CountVisitor();
        ConfigurationKey configKey = new ConfigurationKey();
        this.config.getRoot().visit((HierarchicalConfiguration.NodeVisitor)v, configKey);
        Iterator it = this.config.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assert.assertTrue((String)("Key not found in before keys: " + key), (boolean)v.beforeKeys.contains(key));
            Assert.assertTrue((String)("Key not found in after keys: " + key), (boolean)v.afterKeys.contains(key));
        }
    }

    @Test
    public void testSetExpressionEngine() {
        this.config.setExpressionEngine(null);
        Assert.assertNotNull((String)"Expression engine is null", (Object)this.config.getExpressionEngine());
        Assert.assertSame((String)"Default engine is not used", (Object)HierarchicalConfiguration.getDefaultExpressionEngine(), (Object)this.config.getExpressionEngine());
        this.config.setExpressionEngine(this.createAlternativeExpressionEngine());
        this.checkAlternativeSyntax();
    }

    @Test
    public void testSetDefaultExpressionEngine() {
        ExpressionEngine engineOld = HierarchicalConfiguration.getDefaultExpressionEngine();
        HierarchicalConfiguration.setDefaultExpressionEngine((ExpressionEngine)this.createAlternativeExpressionEngine());
        this.checkAlternativeSyntax();
        HierarchicalConfiguration.setDefaultExpressionEngine((ExpressionEngine)engineOld);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetDefaultExpressionEngineNull() {
        HierarchicalConfiguration.setDefaultExpressionEngine(null);
    }

    @Test
    public void testInitCopy() {
        HierarchicalConfiguration copy = new HierarchicalConfiguration(this.config);
        this.checkContent((Configuration)copy);
    }

    @Test
    public void testInitCopyUpdate() {
        HierarchicalConfiguration copy = new HierarchicalConfiguration(this.config);
        this.config.setProperty("tables.table(0).name", (Object)"NewTable");
        this.checkContent((Configuration)copy);
    }

    @Test
    public void testInterpolation() {
        this.config.addProperty("base.dir", (Object)"/home/foo");
        this.config.addProperty("test.absolute.dir.dir1", (Object)"${base.dir}/path1");
        this.config.addProperty("test.absolute.dir.dir2", (Object)"${base.dir}/path2");
        this.config.addProperty("test.absolute.dir.dir3", (Object)"${base.dir}/path3");
        Configuration sub = this.config.subset("test.absolute.dir");
        for (int i = 1; i < 4; ++i) {
            Assert.assertEquals((String)"Wrong interpolation in parent", (Object)("/home/foo/path" + i), (Object)this.config.getString("test.absolute.dir.dir" + i));
            Assert.assertEquals((String)"Wrong interpolation in subnode", (Object)("/home/foo/path" + i), (Object)sub.getString("dir" + i));
        }
    }

    @Test
    public void testInterpolationBasic() {
        InterpolationTestHelper.testInterpolation((Configuration)this.config);
    }

    @Test
    public void testInterpolationMultipleLevels() {
        InterpolationTestHelper.testMultipleInterpolation((Configuration)this.config);
    }

    @Test
    public void testInterpolationLoop() {
        InterpolationTestHelper.testInterpolationLoop((Configuration)this.config);
    }

    @Test
    public void testInterpolationSubset() {
        InterpolationTestHelper.testInterpolationSubset((Configuration)this.config);
    }

    @Test
    public void testInterpolationSubsetMultipleLayers() {
        this.config.clear();
        this.config.addProperty("var", (Object)"value");
        this.config.addProperty("prop2.prop[@attr]", (Object)"${var}");
        Configuration sub1 = this.config.subset("prop2");
        Configuration sub2 = sub1.subset("prop");
        Assert.assertEquals((String)"Wrong value", (Object)"value", (Object)sub2.getString("[@attr]"));
    }

    @Test
    public void testInterpolationUnknownProperty() {
        InterpolationTestHelper.testInterpolationUnknownProperty((Configuration)this.config);
    }

    @Test
    public void testInterpolationSysProperties() {
        InterpolationTestHelper.testInterpolationSystemProperties((Configuration)this.config);
    }

    @Test
    public void testInterpolationConstants() {
        InterpolationTestHelper.testInterpolationConstants((Configuration)this.config);
    }

    @Test
    public void testInterpolationEscaped() {
        InterpolationTestHelper.testInterpolationEscaped((Configuration)this.config);
    }

    @Test
    public void testInterpolator() {
        InterpolationTestHelper.testGetInterpolator((AbstractConfiguration)this.config);
    }

    @Test
    public void testInterpolatedConfiguration() {
        HierarchicalConfiguration c;
        this.config = c = (HierarchicalConfiguration)InterpolationTestHelper.testInterpolatedConfiguration((AbstractConfiguration)this.config);
        this.testGetProperty();
    }

    @Test
    public void testInitCopyNull() {
        HierarchicalConfiguration copy = new HierarchicalConfiguration(null);
        Assert.assertTrue((String)"Configuration not empty", (boolean)copy.isEmpty());
    }

    @Test
    public void testNodeParentsAfterSetRootNode() {
        DefaultConfigurationNode root = new DefaultConfigurationNode();
        DefaultConfigurationNode child1 = new DefaultConfigurationNode("child1", (Object)"test1");
        root.addChild((ConfigurationNode)child1);
        this.config.setRootNode((ConfigurationNode)root);
        this.config.addProperty("child2", (Object)"test2");
        List nodes = this.config.getExpressionEngine().query(this.config.getRootNode(), "child2");
        Assert.assertEquals((String)"Wrong number of result nodes", (long)1L, (long)nodes.size());
        ConfigurationNode child2 = (ConfigurationNode)nodes.get(0);
        Assert.assertEquals((String)"Different parent nodes", (Object)child1.getParentNode(), (Object)child2.getParentNode());
    }

    @Test
    public void testGetRootAfterSetRootNode() {
        DefaultConfigurationNode root = new DefaultConfigurationNode();
        DefaultConfigurationNode child1 = new DefaultConfigurationNode("child1", (Object)"test1");
        root.addChild((ConfigurationNode)child1);
        this.config.setRootNode((ConfigurationNode)root);
        this.config.addProperty("child2", (Object)"test2");
        HierarchicalConfiguration.Node oldRoot = this.config.getRoot();
        Assert.assertEquals((String)"Wrong number of children", (long)2L, (long)oldRoot.getChildrenCount());
    }

    @Test
    public void testGetPropertyKeyWithBrackets() {
        String key = "test.directory.platform(x86)";
        this.config.addProperty("test.directory.platform(x86)", (Object)"C:\\Temp");
        Assert.assertEquals((String)"Wrong property value", (Object)"C:\\Temp", (Object)this.config.getString("test.directory.platform(x86)"));
    }

    private void checkKeys(String prefix, String[] expected) {
        HashSet<String> values = new HashSet<String>();
        for (int i = 0; i < expected.length; ++i) {
            values.add(expected[i].startsWith(prefix) ? expected[i] : prefix + "." + expected[i]);
        }
        Iterator itKeys = this.config.getKeys(prefix);
        while (itKeys.hasNext()) {
            String key = (String)itKeys.next();
            if (!values.contains(key)) {
                Assert.fail((String)("Found unexpected key: " + key));
                continue;
            }
            values.remove(key);
        }
        Assert.assertTrue((String)("Remaining keys " + values), (boolean)values.isEmpty());
    }

    private void checkAlternativeSyntax() {
        Assert.assertNull((Object)this.config.getProperty("tables/table/resultset"));
        Assert.assertNull((Object)this.config.getProperty("tables/table/fields/field"));
        Object prop = this.config.getProperty("tables/table[0]/fields/field/name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)5L, (long)((Collection)prop).size());
        prop = this.config.getProperty("tables/table/fields/field/name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)10L, (long)((Collection)prop).size());
        prop = this.config.getProperty("tables/table/fields/field[3]/name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)2L, (long)((Collection)prop).size());
        prop = this.config.getProperty("tables/table[1]/fields/field[2]/name");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)"creationDate", (Object)prop.toString());
        HashSet keys = new HashSet();
        CollectionUtils.addAll(keys, (Iterator)this.config.getKeys());
        Assert.assertEquals((String)"Wrong number of defined keys", (long)2L, (long)keys.size());
        Assert.assertTrue((String)"Key not found", (boolean)keys.contains("tables/table/name"));
        Assert.assertTrue((String)"Key not found", (boolean)keys.contains("tables/table/fields/field/name"));
    }

    private void checkContent(Configuration c) {
        for (int i = 0; i < tables.length; ++i) {
            Assert.assertEquals((Object)tables[i], (Object)c.getString("tables.table(" + i + ").name"));
            for (int j = 0; j < fields[i].length; ++j) {
                Assert.assertEquals((Object)fields[i][j], (Object)c.getString("tables.table(" + i + ").fields.field(" + j + ").name"));
            }
        }
    }

    private ExpressionEngine createAlternativeExpressionEngine() {
        DefaultExpressionEngine engine = new DefaultExpressionEngine();
        engine.setPropertyDelimiter("/");
        engine.setIndexStart("[");
        engine.setIndexEnd("]");
        return engine;
    }

    private static HierarchicalConfiguration.Node createFieldNode(String name) {
        HierarchicalConfiguration.Node fld = TestHierarchicalConfiguration.createNode("field", null);
        fld.addChild(TestHierarchicalConfiguration.createNode("name", name));
        return fld;
    }

    private static HierarchicalConfiguration.Node createNode(String name, Object value) {
        HierarchicalConfiguration.Node node = new HierarchicalConfiguration.Node(name);
        node.setValue(value);
        return node;
    }

    static class CountVisitor
    extends HierarchicalConfiguration.NodeVisitor {
        int beforeCount;
        int afterCount;
        final Set<String> beforeKeys = new HashSet<String>();
        final Set<String> afterKeys = new HashSet<String>();

        CountVisitor() {
        }

        public void visitAfterChildren(HierarchicalConfiguration.Node node, ConfigurationKey key) {
            super.visitAfterChildren(node, key);
            ++this.afterCount;
            if (key != null) {
                this.afterKeys.add(key.toString());
            }
        }

        public void visitBeforeChildren(HierarchicalConfiguration.Node node, ConfigurationKey key) {
            super.visitBeforeChildren(node, key);
            ++this.beforeCount;
            if (key != null) {
                this.beforeKeys.add(key.toString());
            }
        }
    }
}

