/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.geometry.euclidean.AbstractLinecastPoint;
import org.apache.commons.geometry.euclidean.twod.Line;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.numbers.core.Precision;

public class LinecastPoint2D
extends AbstractLinecastPoint<Vector2D, Vector2D.Unit, Line> {
    public static final Comparator<LinecastPoint2D> ABSCISSA_ORDER = (a, b) -> {
        int cmp = Double.compare(a.getAbscissa(), b.getAbscissa());
        if (cmp == 0) {
            cmp = Vector2D.COORDINATE_ASCENDING_ORDER.compare((Vector2D)a.getNormal(), (Vector2D)b.getNormal());
        }
        return cmp;
    };

    public LinecastPoint2D(Vector2D point, Vector2D normal, Line line) {
        super(point, normal.normalize(), line);
    }

    public boolean eq(LinecastPoint2D other, Precision.DoubleEquivalence precision) {
        return ((Vector2D)this.getPoint()).eq((Vector2D)other.getPoint(), precision) && ((Vector2D.Unit)this.getNormal()).eq((Vector2D)other.getNormal(), precision);
    }

    public static void sortAndFilter(List<LinecastPoint2D> pts) {
        pts.sort(ABSCISSA_ORDER);
        double currentAbscissa = Double.POSITIVE_INFINITY;
        ArrayList<LinecastPoint2D> abscissaList = new ArrayList<LinecastPoint2D>();
        ListIterator<LinecastPoint2D> it = pts.listIterator();
        while (it.hasNext()) {
            LinecastPoint2D pt = it.next();
            if (!((Line)((Object)pt.getLine())).getPrecision().eq(currentAbscissa, pt.getAbscissa())) {
                currentAbscissa = pt.getAbscissa();
                abscissaList.clear();
                abscissaList.add(pt);
                continue;
            }
            if (LinecastPoint2D.containsEq(pt, abscissaList)) {
                it.remove();
                continue;
            }
            abscissaList.add(pt);
        }
    }

    private static boolean containsEq(LinecastPoint2D pt, List<? extends LinecastPoint2D> list) {
        Precision.DoubleEquivalence precision = ((Line)((Object)pt.getLine())).getPrecision();
        for (LinecastPoint2D linecastPoint2D : list) {
            if (!linecastPoint2D.eq(pt, precision)) continue;
            return true;
        }
        return false;
    }
}

