/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.jmh;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.input.QueueInputStream;
import org.apache.commons.io.output.QueueOutputStream;
import org.apache.commons.lang3.RandomUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Group;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.SampleTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Group)
public class QueueStreamBenchmark {
    private static final int CAPACITY = 0x100000;
    private static final int BUFFER_SIZE = 1024;
    private final BlockingQueue<Integer> queue = new LinkedBlockingQueue<Integer>(0x100000);
    private final QueueInputStream inputStream = QueueInputStream.builder().setBlockingQueue(this.queue).get();
    private final QueueOutputStream outputStream = this.inputStream.newQueueOutputStream();
    private final byte[] input = RandomUtils.insecure().randomBytes(0x100000);
    private final byte[] output = new byte[1024];

    @Benchmark
    @Group(value="streams")
    public void input(Blackhole bh) throws Exception {
        int len;
        for (int received = 0; received < 0x100000; received += len) {
            len = this.inputStream.read(this.output, 0, 1024);
            bh.consume((Object)this.output);
        }
    }

    @Benchmark
    @Group(value="streams")
    public void output() throws Exception {
        int len;
        for (int sent = 0; sent < 0x100000; sent += len) {
            len = Math.min(0x100000 - sent, 1024);
            this.outputStream.write(this.input, sent, len);
        }
    }
}

