/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheFactory;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheManager;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheMonitor;
import org.apache.commons.jcs3.auxiliary.remote.RemoteLocation;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;

public class TestRemoteCacheFactory
extends RemoteCacheFactory {
    protected ConcurrentMap<RemoteLocation, RemoteCacheManager> managers;

    public RemoteCacheManager getManager(IRemoteCacheAttributes cattr) {
        RemoteCacheAttributes rca = (RemoteCacheAttributes)cattr.clone();
        if (rca.getRemoteLocation() == null) {
            rca.setRemoteLocation("", 1099);
        }
        return (RemoteCacheManager)this.managers.get(rca.getRemoteLocation());
    }

    public RemoteCacheManager getManager(IRemoteCacheAttributes cattr, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        RemoteCacheAttributes rca = (RemoteCacheAttributes)cattr.clone();
        if (rca.getRemoteLocation() == null) {
            rca.setRemoteLocation("", 1099);
        }
        return this.managers.computeIfAbsent(rca.getRemoteLocation(), key -> new TestRemoteCacheManager((IRemoteCacheAttributes)rca, cacheMgr, null, cacheEventLogger, elementSerializer));
    }

    public void initialize() {
        this.managers = new ConcurrentHashMap<RemoteLocation, RemoteCacheManager>();
    }

    public void dispose() {
        this.managers.values().forEach(RemoteCacheManager::release);
        this.managers.clear();
    }

    public class TestRemoteCacheManager
    extends RemoteCacheManager {
        protected TestRemoteCacheManager(IRemoteCacheAttributes cattr, ICompositeCacheManager cacheMgr, RemoteCacheMonitor monitor, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
            super(cattr, cacheMgr, monitor, cacheEventLogger, elementSerializer);
        }

        protected void lookupRemoteService() throws IOException {
        }

        public void removeRemoteCacheListener(IRemoteCacheAttributes cattr) throws IOException {
        }
    }
}

