/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.util.concurrent.atomic.AtomicInteger;

public class Waiter {
    private static AtomicInteger instanceCount = new AtomicInteger();
    private boolean active = false;
    private boolean valid = true;
    private long latency = 0L;
    private long lastPassivated = 0L;
    private long lastIdleTimeMs = 0L;
    private long passivationCount = 0L;
    private long validationCount = 0L;
    private final int id = instanceCount.getAndIncrement();

    public Waiter(boolean active, boolean valid, long latency) {
        this.active = active;
        this.valid = valid;
        this.latency = latency;
        this.lastPassivated = System.currentTimeMillis();
    }

    public void doWait() {
        try {
            Thread.sleep(this.latency);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        boolean activeState = this.active;
        if (activeState == active) {
            return;
        }
        this.active = active;
        long currentTime = System.currentTimeMillis();
        if (active) {
            this.lastIdleTimeMs = currentTime - this.lastPassivated;
        } else {
            this.lastPassivated = currentTime;
            ++this.passivationCount;
        }
    }

    public long getLatency() {
        return this.latency;
    }

    public void setLatency(long latency) {
        this.latency = latency;
    }

    public boolean isValid() {
        ++this.validationCount;
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public long getLastPassivated() {
        return this.lastPassivated;
    }

    public long getLastIdleTimeMs() {
        return this.lastIdleTimeMs;
    }

    public long getValidationCount() {
        return this.validationCount;
    }

    public long getPassivationCount() {
        return this.passivationCount;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Waiter)) {
            return false;
        }
        return obj.hashCode() == this.id;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("ID = " + this.id + '\n');
        buff.append("valid = " + this.valid + '\n');
        buff.append("active = " + this.active + '\n');
        buff.append("lastPassivated = " + this.lastPassivated + '\n');
        buff.append("lastIdleTimeMs = " + this.lastIdleTimeMs + '\n');
        buff.append("latency = " + this.latency + '\n');
        return buff.toString();
    }
}

